/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.queue.impl.sender;

import io.advantageous.qbit.queue.Queue;
import io.advantageous.qbit.queue.impl.sender.AbstractBasicSendQueue;
import java.util.concurrent.TransferQueue;
import org.slf4j.LoggerFactory;

public class BasicSendQueueWithTransferQueue<T>
extends AbstractBasicSendQueue<T> {
    private final TransferQueue<Object> queue;
    private final int checkBusyEvery;
    private int checkEveryCount = 0;

    public BasicSendQueueWithTransferQueue(String name, int batchSize, TransferQueue<Object> queue, int checkBusyEvery, Queue<T> owner) {
        super(queue, owner, batchSize, name + "| TQ SEND QUEUE", LoggerFactory.getLogger(BasicSendQueueWithTransferQueue.class));
        this.queue = queue;
        this.checkBusyEvery = checkBusyEvery;
    }

    @Override
    public final boolean shouldBatch() {
        return !this.queue.hasWaitingConsumer();
    }

    @Override
    protected final boolean flushIfOverBatch() {
        if (this.index >= this.batchSize) {
            return this.sendLocalQueue();
        }
        ++this.checkEveryCount;
        if (this.checkEveryCount > this.checkBusyEvery) {
            this.checkEveryCount = 0;
            if (this.queue.hasWaitingConsumer()) {
                return this.sendLocalQueue();
            }
        }
        return true;
    }

    @Override
    protected final boolean sendArray(Object[] array) {
        return this.queue.offer(array);
    }
}

