/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.reactive;

import io.advantageous.qbit.reactive.AsyncFutureCallback;
import io.advantageous.qbit.reactive.Callback;
import io.advantageous.qbit.reactive.Reactor;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;

public class CallbackBuilder {
    private Reactor reactor;
    private Callback callback;
    private Runnable onTimeout;
    private long timeoutDuration = -1L;
    private TimeUnit timeoutTimeUnit = TimeUnit.SECONDS;
    private Consumer<Throwable> onError;

    private CallbackBuilder(Reactor reactor) {
        this.reactor = reactor;
    }

    private CallbackBuilder() {
    }

    @Deprecated
    public static CallbackBuilder callbackBuilder(Reactor reactor) {
        return new CallbackBuilder(reactor);
    }

    public static CallbackBuilder newCallbackBuilderWithReactor(Reactor reactor) {
        return new CallbackBuilder(reactor);
    }

    @Deprecated
    public static CallbackBuilder callbackBuilder() {
        return new CallbackBuilder();
    }

    public static CallbackBuilder newCallbackBuilder() {
        return new CallbackBuilder();
    }

    @Deprecated
    public Reactor getReactor() {
        return this.reactor;
    }

    @Deprecated
    public <T> Callback<T> getCallback() {
        return this.callback;
    }

    @Deprecated
    public CallbackBuilder setCallback(Callback callback) {
        this.callback = callback;
        return this;
    }

    @Deprecated
    public <T> CallbackBuilder setCallback(Class<T> returnType, Callback<T> callback) {
        return this.withCallback(returnType, callback);
    }

    public <T> CallbackBuilder withCallback(Class<T> returnType, Callback<T> callback) {
        this.callback = callback;
        return this;
    }

    public <T> CallbackBuilder delegate(Callback<T> callback) {
        this.withErrorHandler(callback::onError);
        this.withTimeoutHandler(callback::onTimeout);
        return this;
    }

    public <T> CallbackBuilder wrap(Callback<T> callback) {
        this.withErrorHandler(callback::onError);
        this.withTimeoutHandler(callback::onTimeout);
        this.withCallback(callback);
        return this;
    }

    public <T> CallbackBuilder delegateWithLogging(Callback<T> callback, Logger logger, String operationName) {
        this.withErrorHandler(throwable -> {
            logger.error(operationName + " ERROR ", throwable);
            callback.onError((Throwable)throwable);
        });
        this.withTimeoutHandler(() -> {
            logger.error(operationName + " TIMED OUT ");
            callback.onTimeout();
        });
        return this;
    }

    public <T> CallbackBuilder wrapWithLogging(Callback<T> callback, Logger logger, String operationName) {
        this.withErrorHandler(throwable -> {
            logger.error(operationName + " error ", throwable);
            callback.onError((Throwable)throwable);
        });
        this.withTimeoutHandler(() -> {
            logger.error(operationName + " TIMED OUT ");
            callback.onTimeout();
        });
        this.withCallback(callback);
        return this;
    }

    public <T> CallbackBuilder withCallback(Callback<T> callback) {
        this.callback = callback;
        return this;
    }

    public <T> CallbackBuilder withListCallback(Class<T> componentClass, Callback<List<T>> callback) {
        this.callback = callback;
        return this;
    }

    public <T> CallbackBuilder withSetCallback(Class<T> componentClass, Callback<Set<T>> callback) {
        this.callback = callback;
        return this;
    }

    public <T> CallbackBuilder withCollectionCallback(Class<T> componentClass, Callback<Collection<T>> callback) {
        this.callback = callback;
        return this;
    }

    public <K, V> CallbackBuilder withMapCallback(Class<K> keyClass, Class<V> valueClass, Callback<Map<K, V>> callback) {
        this.callback = callback;
        return this;
    }

    public CallbackBuilder withBooleanCallback(Callback<Boolean> callback) {
        this.callback = callback;
        return this;
    }

    public CallbackBuilder withIntCallback(Callback<Integer> callback) {
        this.callback = callback;
        return this;
    }

    public CallbackBuilder withLongCallback(Callback<Long> callback) {
        this.callback = callback;
        return this;
    }

    public CallbackBuilder withStringCallback(Callback<String> callback) {
        this.callback = callback;
        return this;
    }

    public CallbackBuilder withOptionalStringCallback(Callback<Optional<String>> callback) {
        this.callback = callback;
        return this;
    }

    public <T> CallbackBuilder withOptionalCallback(Class<T> cls, Callback<Optional<T>> callback) {
        this.callback = callback;
        return this;
    }

    @Deprecated
    public Runnable getOnTimeout() {
        return this.onTimeout;
    }

    @Deprecated
    public CallbackBuilder setOnTimeout(Runnable onTimeout) {
        this.onTimeout = onTimeout;
        return this;
    }

    public CallbackBuilder withTimeoutHandler(Runnable timeoutHandler) {
        this.onTimeout = timeoutHandler;
        return this;
    }

    @Deprecated
    public long getTimeoutDuration() {
        return this.timeoutDuration;
    }

    @Deprecated
    public CallbackBuilder setTimeoutDuration(long timeoutDuration) {
        this.timeoutDuration = timeoutDuration;
        return this;
    }

    public CallbackBuilder withTimeout(long timeoutDuration) {
        this.timeoutDuration = timeoutDuration;
        return this;
    }

    @Deprecated
    public TimeUnit getTimeoutTimeUnit() {
        return this.timeoutTimeUnit;
    }

    @Deprecated
    public CallbackBuilder setTimeoutTimeUnit(TimeUnit timeoutTimeUnit) {
        this.timeoutTimeUnit = timeoutTimeUnit;
        return this;
    }

    public CallbackBuilder withTimeoutTimeUnit(TimeUnit timeoutTimeUnit) {
        this.timeoutTimeUnit = timeoutTimeUnit;
        return this;
    }

    public Consumer<Throwable> getOnError() {
        return this.onError;
    }

    @Deprecated
    public CallbackBuilder setOnError(Consumer<Throwable> onError) {
        this.onError = onError;
        return this;
    }

    public CallbackBuilder withErrorHandler(Consumer<Throwable> onError) {
        this.onError = onError;
        return this;
    }

    public <T> AsyncFutureCallback<T> build() {
        if (this.getOnError() != null || this.getOnTimeout() != null || this.timeoutDuration != -1L) {
            if (this.timeoutDuration == -1L) {
                this.timeoutDuration = 30L;
            }
            if (this.reactor != null) {
                return this.reactor.callbackWithTimeoutAndErrorHandlerAndOnTimeout(this.getCallback(), this.getTimeoutDuration(), this.getTimeoutTimeUnit(), this.getOnTimeout(), this.getOnError());
            }
            return new AsyncFutureCallback<T>(){

                @Override
                public boolean checkTimeOut(long now) {
                    throw new IllegalStateException("You need to register a reactor to use this feature");
                }

                @Override
                public void run() {
                    throw new IllegalStateException("You need to register a reactor to use this feature");
                }

                @Override
                public boolean cancel(boolean mayInterruptIfRunning) {
                    throw new IllegalStateException("You need to register a reactor to use this feature");
                }

                @Override
                public boolean isCancelled() {
                    throw new IllegalStateException("You need to register a reactor to use this feature");
                }

                @Override
                public boolean isDone() {
                    throw new IllegalStateException("You need to register a reactor to use this feature");
                }

                @Override
                public T get() {
                    throw new IllegalStateException("You need to register a reactor to use this feature");
                }

                @Override
                public T get(long timeout, TimeUnit unit) {
                    throw new IllegalStateException("You need to register a reactor to use this feature");
                }

                @Override
                public void accept(T t) {
                    CallbackBuilder.this.getCallback().accept(t);
                }

                @Override
                public void onError(Throwable error) {
                    CallbackBuilder.this.getOnError().accept(error);
                }

                @Override
                public void onTimeout() {
                    CallbackBuilder.this.getOnTimeout().run();
                }
            };
        }
        if (this.reactor != null) {
            return this.reactor.callback(this.getCallback());
        }
        final Callback<T> callback = this.getCallback();
        return new AsyncFutureCallback<T>(){

            @Override
            public boolean checkTimeOut(long now) {
                return false;
            }

            @Override
            public void accept(T t) {
                callback.accept(t);
            }

            @Override
            public void onError(Throwable error) {
                callback.onError(error);
            }

            @Override
            public void run() {
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                throw new IllegalStateException("You need to register a reactor to use this feature");
            }

            @Override
            public boolean isCancelled() {
                throw new IllegalStateException("You need to register a reactor to use this feature");
            }

            @Override
            public boolean isDone() {
                throw new IllegalStateException("You need to register a reactor to use this feature");
            }

            @Override
            public T get() {
                throw new IllegalStateException("You need to register a reactor to use this feature");
            }

            @Override
            public T get(long timeout, TimeUnit unit) {
                throw new IllegalStateException("You need to register a reactor to use this feature");
            }
        };
    }

    public <T> AsyncFutureCallback<T> build(Class<T> returnType) {
        return this.build();
    }

    public <T> AsyncFutureCallback<T> build(Callback<T> callback) {
        this.withCallback(callback);
        return this.build();
    }
}

