/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.reactive;

import io.advantageous.qbit.reactive.CallbackCoordinator;
import io.advantageous.qbit.reactive.Reactor;
import java.util.concurrent.TimeUnit;

public class CoordinatorBuilder {
    private final Reactor reactor;
    private CallbackCoordinator coordinator;
    private long startTime = -1L;
    private long timeoutDuration = 5L;
    private TimeUnit timeoutTimeUnit = TimeUnit.SECONDS;
    private Runnable timeOutHandler;
    private Runnable finishedHandler;

    public CoordinatorBuilder(Reactor reactor) {
        this.reactor = reactor;
    }

    public static CoordinatorBuilder coordinatorBuilder(Reactor reactor) {
        return new CoordinatorBuilder(reactor);
    }

    public Reactor getReactor() {
        return this.reactor;
    }

    public CallbackCoordinator getCoordinator() {
        return this.coordinator;
    }

    public CoordinatorBuilder setCoordinator(CallbackCoordinator coordinator) {
        this.coordinator = coordinator;
        return this;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public CoordinatorBuilder setStartTime(long startTime) {
        this.startTime = startTime;
        return this;
    }

    public long getTimeoutDuration() {
        return this.timeoutDuration;
    }

    public CoordinatorBuilder setTimeoutDuration(long timeoutDuration) {
        this.timeoutDuration = timeoutDuration;
        return this;
    }

    public TimeUnit getTimeoutTimeUnit() {
        return this.timeoutTimeUnit;
    }

    public CoordinatorBuilder setTimeoutTimeUnit(TimeUnit timeoutTimeUnit) {
        this.timeoutTimeUnit = timeoutTimeUnit;
        return this;
    }

    public Runnable getTimeOutHandler() {
        return this.timeOutHandler;
    }

    public CoordinatorBuilder setTimeOutHandler(Runnable timeOutHandler) {
        this.timeOutHandler = timeOutHandler;
        return this;
    }

    public CoordinatorBuilder setFinishedHandler(Runnable finishedHandler) {
        this.finishedHandler = finishedHandler;
        return this;
    }

    public Runnable getFinishedHandler() {
        return this.finishedHandler;
    }

    public CallbackCoordinator build() {
        return this.reactor.coordinateWithTimeout(this.coordinator, this.getStartTime(), this.getTimeoutDuration(), this.getTimeoutTimeUnit(), this.getTimeOutHandler(), this.getFinishedHandler());
    }
}

