/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.reactive;

import java.util.concurrent.atomic.AtomicInteger;

public class CountDownAsyncLatch {
    private final Runnable allDone;
    private final AtomicInteger count = new AtomicInteger();

    public CountDownAsyncLatch(int count, Runnable allDone) {
        this.count.set(count);
        this.allDone = allDone;
    }

    public static CountDownAsyncLatch countDownLatch(int count, Runnable allDone) {
        return new CountDownAsyncLatch(count, allDone);
    }

    public void countDown() {
        int c = this.count.get();
        if (c <= 0) {
            return;
        }
        while (!this.count.compareAndSet(c, c - 1)) {
            c = this.count.get();
        }
        if (c - 1 == 0) {
            this.allDone.run();
        }
    }
}

