/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.reactive;

import io.advantageous.qbit.reactive.AsyncFutureCallback;
import io.advantageous.qbit.reactive.Callback;
import io.advantageous.qbit.reactive.CallbackBuilder;
import io.advantageous.qbit.reactive.CallbackCoordinator;
import io.advantageous.qbit.reactive.CoordinatorBuilder;
import io.advantageous.qbit.reactive.impl.AsyncFutureCallbackImpl;
import io.advantageous.qbit.service.ServiceProxyUtils;
import io.advantageous.qbit.time.Duration;
import io.advantageous.qbit.util.Timer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.slf4j.Logger;

public class Reactor {
    private final BlockingQueue<AsyncFutureCallback<?>> futureQueue = new LinkedTransferQueue();
    private final BlockingQueue<AsyncFutureCallback<?>> removeFutureQueue = new LinkedTransferQueue();
    private final BlockingQueue<CallbackCoordinator> coordinatorQueue = new LinkedTransferQueue<CallbackCoordinator>();
    private final BlockingQueue<CallbackCoordinator> removeCoordinatorQueue = new LinkedTransferQueue<CallbackCoordinator>();
    private final Set<AsyncFutureCallback<?>> futureList = new HashSet();
    private final Set<CallbackCoordinator> coordinatorList = new HashSet<CallbackCoordinator>();
    private final Timer timer;
    private final long defaultTimeOut;
    private long currentTime;
    private List<RepeatingTask> repeatingTasks = new ArrayList<RepeatingTask>(1);
    private List<Object> collaboratingServices = new ArrayList<Object>(1);

    public Reactor(Timer timer, long defaultTimeOut, TimeUnit timeUnit) {
        this.timer = timer;
        this.currentTime = timer.now();
        this.defaultTimeOut = timeUnit.toMillis(defaultTimeOut);
    }

    public void addServiceToFlush(Object serviceObject) {
        this.collaboratingServices.add(serviceObject);
    }

    public void addRepeatingTask(long repeatEvery, TimeUnit timeUnit, Runnable task) {
        this.repeatingTasks.add(new RepeatingTask(task, timeUnit, repeatEvery));
    }

    public void addRepeatingTask(Duration repeatEvery, Runnable task) {
        this.repeatingTasks.add(new RepeatingTask(task, repeatEvery.getTimeUnit(), repeatEvery.getDuration()));
    }

    public void process() {
        this.drainQueues();
        this.currentTime = this.timer.now();
        this.monitorCallBacks();
        this.monitorCallbackCoordinators();
        this.collaboratingServices.forEach(ServiceProxyUtils::flushServiceProxy);
        this.processRepeatingTasks();
    }

    public void processRepeatingTasks() {
        this.repeatingTasks.forEach(repeatingTask -> {
            if (this.currentTime - ((RepeatingTask)repeatingTask).lastTimeInvoked > ((RepeatingTask)repeatingTask).repeatEveryMS) {
                ((RepeatingTask)repeatingTask).lastTimeInvoked = this.currentTime;
                ((RepeatingTask)repeatingTask).task.run();
            }
        });
    }

    private boolean drainQueues() {
        CallbackCoordinator callable = (CallbackCoordinator)this.coordinatorQueue.poll();
        while (callable != null) {
            this.coordinatorList.add(callable);
            callable = (CallbackCoordinator)this.coordinatorQueue.poll();
        }
        callable = (CallbackCoordinator)this.removeCoordinatorQueue.poll();
        while (callable != null) {
            this.coordinatorList.remove(callable);
            callable = (CallbackCoordinator)this.coordinatorQueue.poll();
        }
        AsyncFutureCallback futureCallback = (AsyncFutureCallback)this.futureQueue.poll();
        while (futureCallback != null) {
            this.futureList.add(futureCallback);
            futureCallback = (AsyncFutureCallback)this.futureQueue.poll();
        }
        futureCallback = (AsyncFutureCallback)this.removeFutureQueue.poll();
        while (futureCallback != null) {
            this.futureList.remove(futureCallback);
            futureCallback = (AsyncFutureCallback)this.futureQueue.poll();
        }
        return false;
    }

    public CallbackBuilder callbackBuilder() {
        return CallbackBuilder.newCallbackBuilderWithReactor(this);
    }

    public CoordinatorBuilder coordinatorBuilder() {
        return CoordinatorBuilder.coordinatorBuilder(this);
    }

    public <T> AsyncFutureCallback<T> callback(Callback<T> callback) {
        return this.callbackWithTimeout(callback, this.defaultTimeOut, TimeUnit.MILLISECONDS);
    }

    public <T> AsyncFutureCallback<T> callback(Class<T> cls, Callback<T> callback) {
        return this.callbackWithTimeout(callback, this.defaultTimeOut, TimeUnit.MILLISECONDS);
    }

    public <T> AsyncFutureCallback<T> callbackWithTimeout(Callback<T> callback, long timeoutDuration, TimeUnit timeUnit) {
        return this.callbackWithTimeoutAndErrorHandler(callback, timeoutDuration, timeUnit, null);
    }

    public <T> AsyncFutureCallback<T> callbackWithTimeoutAndErrorHandler(Callback<T> callback, long timeoutDuration, TimeUnit timeUnit, Consumer<Throwable> onError) {
        return this.callbackWithTimeoutAndErrorHandlerAndOnTimeout(callback, timeoutDuration, timeUnit, null, onError);
    }

    public <T> AsyncFutureCallback<T> callbackWithTimeoutAndErrorHandlerAndOnTimeout(Callback<T> callback, long timeoutDuration, TimeUnit timeUnit, Runnable onTimeout, Consumer<Throwable> onError) {
        AtomicReference<AsyncFutureCallback<T>> ref = new AtomicReference<AsyncFutureCallback<T>>();
        AsyncFutureCallbackImpl<T> asyncFutureCallback = AsyncFutureCallbackImpl.callback(callback, this.currentTime, timeUnit.toMillis(timeoutDuration), this.createOnFinished(ref), onTimeout, onError);
        ref.set(asyncFutureCallback);
        this.addCallback(asyncFutureCallback);
        return asyncFutureCallback;
    }

    public <T> void addCallback(AsyncFutureCallbackImpl<T> asyncFutureCallback) {
        this.futureQueue.add(asyncFutureCallback);
    }

    private <T> Runnable createOnFinished(AtomicReference<AsyncFutureCallback<T>> ref) {
        return () -> this.removeFuture((AsyncFutureCallback)ref.get());
    }

    public <T> AsyncFutureCallback<T> callbackWithTimeout(Class<T> cls, Callback<T> callback, long timeoutDuration, TimeUnit timeUnit) {
        return this.callbackWithTimeout(callback, timeoutDuration, timeUnit);
    }

    public <T> AsyncFutureCallback<T> callbackWithTimeoutAndErrorHandler(Class<T> cls, Callback<T> callback, long timeoutDuration, TimeUnit timeUnit, Consumer<Throwable> onError) {
        return this.callbackWithTimeoutAndErrorHandler(callback, timeoutDuration, timeUnit, onError);
    }

    public CallbackCoordinator coordinate(CallbackCoordinator coordinator) {
        this.coordinatorQueue.add(coordinator);
        return coordinator;
    }

    public CallbackCoordinator removeCoordinator(CallbackCoordinator coordinator) {
        this.removeCoordinatorQueue.add(coordinator);
        return coordinator;
    }

    public <T> AsyncFutureCallback<T> removeFuture(AsyncFutureCallback<T> asyncFutureCallback) {
        this.removeFutureQueue.offer(asyncFutureCallback);
        return asyncFutureCallback;
    }

    public CallbackCoordinator coordinateWithTimeout(final CallbackCoordinator coordinator, long startTime, long timeoutDuration, TimeUnit timeUnit, final Runnable timeOutHandler, final Runnable finishedHandler) {
        final long timeoutDurationMS = timeUnit.toMillis(timeoutDuration);
        final long theStartTime = startTime == -1L ? this.currentTime : startTime;
        CallbackCoordinator wrapper = new CallbackCoordinator(){
            AtomicBoolean done = new AtomicBoolean();

            @Override
            public boolean checkComplete() {
                if (this.done.get()) {
                    return true;
                }
                if (coordinator.checkComplete()) {
                    this.done.set(true);
                }
                return this.done.get();
            }

            @Override
            public boolean timedOut(long now) {
                if (this.startTime() == -1L || this.timeOutDuration() == -1L) {
                    return false;
                }
                if (now - this.startTime() > this.timeOutDuration()) {
                    if (!this.done.get()) {
                        timeOutHandler.run();
                        this.done.set(true);
                    }
                    return true;
                }
                return false;
            }

            @Override
            public long timeOutDuration() {
                return coordinator.timeOutDuration() == -1L ? timeoutDurationMS : coordinator.timeOutDuration();
            }

            @Override
            public long startTime() {
                return coordinator.startTime() == -1L ? theStartTime : coordinator.startTime();
            }

            @Override
            public void finished() {
                if (this.checkComplete()) {
                    Reactor.this.removeCoordinator(this);
                }
                if (finishedHandler != null) {
                    finishedHandler.run();
                }
                coordinator.finished();
            }

            @Override
            public void cancel() {
                this.done.set(true);
                Reactor.this.removeCoordinator(this);
                coordinator.cancel();
            }
        };
        this.coordinatorQueue.add(wrapper);
        return wrapper;
    }

    private void monitorCallBacks() {
        if (this.futureList.size() > 0) {
            ArrayList removeList = new ArrayList(this.futureList.size());
            long now = this.currentTime;
            for (AsyncFutureCallback<?> callback : this.futureList) {
                if (callback.isDone()) {
                    callback.run();
                    removeList.add(callback);
                    continue;
                }
                if (!callback.checkTimeOut(now)) continue;
                removeList.add(callback);
            }
            this.futureList.removeAll(removeList);
        }
    }

    private void monitorCallbackCoordinators() {
        if (this.coordinatorList.size() > 0) {
            ArrayList<CallbackCoordinator> removeList = new ArrayList<CallbackCoordinator>(this.coordinatorList.size());
            for (CallbackCoordinator callable : this.coordinatorList) {
                if (callable.checkComplete()) {
                    callable.finished();
                    removeList.add(callable);
                    continue;
                }
                if (!callable.timedOut(this.currentTime)) continue;
                removeList.add(callable);
            }
            this.coordinatorList.removeAll(removeList);
        }
    }

    public <T> Callback<T> wrapCallback(final String operationDescription, final Callback<T> callback, final Logger logger) {
        AsyncFutureCallback reactiveCallback = this.callbackBuilder().withCallback(new Callback<T>(){

            @Override
            public void accept(T t) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{} returned {}", (Object)operationDescription, t);
                }
                callback.returnThis(t);
            }
        }).withErrorHandler(error -> {
            logger.error(String.format("ERROR calling %s", operationDescription), error);
            callback.onError((Throwable)error);
        }).withTimeoutHandler(() -> {
            logger.error("TIMEOUT calling {}", (Object)operationDescription);
            callback.onTimeout();
        }).build();
        return reactiveCallback;
    }

    public <T> Callback<T> wrapCallbackErrors(final String operationDescription, final Callback<T> callback, Callback<?> errorHandler, final Logger logger) {
        return this.callbackBuilder().setCallback(new Callback<T>(){

            @Override
            public void accept(T t) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{} returned {}", (Object)operationDescription, t);
                }
                callback.returnThis(t);
            }
        }).setOnError(error -> {
            logger.error(String.format("ERROR calling %s", operationDescription), error);
            errorHandler.onError((Throwable)error);
        }).setOnTimeout(() -> {
            logger.error("TIMEOUT calling {}", (Object)operationDescription);
            errorHandler.onTimeout();
        }).build();
    }

    public <T> Callback<T> wrapCallbackWithTimeout(final String operationDescription, final Callback<T> callback, final Logger logger, TimeUnit timeUnit, long timeoutDuration) {
        return this.callbackBuilder().setCallback(new Callback<T>(){

            @Override
            public void accept(T t) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{} returned {}", (Object)operationDescription, t);
                }
                callback.returnThis(t);
            }
        }).setOnError(error -> {
            logger.error(String.format("ERROR calling %s", operationDescription), error);
            callback.onError((Throwable)error);
        }).setOnTimeout(() -> {
            logger.error("TIMEOUT calling {}", (Object)operationDescription);
            callback.onTimeout();
        }).setTimeoutTimeUnit(timeUnit).setTimeoutDuration(timeoutDuration).build();
    }

    public <T> Callback<T> wrapCallbackErrorWithTimeout(final String operationDescription, final Callback<T> callback, Callback<?> errorHandler, final Logger logger, TimeUnit timeUnit, long timeoutDuration) {
        return this.callbackBuilder().setCallback(new Callback<T>(){

            @Override
            public void accept(T t) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{} returned {}", (Object)operationDescription, t);
                }
                callback.returnThis(t);
            }
        }).setOnError(error -> {
            logger.error(String.format("ERROR calling %s", operationDescription), error);
            errorHandler.onError((Throwable)error);
        }).setOnTimeout(() -> {
            logger.error("TIMEOUT calling {}", (Object)operationDescription);
            errorHandler.onTimeout();
        }).withTimeoutTimeUnit(timeUnit).setTimeoutDuration(timeoutDuration).build();
    }

    class RepeatingTask {
        private long lastTimeInvoked;
        private final Runnable task;
        private final long repeatEveryMS;

        public RepeatingTask(Runnable task, TimeUnit timeUnit, long repeatEvery) {
            this.task = task;
            this.repeatEveryMS = timeUnit.toMillis(repeatEvery);
        }
    }
}

