/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.reactive;

import io.advantageous.qbit.config.PropertyResolver;
import io.advantageous.qbit.reactive.Reactor;
import io.advantageous.qbit.util.Timer;
import java.util.Properties;
import java.util.concurrent.TimeUnit;

public class ReactorBuilder {
    private Timer timer = Timer.timer();
    private long defaultTimeOut = 60000L;
    private TimeUnit timeUnit = TimeUnit.MILLISECONDS;
    public static final String CONTEXT = "qbit.reactor.";

    public static ReactorBuilder reactorBuilder() {
        return new ReactorBuilder();
    }

    public ReactorBuilder(PropertyResolver propertyResolver) {
        this.defaultTimeOut = propertyResolver.getLongProperty("defaultTimeOut", this.defaultTimeOut);
    }

    public ReactorBuilder(Properties properties) {
        this(PropertyResolver.createPropertiesPropertyResolver(CONTEXT, properties));
    }

    public ReactorBuilder() {
        this(PropertyResolver.createSystemPropertyResolver(CONTEXT));
    }

    public Reactor build() {
        return new Reactor(this.getTimer(), this.getDefaultTimeOut(), this.getTimeUnit());
    }

    public Timer getTimer() {
        return this.timer;
    }

    public ReactorBuilder setTimer(Timer timer) {
        this.timer = timer;
        return this;
    }

    public long getDefaultTimeOut() {
        return this.defaultTimeOut;
    }

    public ReactorBuilder setDefaultTimeOut(long defaultTimeOut) {
        this.defaultTimeOut = defaultTimeOut;
        return this;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public ReactorBuilder setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
        return this;
    }
}

