/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.reactive.impl;

import io.advantageous.qbit.reactive.AsyncFutureCallback;
import io.advantageous.qbit.reactive.Callback;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public class AsyncFutureCallbackImpl<T>
implements AsyncFutureCallback<T> {
    private final Runnable onTimeout;
    private final Callback<T> callback;
    private final long startTime;
    private final long maxExecutionTime;
    private final Runnable onFinished;
    private final Consumer<Throwable> onError;
    private final AtomicReference<T> value = new AtomicReference();
    private final AtomicReference<Throwable> error = new AtomicReference();
    private final AtomicBoolean cancelled = new AtomicBoolean();
    private final AtomicBoolean done = new AtomicBoolean();
    private final AtomicBoolean timedOut = new AtomicBoolean();

    public AsyncFutureCallbackImpl(Callback<T> callback, long startTime, long maxExecutionDuration, Runnable onFinished, Runnable onTimeout, Consumer<Throwable> onError) {
        this.callback = callback;
        this.startTime = startTime;
        this.maxExecutionTime = maxExecutionDuration;
        this.onError = onError == null ? callback::onError : onError;
        this.onFinished = onFinished == null ? () -> {} : onFinished;
        this.onTimeout = onTimeout;
    }

    public static <T> AsyncFutureCallbackImpl<T> callback(Callback<T> callback, long startTime, long maxExecutionTime, Runnable onFinished, Runnable onTimeout, Consumer<Throwable> onError) {
        return new AsyncFutureCallbackImpl<T>(callback, startTime, maxExecutionTime, onFinished, onTimeout, onError);
    }

    @Override
    public void finished() {
        this.onFinished.run();
    }

    @Override
    public long timeOutDuration() {
        return this.maxExecutionTime;
    }

    @Override
    public long startTime() {
        return this.startTime;
    }

    @Override
    public boolean checkTimeOut(long now) {
        if (now - this.startTime > this.maxExecutionTime) {
            this.onTimeout();
            this.timedOut.set(true);
            return true;
        }
        return false;
    }

    @Override
    public boolean isTimedOut() {
        return this.timedOut.get();
    }

    @Override
    public void accept(T t) {
        this.value.set(t);
        this.done.set(true);
    }

    @Override
    public void onError(Throwable error) {
        this.error.set(error);
        this.done.set(true);
    }

    @Override
    public void onTimeout() {
        if (this.done.get()) {
            return;
        }
        if (this.onTimeout == null) {
            this.callback.onTimeout();
        } else {
            this.onTimeout.run();
        }
    }

    @Override
    public void run() {
        if (this.value.get() != null) {
            this.callback.accept(this.value.get());
        } else if (this.error.get() != null) {
            this.onError.accept(this.error.get());
        } else if (this.cancelled.get()) {
            this.callback.onError(CANCEL);
        } else {
            this.callback.accept(null);
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.cancelled.set(true);
        this.done.set(true);
        return true;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled.get();
    }

    @Override
    public boolean isDone() {
        return this.done.get();
    }

    @Override
    public T get() {
        if (this.error.get() != null) {
            throw new IllegalStateException(this.error.get());
        }
        return this.value.get();
    }

    @Override
    public T get(long timeout, TimeUnit unit) {
        throw new UnsupportedOperationException("Not supported");
    }
}

