/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.sender;

import io.advantageous.qbit.message.Message;
import io.advantageous.qbit.message.MethodCall;
import io.advantageous.qbit.sender.Sender;
import io.advantageous.qbit.service.BeforeMethodCall;
import io.advantageous.qbit.service.EndPoint;
import io.advantageous.qbit.service.impl.NoOpBeforeMethodCall;
import io.advantageous.qbit.spi.ProtocolEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SenderEndPoint
implements EndPoint {
    private final ProtocolEncoder encoder;
    private final String address;
    private final Sender<String> sender;
    private final BeforeMethodCall beforeMethodCall;
    private final BlockingQueue<MethodCall<Object>> methodCalls;
    private final int requestBatchSize;
    private final Logger logger = LoggerFactory.getLogger(SenderEndPoint.class);

    public SenderEndPoint(ProtocolEncoder encoder, String address, Sender<String> sender, BeforeMethodCall beforeMethodCall, int requestBatchSize) {
        this.encoder = encoder;
        this.address = address;
        this.beforeMethodCall = beforeMethodCall == null ? new NoOpBeforeMethodCall() : beforeMethodCall;
        this.requestBatchSize = requestBatchSize;
        this.methodCalls = new ArrayBlockingQueue<MethodCall<Object>>(requestBatchSize);
        this.sender = sender;
    }

    @Override
    public String address() {
        return this.address;
    }

    @Override
    public void call(MethodCall<Object> methodCall) {
        this.beforeMethodCall.before(methodCall);
        if (!this.methodCalls.offer(methodCall)) {
            this.flush(methodCall);
        }
    }

    @Override
    public void call(List<MethodCall<Object>> methodCalls) {
        if (methodCalls.size() > 0) {
            String returnAddress = methodCalls.get(0).returnAddress();
            List<Message<Object>> methods = methodCalls;
            this.sender.send(returnAddress, this.encoder.encodeAsString(methods));
        }
    }

    @Override
    public void flush() {
        this.flush(null);
    }

    private void flush(MethodCall<Object> lastMethodCall) {
        Message method = null;
        try {
            method = this.methodCalls.poll(10L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
        if (method == null) {
            return;
        }
        String returnAddress = ((MethodCall)method).returnAddress();
        ArrayList<Message<Object>> methods = new ArrayList<Message<Object>>(this.requestBatchSize + 1);
        int count = 0;
        while (method != null) {
            methods.add(method);
            try {
                method = this.methodCalls.poll(10L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                method = null;
                Thread.interrupted();
            }
            if (count > this.requestBatchSize) {
                this.sender.send(returnAddress, this.encoder.encodeAsString(methods));
                methods.clear();
                count = 0;
            }
            ++count;
        }
        if (lastMethodCall != null) {
            methods.add(lastMethodCall);
        }
        if (methods.size() > 0) {
            this.sender.send(returnAddress, this.encoder.encodeAsString(methods));
        }
    }

    @Override
    public void stop() {
        try {
            this.flush();
        }
        catch (Exception ex) {
            this.logger.warn("Unable to flush before stop", (Throwable)ex);
        }
        this.sender.stop();
    }
}

