/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.server;

import io.advantageous.qbit.Factory;
import io.advantageous.qbit.QBit;
import io.advantageous.qbit.config.PropertyResolver;
import io.advantageous.qbit.events.EventManager;
import io.advantageous.qbit.http.HttpTransport;
import io.advantageous.qbit.http.server.HttpServer;
import io.advantageous.qbit.http.server.HttpServerBuilder;
import io.advantageous.qbit.json.JsonMapper;
import io.advantageous.qbit.message.Request;
import io.advantageous.qbit.message.Response;
import io.advantageous.qbit.queue.Queue;
import io.advantageous.qbit.queue.QueueBuilder;
import io.advantageous.qbit.server.EndPointHealthPredicate;
import io.advantageous.qbit.server.ServiceEndpointServer;
import io.advantageous.qbit.service.BeforeMethodCall;
import io.advantageous.qbit.service.CallbackManagerBuilder;
import io.advantageous.qbit.service.ServiceBundle;
import io.advantageous.qbit.service.discovery.ServiceDiscovery;
import io.advantageous.qbit.service.health.HealthServiceAsync;
import io.advantageous.qbit.service.health.HealthServiceBuilder;
import io.advantageous.qbit.service.impl.CallbackManager;
import io.advantageous.qbit.service.impl.ServiceConstants;
import io.advantageous.qbit.service.stats.StatCollection;
import io.advantageous.qbit.service.stats.StatsCollector;
import io.advantageous.qbit.spi.ProtocolEncoder;
import io.advantageous.qbit.spi.ProtocolParser;
import io.advantageous.qbit.system.QBitSystemManager;
import io.advantageous.qbit.transforms.Transformer;
import io.advantageous.qbit.util.Timer;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class EndpointServerBuilder {
    public static final String QBIT_ENDPOINT_SERVER_BUILDER = "qbit.endpoint.server.builder.";
    private Queue<Response<Object>> responseQueue;
    private String host;
    private int port = 8080;
    private int flushInterval = 50;
    private String uri = "/services";
    private int numberOfOutstandingRequests = 1000000;
    private int timeoutSeconds = 30;
    private boolean invokeDynamic = true;
    private QueueBuilder httpRequestQueueBuilder;
    private QueueBuilder webSocketMessageQueueBuilder;
    private QueueBuilder requestQueueBuilder;
    private QueueBuilder responseQueueBuilder;
    private QueueBuilder webResponseQueueBuilder;
    private boolean eachServiceInItsOwnThread = true;
    private HttpTransport httpServer;
    private QBitSystemManager qBitSystemManager;
    private HealthServiceAsync healthService = null;
    private StatsCollector statsCollector = null;
    private Timer timer;
    private boolean enableHealthEndpoint;
    private boolean enableStatEndpoint;
    private int statsFlushRateSeconds = 5;
    private int checkTimingEveryXCalls = 1000;
    private CallbackManager callbackManager;
    private CallbackManagerBuilder callbackManagerBuilder;
    private HealthServiceBuilder healthServiceBuilder;
    private StatCollection statsCollection;
    private List<Object> services;
    private String endpointName;
    private ServiceDiscovery serviceDiscovery;
    private int ttlSeconds;
    private Factory factory;
    private JsonMapper jsonMapper;
    private ProtocolEncoder encoder;
    private HttpServerBuilder httpServerBuilder;
    private EventManager eventManager;
    private ProtocolParser parser;
    private BeforeMethodCall beforeMethodCall = ServiceConstants.NO_OP_BEFORE_METHOD_CALL;
    private BeforeMethodCall beforeMethodCallAfterTransform = ServiceConstants.NO_OP_BEFORE_METHOD_CALL;
    private Transformer<Request, Object> argTransformer = ServiceConstants.NO_OP_ARG_TRANSFORM;

    public EndpointServerBuilder setParser(ProtocolParser parser) {
        this.parser = parser;
        return this;
    }

    public ProtocolParser getParser() {
        if (this.parser == null) {
            this.parser = this.getFactory().createProtocolParser();
        }
        return this.parser;
    }

    public Factory getFactory() {
        if (this.factory == null) {
            this.factory = QBit.factory();
        }
        return this.factory;
    }

    public void setFactory(Factory factory) {
        this.factory = factory;
    }

    public JsonMapper getJsonMapper() {
        if (this.jsonMapper == null) {
            this.jsonMapper = this.getFactory().createJsonMapper();
        }
        return this.jsonMapper;
    }

    public EndpointServerBuilder setJsonMapper(JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
        return this;
    }

    public ProtocolEncoder getEncoder() {
        if (this.encoder == null) {
            this.encoder = this.getFactory().createEncoder();
        }
        return this.encoder;
    }

    public EndpointServerBuilder setEncoder(ProtocolEncoder encoder) {
        this.encoder = encoder;
        return this;
    }

    public String getEndpointName() {
        return this.endpointName;
    }

    public EndpointServerBuilder setEndpointName(String endpointName) {
        this.endpointName = endpointName;
        return this;
    }

    public ServiceDiscovery getServiceDiscovery() {
        return this.serviceDiscovery;
    }

    public EndpointServerBuilder setServiceDiscovery(ServiceDiscovery serviceDiscovery) {
        this.serviceDiscovery = serviceDiscovery;
        return this;
    }

    public int getTtlSeconds() {
        return this.ttlSeconds;
    }

    public EndpointServerBuilder setTtlSeconds(int ttlSeconds) {
        this.ttlSeconds = ttlSeconds;
        return this;
    }

    public boolean isEnableHealthEndpoint() {
        return this.enableHealthEndpoint;
    }

    public EndpointServerBuilder setEnableHealthEndpoint(boolean enableHealthEndpoint) {
        this.enableHealthEndpoint = enableHealthEndpoint;
        return this;
    }

    public boolean isEnableStatEndpoint() {
        return this.enableStatEndpoint;
    }

    public EndpointServerBuilder setEnableStatEndpoint(boolean enableStatEndpoint) {
        this.enableStatEndpoint = enableStatEndpoint;
        return this;
    }

    public Timer getTimer() {
        if (this.timer == null) {
            this.timer = Timer.timer();
        }
        return this.timer;
    }

    public EndpointServerBuilder setTimer(Timer timer) {
        this.timer = timer;
        return this;
    }

    public EndpointServerBuilder(PropertyResolver propertyResolver) {
        this.eachServiceInItsOwnThread = propertyResolver.getBooleanProperty("eachServiceInItsOwnThread", this.eachServiceInItsOwnThread);
        this.invokeDynamic = propertyResolver.getBooleanProperty("invokeDynamic", this.invokeDynamic);
        this.host = propertyResolver.getStringProperty("host", this.host);
        this.port = propertyResolver.getIntegerProperty("port", this.port);
        this.numberOfOutstandingRequests = propertyResolver.getIntegerProperty("numberOfOutstandingRequests", this.numberOfOutstandingRequests);
        this.flushInterval = propertyResolver.getIntegerProperty("flushInterval", this.flushInterval);
        this.uri = propertyResolver.getStringProperty("uri", this.uri);
        this.timeoutSeconds = propertyResolver.getIntegerProperty("timeoutSeconds", this.timeoutSeconds);
        this.statsFlushRateSeconds = propertyResolver.getIntegerProperty("statsFlushRateSeconds", this.statsFlushRateSeconds);
        this.checkTimingEveryXCalls = propertyResolver.getIntegerProperty("checkTimingEveryXCalls", this.checkTimingEveryXCalls);
    }

    public EndpointServerBuilder() {
        this(PropertyResolver.createSystemPropertyResolver(QBIT_ENDPOINT_SERVER_BUILDER));
    }

    public EndpointServerBuilder(Properties properties) {
        this(PropertyResolver.createPropertiesPropertyResolver(QBIT_ENDPOINT_SERVER_BUILDER, properties));
    }

    public static EndpointServerBuilder endpointServerBuilder() {
        return new EndpointServerBuilder();
    }

    public CallbackManagerBuilder getCallbackManagerBuilder() {
        if (this.callbackManagerBuilder == null) {
            this.callbackManagerBuilder = CallbackManagerBuilder.callbackManagerBuilder();
            this.callbackManagerBuilder.setName("Endpoint-" + this.getUri() + " port " + this.getPort());
        }
        return this.callbackManagerBuilder;
    }

    public EndpointServerBuilder setCallbackManagerBuilder(CallbackManagerBuilder callbackManagerBuilder) {
        this.callbackManagerBuilder = callbackManagerBuilder;
        return this;
    }

    public CallbackManager getCallbackManager() {
        if (this.callbackManager == null) {
            this.callbackManager = this.getCallbackManagerBuilder().build();
        }
        return this.callbackManager;
    }

    public EndpointServerBuilder setCallbackManager(CallbackManager callbackManager) {
        this.callbackManager = callbackManager;
        return this;
    }

    public HealthServiceAsync getHealthService() {
        if (this.healthService == null) {
            HealthServiceBuilder builder = this.getHealthServiceBuilder();
            this.healthService = builder.setAutoFlush().buildAndStart();
        }
        return this.healthService;
    }

    public EndpointServerBuilder setHealthService(HealthServiceAsync healthServiceAsync) {
        this.healthService = healthServiceAsync;
        return this;
    }

    public StatsCollector getStatsCollector() {
        return this.statsCollector;
    }

    public EndpointServerBuilder setStatsCollector(StatsCollector statsCollector) {
        this.statsCollector = statsCollector;
        return this;
    }

    public QueueBuilder getRequestQueueBuilder() {
        if (this.requestQueueBuilder == null) {
            this.requestQueueBuilder = QueueBuilder.queueBuilder();
        }
        return this.requestQueueBuilder;
    }

    public EndpointServerBuilder setRequestQueueBuilder(QueueBuilder requestQueueBuilder) {
        this.requestQueueBuilder = requestQueueBuilder;
        return this;
    }

    public QueueBuilder getWebResponseQueueBuilder() {
        if (this.webResponseQueueBuilder == null) {
            this.webResponseQueueBuilder = QueueBuilder.queueBuilder();
        }
        return this.webResponseQueueBuilder;
    }

    public EndpointServerBuilder setWebResponseQueueBuilder(QueueBuilder webResponseQueueBuilder) {
        this.webResponseQueueBuilder = webResponseQueueBuilder;
        return this;
    }

    public QBitSystemManager getSystemManager() {
        return this.qBitSystemManager;
    }

    public EndpointServerBuilder setSystemManager(QBitSystemManager qBitSystemManager) {
        this.qBitSystemManager = qBitSystemManager;
        return this;
    }

    public HttpTransport getHttpServer() {
        if (this.httpServer == null) {
            this.httpServer = this.getHttpServerBuilder().build();
        }
        return this.httpServer;
    }

    public EndpointServerBuilder setHttpServer(HttpServer httpServer) {
        this.httpServer = httpServer;
        return this;
    }

    public HttpTransport getHttpTransport() {
        return this.httpServer;
    }

    public EndpointServerBuilder setHttpTransport(HttpTransport httpTransport) {
        this.httpServer = httpTransport;
        return this;
    }

    public QueueBuilder getHttpRequestQueueBuilder() {
        return this.httpRequestQueueBuilder;
    }

    public EndpointServerBuilder setHttpRequestQueueBuilder(QueueBuilder httpRequestQueueBuilder) {
        this.httpRequestQueueBuilder = httpRequestQueueBuilder;
        return this;
    }

    public QueueBuilder getWebSocketMessageQueueBuilder() {
        return this.webSocketMessageQueueBuilder;
    }

    public EndpointServerBuilder setWebSocketMessageQueueBuilder(QueueBuilder webSocketMessageQueueBuilder) {
        this.webSocketMessageQueueBuilder = webSocketMessageQueueBuilder;
        return this;
    }

    public boolean isInvokeDynamic() {
        return this.invokeDynamic;
    }

    public EndpointServerBuilder setInvokeDynamic(boolean invokeDynamic) {
        this.invokeDynamic = invokeDynamic;
        return this;
    }

    public boolean isEachServiceInItsOwnThread() {
        return this.eachServiceInItsOwnThread;
    }

    public EndpointServerBuilder setEachServiceInItsOwnThread(boolean eachServiceInItsOwnThread) {
        this.eachServiceInItsOwnThread = eachServiceInItsOwnThread;
        return this;
    }

    public BeforeMethodCall getBeforeMethodCall() {
        return this.beforeMethodCall;
    }

    public EndpointServerBuilder setBeforeMethodCall(BeforeMethodCall beforeMethodCall) {
        this.beforeMethodCall = beforeMethodCall;
        return this;
    }

    public BeforeMethodCall getBeforeMethodCallAfterTransform() {
        return this.beforeMethodCallAfterTransform;
    }

    public EndpointServerBuilder setBeforeMethodCallAfterTransform(BeforeMethodCall beforeMethodCallAfterTransform) {
        this.beforeMethodCallAfterTransform = beforeMethodCallAfterTransform;
        return this;
    }

    public Transformer<Request, Object> getArgTransformer() {
        return this.argTransformer;
    }

    public EndpointServerBuilder setArgTransformer(Transformer<Request, Object> argTransformer) {
        this.argTransformer = argTransformer;
        return this;
    }

    public int getNumberOfOutstandingRequests() {
        return this.numberOfOutstandingRequests;
    }

    public EndpointServerBuilder setNumberOfOutstandingRequests(int numberOfOutstandingRequests) {
        this.numberOfOutstandingRequests = numberOfOutstandingRequests;
        return this;
    }

    public String getUri() {
        return this.uri;
    }

    public EndpointServerBuilder setUri(String uri) {
        this.uri = uri;
        return this;
    }

    public int getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public EndpointServerBuilder setTimeoutSeconds(int timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public EndpointServerBuilder setHost(String host) {
        this.host = host;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public EndpointServerBuilder setPort(int port) {
        this.port = port;
        return this;
    }

    public int getFlushInterval() {
        return this.flushInterval;
    }

    public EndpointServerBuilder setFlushInterval(int flushInterval) {
        this.flushInterval = flushInterval;
        return this;
    }

    public QueueBuilder getResponseQueueBuilder() {
        if (this.responseQueueBuilder == null) {
            this.responseQueueBuilder = this.responseQueue == null ? QueueBuilder.queueBuilder() : new QueueBuilder(){

                @Override
                public <T> Queue<T> build() {
                    return EndpointServerBuilder.this.responseQueue;
                }
            };
        }
        return this.responseQueueBuilder;
    }

    public EndpointServerBuilder setResponseQueueBuilder(QueueBuilder responseQueueBuilder) {
        this.responseQueueBuilder = responseQueueBuilder;
        return this;
    }

    public Queue<Response<Object>> getResponseQueue() {
        return this.responseQueue;
    }

    public EndpointServerBuilder setResponseQueue(Queue<Response<Object>> responseQueue) {
        this.responseQueue = responseQueue;
        return this;
    }

    public ServiceEndpointServer build() {
        ServiceBundle serviceBundle = QBit.factory().createServiceBundle(this.uri, this.getRequestQueueBuilder(), this.getResponseQueueBuilder(), this.getWebResponseQueueBuilder(), this.getFactory(), this.eachServiceInItsOwnThread, this.getBeforeMethodCall(), this.getBeforeMethodCallAfterTransform(), this.getArgTransformer(), true, this.getSystemManager(), this.getHealthService(), this.getStatsCollector(), this.getTimer(), this.getStatsFlushRateSeconds(), this.getCheckTimingEveryXCalls(), this.getCallbackManager(), this.getEventManager());
        ServiceEndpointServer serviceEndpointServer = this.getFactory().createServiceServer(this.getHttpServer(), this.getEncoder(), this.getParser(), serviceBundle, this.getJsonMapper(), this.getTimeoutSeconds(), this.getNumberOfOutstandingRequests(), this.getRequestQueueBuilder().getBatchSize(), this.getFlushInterval(), this.getSystemManager(), this.getEndpointName(), this.getServiceDiscovery(), this.getPort(), this.getTtlSeconds(), this.getHealthService());
        if (serviceEndpointServer != null && this.qBitSystemManager != null) {
            this.qBitSystemManager.registerServer(serviceEndpointServer);
        }
        if (this.services != null) {
            serviceEndpointServer.initServices(this.services);
        }
        return serviceEndpointServer;
    }

    public int getStatsFlushRateSeconds() {
        return this.statsFlushRateSeconds;
    }

    public EndpointServerBuilder setStatsFlushRateSeconds(int statsFlushRateSeconds) {
        this.statsFlushRateSeconds = statsFlushRateSeconds;
        return this;
    }

    public int getCheckTimingEveryXCalls() {
        return this.checkTimingEveryXCalls;
    }

    public EndpointServerBuilder setCheckTimingEveryXCalls(int checkTimingEveryXCalls) {
        this.checkTimingEveryXCalls = checkTimingEveryXCalls;
        return this;
    }

    public HealthServiceBuilder getHealthServiceBuilder() {
        if (this.healthServiceBuilder == null) {
            this.healthServiceBuilder = HealthServiceBuilder.healthServiceBuilder();
        }
        return this.healthServiceBuilder;
    }

    public StatCollection getStatsCollection() {
        return this.statsCollection;
    }

    public EndpointServerBuilder setStatsCollection(StatCollection statsCollection) {
        this.statsCollection = statsCollection;
        return this;
    }

    public void setServices(List<Object> services) {
        this.services = services;
    }

    public List<Object> getServices() {
        if (this.services == null) {
            this.services = new ArrayList<Object>();
        }
        return this.services;
    }

    public EndpointServerBuilder addService(Object service) {
        this.getServices().add(service);
        return this;
    }

    public EndpointServerBuilder addServices(Object ... services) {
        for (Object service : services) {
            this.getServices().add(service);
        }
        return this;
    }

    public HttpServerBuilder getHttpServerBuilder() {
        if (this.httpServerBuilder == null) {
            this.httpServerBuilder = HttpServerBuilder.httpServerBuilder().setPort(this.getPort()).setHost(this.getHost()).setFlushInterval(this.getFlushInterval()).setSystemManager(this.getSystemManager());
            this.setupHealthAndStats(this.httpServerBuilder);
        }
        return this.httpServerBuilder;
    }

    public EndpointServerBuilder setHttpServerBuilder(HttpServerBuilder httpServerBuilder) {
        this.httpServerBuilder = httpServerBuilder;
        return this;
    }

    public EndpointServerBuilder setupHealthAndStats(HttpServerBuilder httpServerBuilder) {
        if (this.isEnableStatEndpoint() || this.isEnableHealthEndpoint()) {
            boolean healthEnabled = this.isEnableHealthEndpoint();
            boolean statsEnabled = this.isEnableStatEndpoint();
            HealthServiceAsync healthServiceAsync = healthEnabled ? this.getHealthService() : null;
            StatCollection statCollection = statsEnabled ? this.getStatsCollection() : null;
            httpServerBuilder.addShouldContinueHttpRequestPredicate(new EndPointHealthPredicate(healthEnabled, statsEnabled, healthServiceAsync, statCollection));
        }
        return this;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public EndpointServerBuilder setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
        return this;
    }
}

