/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.server;

import io.advantageous.boon.core.Sets;
import io.advantageous.boon.core.Str;
import io.advantageous.boon.primitive.Arry;
import io.advantageous.boon.primitive.CharBuf;
import io.advantageous.qbit.GlobalConstants;
import io.advantageous.qbit.annotation.RequestMethod;
import io.advantageous.qbit.http.HttpStatusCodeException;
import io.advantageous.qbit.http.request.HttpBinaryResponse;
import io.advantageous.qbit.http.request.HttpRequest;
import io.advantageous.qbit.http.request.HttpResponse;
import io.advantageous.qbit.http.request.HttpResponseReceiver;
import io.advantageous.qbit.http.request.HttpTextResponse;
import io.advantageous.qbit.json.JsonMapper;
import io.advantageous.qbit.message.MethodCall;
import io.advantageous.qbit.message.Request;
import io.advantageous.qbit.message.Response;
import io.advantageous.qbit.meta.RequestMetaData;
import io.advantageous.qbit.meta.builder.ContextMetaBuilder;
import io.advantageous.qbit.meta.provider.StandardMetaDataProvider;
import io.advantageous.qbit.meta.transformer.StandardRequestTransformer;
import io.advantageous.qbit.queue.SendQueue;
import io.advantageous.qbit.server.HttpRequestServiceServerHandler;
import io.advantageous.qbit.service.ServiceBundle;
import io.advantageous.qbit.service.ServiceMethodNotFoundException;
import io.advantageous.qbit.util.MultiMap;
import io.advantageous.qbit.util.Timer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestServiceServerHandlerUsingMetaImpl
implements HttpRequestServiceServerHandler {
    private static final Set<String> ignorePackages = Sets.set((Object[])new String[]{"sun.", "com.sun.", "javax.java", "java.", "oracle.", "com.oracle.", "org.junit", "com.intellij", "io.advantageous.boon"});
    private final int timeoutInSeconds;
    private final AtomicLong lastTimeoutCheckTime = new AtomicLong();
    private final int numberOfOutstandingRequests;
    private final SendQueue<MethodCall<Object>> methodCallSendQueue;
    private final int flushInterval;
    private final JsonMapper jsonMapper;
    private final Map<String, Request<Object>> outstandingRequestMap = new ConcurrentHashMap<String, Request<Object>>(100000);
    private final Logger logger = LoggerFactory.getLogger(HttpRequestServiceServerHandlerUsingMetaImpl.class);
    private final boolean debug = GlobalConstants.DEBUG || this.logger.isDebugEnabled();
    private final Lock lock = new ReentrantLock();
    private long lastFlushTime;
    private ContextMetaBuilder contextMetaBuilder = ContextMetaBuilder.contextMetaBuilder();
    private StandardRequestTransformer standardRequestTransformer;
    private final Map<RequestMethod, StandardMetaDataProvider> metaDataProviderMap = new ConcurrentHashMap<RequestMethod, StandardMetaDataProvider>();

    public HttpRequestServiceServerHandlerUsingMetaImpl(int timeoutInSeconds, ServiceBundle serviceBundle, JsonMapper jsonMapper, int numberOfOutstandingRequests, int flushInterval) {
        this.timeoutInSeconds = timeoutInSeconds;
        this.lastTimeoutCheckTime.set(Timer.timer().now() + (long)(timeoutInSeconds * 1000));
        this.numberOfOutstandingRequests = numberOfOutstandingRequests;
        this.jsonMapper = jsonMapper;
        this.methodCallSendQueue = serviceBundle.methodSendQueue();
        this.flushInterval = flushInterval;
        this.contextMetaBuilder = ContextMetaBuilder.contextMetaBuilder();
    }

    @Override
    public void handleRestCall(HttpRequest request) {
        ArrayList<String> errorList = new ArrayList<String>(0);
        MethodCall<Object> methodCall = this.standardRequestTransformer.transform(request, errorList);
        if (methodCall != null && errorList.size() == 0) {
            if (!this.addRequestToCheckForTimeouts(request)) {
                this.handleOverflow(request);
                return;
            }
        } else {
            this.handleErrorConverting(request, errorList, methodCall);
            return;
        }
        this.sendMethodToServiceBundle(methodCall);
        RequestMetaData requestMetaData = this.metaDataProviderMap.get((Object)RequestMethod.valueOf(request.getMethod())).get(request.address());
        if (requestMetaData.getMethod().getMethodAccess().returnType() == Void.TYPE && !requestMetaData.getMethod().hasCallBack()) {
            request.handled();
            int responseCode = requestMetaData.getMethod().getResponseCode();
            this.writeResponse(request.getReceiver(), responseCode == -1 ? 202 : responseCode, "application/json", "\"success\"", MultiMap.empty());
        }
    }

    @Override
    public void handleResponseFromServiceToHttpResponse(Response<Object> response, HttpRequest originatingRequest) {
        String key = Str.add((String[])new String[]{"" + originatingRequest.id(), "|", originatingRequest.returnAddress()});
        this.outstandingRequestMap.remove(key);
        if (response.wasErrors()) {
            this.handleError(response, originatingRequest);
        } else if (response.body() instanceof HttpResponse) {
            this.writeHttpResponse(originatingRequest.getReceiver(), (HttpResponse)response.body());
        } else {
            RequestMetaData requestMetaData = this.metaDataProviderMap.get((Object)RequestMethod.valueOf(originatingRequest.getMethod())).get(originatingRequest.address());
            int responseCode = requestMetaData.getMethod().getResponseCode();
            this.writeResponse(originatingRequest.getReceiver(), responseCode == -1 ? 200 : responseCode, "application/json", this.jsonMapper.toJson(response.body()), response.headers());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void httpRequestQueueIdle(Void v) {
        long lastFlush = this.lastFlushTime;
        long now = Timer.timer().now();
        long duration = now - lastFlush;
        if (duration > (long)this.flushInterval) {
            this.lastFlushTime = now;
            try {
                this.lock.lock();
                this.methodCallSendQueue.flushSends();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @Override
    public void start() {
        this.metaDataProviderMap.put(RequestMethod.GET, new StandardMetaDataProvider(this.contextMetaBuilder.build(), RequestMethod.GET));
        this.metaDataProviderMap.put(RequestMethod.POST, new StandardMetaDataProvider(this.contextMetaBuilder.build(), RequestMethod.POST));
        this.metaDataProviderMap.put(RequestMethod.PUT, new StandardMetaDataProvider(this.contextMetaBuilder.build(), RequestMethod.PUT));
        this.metaDataProviderMap.put(RequestMethod.DELETE, new StandardMetaDataProvider(this.contextMetaBuilder.build(), RequestMethod.DELETE));
        this.metaDataProviderMap.put(RequestMethod.HEAD, new StandardMetaDataProvider(this.contextMetaBuilder.build(), RequestMethod.HEAD));
        this.metaDataProviderMap.put(RequestMethod.OPTIONS, new StandardMetaDataProvider(this.contextMetaBuilder.build(), RequestMethod.OPTIONS));
        this.metaDataProviderMap.put(RequestMethod.TRACE, new StandardMetaDataProvider(this.contextMetaBuilder.build(), RequestMethod.TRACE));
        this.metaDataProviderMap.put(RequestMethod.CONNECT, new StandardMetaDataProvider(this.contextMetaBuilder.build(), RequestMethod.CONNECT));
        this.standardRequestTransformer = new StandardRequestTransformer(this.metaDataProviderMap);
    }

    private void handleOverflow(HttpRequest request) {
        this.writeResponse(request.getReceiver(), 429, "application/json", "\"too many outstanding requests\"", MultiMap.empty());
    }

    private void sendMethodToServiceBundle(MethodCall<Object> methodCall) {
        try {
            this.lock.lock();
            this.methodCallSendQueue.send(methodCall);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void handleErrorConverting(HttpRequest request, List<String> errorList, MethodCall<Object> methodCall) {
        if (methodCall == null) {
            if (errorList.size() > 0) {
                request.getReceiver().response(404, "application/json", this.jsonMapper.toJson(errorList));
            } else {
                request.getReceiver().response(404, "application/json", "\"not found\"");
            }
        } else if (errorList.size() > 0) {
            request.getReceiver().response(400, "application/json", this.jsonMapper.toJson(errorList));
        } else {
            request.getReceiver().response(500, "application/json", "\"unable to make call\"");
        }
    }

    @Override
    public void addRestSupportFor(Class cls, String baseURI) {
        this.contextMetaBuilder.setRootURI(baseURI).addService(cls);
    }

    @Override
    public void checkTimeoutsForRequests() {
        long timeoutInMS;
        boolean timedOut;
        long now = Timer.timer().now();
        long durationSinceLastCheck = now - this.lastTimeoutCheckTime.get();
        boolean bl = timedOut = durationSinceLastCheck > (timeoutInMS = (long)(this.timeoutInSeconds * 1000));
        if (!timedOut) {
            return;
        }
        this.lastTimeoutCheckTime.set(now);
        Set<Map.Entry<String, Request<Object>>> entries = this.outstandingRequestMap.entrySet();
        for (Map.Entry<String, Request<Object>> requestEntry : entries) {
            Request<Object> request = requestEntry.getValue();
            String key = requestEntry.getKey();
            if (request.isHandled()) {
                request.handled();
                this.outstandingRequestMap.remove(key);
                continue;
            }
            long duration = now - request.timestamp();
            if (duration <= timeoutInMS) continue;
            HttpResponseReceiver<Object> httpResponse = ((HttpRequest)request).getReceiver();
            try {
                httpResponse.response(408, "application/json", "\"timed out\"");
            }
            catch (Exception ex) {
                this.logger.debug("Response not marked handled and it timed out, but could not be written " + request, (Throwable)ex);
            }
        }
    }

    private void handleError(Response<Object> response, HttpRequest httpRequest) {
        Object obj = response.body();
        if (obj instanceof ServiceMethodNotFoundException) {
            this.writeResponse(httpRequest.getReceiver(), 404, "application/json", this.jsonMapper.toJson(response.body()), response.headers());
        } else if (obj instanceof HttpStatusCodeException) {
            HttpStatusCodeException httpStatusCodeException = (HttpStatusCodeException)obj;
            this.writeResponse(httpRequest.getReceiver(), httpStatusCodeException.code(), "application/json", this.jsonMapper.toJson(httpStatusCodeException.getMessage()), response.headers());
        } else if (obj instanceof Throwable) {
            this.writeResponse(httpRequest.getReceiver(), 500, "application/json", HttpRequestServiceServerHandlerUsingMetaImpl.asJson((Throwable)obj), response.headers());
        } else {
            this.writeResponse(httpRequest.getReceiver(), 500, "application/json", this.jsonMapper.toJson(response.body()), response.headers());
        }
    }

    private void writeHttpResponse(HttpResponseReceiver<Object> receiver, HttpResponse httpResponse) {
        if (httpResponse instanceof HttpTextResponse) {
            HttpTextResponse httpTextResponse = (HttpTextResponse)httpResponse;
            this.writeResponse(receiver, httpResponse.code(), httpResponse.contentType(), (String)httpTextResponse.body(), httpTextResponse.headers());
        } else if (httpResponse instanceof HttpBinaryResponse) {
            HttpBinaryResponse httpBinaryResponse = (HttpBinaryResponse)httpResponse;
            receiver.response(httpResponse.code(), httpResponse.contentType(), httpBinaryResponse.body(), httpBinaryResponse.headers());
        }
    }

    private void writeResponse(HttpResponseReceiver response, int code, String mimeType, String responseString, MultiMap<String, String> headers) {
        if (response.isText()) {
            response.response(code, mimeType, responseString, headers);
        } else {
            response.response(code, mimeType, responseString.getBytes(StandardCharsets.UTF_8), headers);
        }
    }

    private boolean addRequestToCheckForTimeouts(Request<Object> request) {
        String key = Str.add((String[])new String[]{"" + request.id(), "|", request.returnAddress()});
        this.outstandingRequestMap.put(key, request);
        return this.outstandingRequestMap.size() < this.numberOfOutstandingRequests;
    }

    public static StackTraceElement[] getFilteredStackTrace(StackTraceElement[] stackTrace) {
        if (stackTrace == null || stackTrace.length == 0) {
            return new StackTraceElement[0];
        }
        ArrayList<StackTraceElement> list = new ArrayList<StackTraceElement>();
        HashSet<String> seenThisBefore = new HashSet<String>();
        for (StackTraceElement st : stackTrace) {
            String key;
            if (Str.startsWithItemInCollection((String)st.getClassName(), ignorePackages) || seenThisBefore.contains(key = Str.sputs((Object[])new Object[]{st.getClassName(), st.getFileName(), st.getMethodName(), st.getLineNumber()}))) continue;
            seenThisBefore.add(key);
            list.add(st);
        }
        return (StackTraceElement[])Arry.array(StackTraceElement.class, list);
    }

    public static String asJson(Throwable ex) {
        StackTraceElement[] stackTrace;
        CharBuf buffer = CharBuf.create((int)255);
        buffer.add('{');
        buffer.addLine().indent(5).addJsonFieldName("message").asJsonString(ex.getMessage()).addLine((Object)Character.valueOf(','));
        buffer.addLine().indent(5).addJsonFieldName("exception").asJsonString(ex.getClass().getSimpleName()).addLine((Object)Character.valueOf(','));
        if (ex.getCause() != null) {
            buffer.addLine().indent(5).addJsonFieldName("causeMessage").asJsonString(ex.getCause().getMessage()).addLine((Object)Character.valueOf(','));
            if (ex.getCause().getCause() != null) {
                buffer.addLine().indent(5).addJsonFieldName("cause2Message").asJsonString(ex.getCause().getCause().getMessage()).addLine((Object)Character.valueOf(','));
                if (ex.getCause().getCause().getCause() != null) {
                    buffer.addLine().indent(5).addJsonFieldName("cause3Message").asJsonString(ex.getCause().getCause().getCause().getMessage()).addLine((Object)Character.valueOf(','));
                    if (ex.getCause().getCause().getCause().getCause() != null) {
                        buffer.addLine().indent(5).addJsonFieldName("cause4Message").asJsonString(ex.getCause().getCause().getCause().getCause().getMessage()).addLine((Object)Character.valueOf(','));
                    }
                }
            }
        }
        if ((stackTrace = HttpRequestServiceServerHandlerUsingMetaImpl.getFilteredStackTrace(ex.getStackTrace())) != null && stackTrace.length > 0) {
            buffer.addLine().indent(5).addJsonFieldName("stackTrace").addLine();
            HttpRequestServiceServerHandlerUsingMetaImpl.stackTraceToJson(buffer, stackTrace);
            buffer.add(',');
        }
        buffer.addLine().indent(5).addJsonFieldName("fullStackTrace").addLine();
        StackTraceElement[] fullStackTrace = ex.getStackTrace();
        HttpRequestServiceServerHandlerUsingMetaImpl.stackTraceToJson(buffer, fullStackTrace);
        buffer.add('}');
        return buffer.toString();
    }

    public static void stackTraceToJson(CharBuf buffer, StackTraceElement[] stackTrace) {
        if (stackTrace.length == 0) {
            buffer.addLine("[]");
            return;
        }
        buffer.multiply(' ', 16).addLine((Object)Character.valueOf('['));
        for (int index = 0; index < stackTrace.length; ++index) {
            StackTraceElement element = stackTrace[index];
            if (element.getClassName().contains("Exceptions")) continue;
            buffer.indent(17).add("[  ").asJsonString(element.getMethodName()).add(',');
            buffer.indent(3).asJsonString(element.getClassName());
            if (element.getLineNumber() > 0) {
                buffer.add(",");
                buffer.indent(3).asJsonString("" + element.getLineNumber()).addLine("   ],");
                continue;
            }
            buffer.addLine(" ],");
        }
        buffer.removeLastChar();
        buffer.removeLastChar();
        buffer.addLine().multiply(' ', 15).add(']');
    }
}

