/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.server;

import io.advantageous.qbit.GlobalConstants;
import io.advantageous.qbit.http.HttpTransport;
import io.advantageous.qbit.http.request.HttpRequest;
import io.advantageous.qbit.http.server.websocket.WebSocketMessage;
import io.advantageous.qbit.json.JsonMapper;
import io.advantageous.qbit.message.MethodCall;
import io.advantageous.qbit.message.Request;
import io.advantageous.qbit.message.Response;
import io.advantageous.qbit.queue.ReceiveQueueListener;
import io.advantageous.qbit.server.HttpRequestServiceServerHandler;
import io.advantageous.qbit.server.HttpRequestServiceServerHandlerUsingMetaImpl;
import io.advantageous.qbit.server.ServiceEndpointServer;
import io.advantageous.qbit.server.WebSocketServiceServerHandler;
import io.advantageous.qbit.service.ServiceBundle;
import io.advantageous.qbit.service.ServiceProxyUtils;
import io.advantageous.qbit.service.ServiceQueue;
import io.advantageous.qbit.service.Stoppable;
import io.advantageous.qbit.service.discovery.EndpointDefinition;
import io.advantageous.qbit.service.discovery.ServiceDiscovery;
import io.advantageous.qbit.service.health.HealthServiceAsync;
import io.advantageous.qbit.service.health.HealthStatus;
import io.advantageous.qbit.spi.ProtocolEncoder;
import io.advantageous.qbit.spi.ProtocolParser;
import io.advantageous.qbit.system.QBitSystemManager;
import io.advantageous.qbit.util.Timer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceEndpointServerImpl
implements ServiceEndpointServer {
    protected final int batchSize;
    private final Logger logger = LoggerFactory.getLogger(ServiceEndpointServerImpl.class);
    private final boolean debug = GlobalConstants.DEBUG || this.logger.isDebugEnabled();
    private final QBitSystemManager systemManager;
    protected final WebSocketServiceServerHandler webSocketHandler;
    protected final HttpRequestServiceServerHandler httpRequestServerHandler;
    private final EndpointDefinition endpoint;
    private final HealthServiceAsync healthServiceAsync;
    protected int timeoutInSeconds = 30;
    protected final ProtocolEncoder encoder;
    protected final HttpTransport httpServer;
    protected final ServiceBundle serviceBundle;
    protected final JsonMapper jsonMapper;
    protected final ProtocolParser parser;
    private final AtomicBoolean stop = new AtomicBoolean();
    private final ServiceDiscovery serviceDiscovery;

    public ServiceEndpointServerImpl(HttpTransport httpServer, ProtocolEncoder encoder, ProtocolParser parser, ServiceBundle serviceBundle, JsonMapper jsonMapper, int timeOutInSeconds, int numberOfOutstandingRequests, int batchSize, int flushInterval, QBitSystemManager systemManager, String endpointName, ServiceDiscovery serviceDiscovery, int port, int ttlSeconds, HealthServiceAsync healthServiceAsync) {
        this.systemManager = systemManager;
        this.encoder = encoder;
        this.parser = parser;
        this.httpServer = httpServer;
        this.serviceBundle = serviceBundle;
        this.jsonMapper = jsonMapper;
        this.timeoutInSeconds = timeOutInSeconds;
        this.batchSize = batchSize;
        this.healthServiceAsync = healthServiceAsync;
        this.webSocketHandler = new WebSocketServiceServerHandler(batchSize, serviceBundle, 4, 4);
        this.serviceDiscovery = serviceDiscovery;
        this.httpRequestServerHandler = new HttpRequestServiceServerHandlerUsingMetaImpl(this.timeoutInSeconds, serviceBundle, jsonMapper, numberOfOutstandingRequests, flushInterval);
        this.endpoint = this.createEndpoint(endpointName, port, ttlSeconds);
    }

    private EndpointDefinition createEndpoint(String endpointName, int port, int ttlSeconds) {
        if (this.serviceDiscovery != null) {
            if (ttlSeconds > 0) {
                return this.serviceDiscovery.registerWithTTL(endpointName, port, ttlSeconds);
            }
            return this.serviceDiscovery.register(endpointName, port);
        }
        return null;
    }

    @Override
    public void start() {
        this.stop.set(false);
        this.httpRequestServerHandler.start();
        this.httpServer.setHttpRequestConsumer(this.httpRequestServerHandler::handleRestCall);
        this.httpServer.setWebSocketMessageConsumer(this.webSocketHandler::handleWebSocketCall);
        this.httpServer.setWebSocketCloseConsumer(this.webSocketHandler::handleWebSocketClose);
        if (this.endpoint != null && this.endpoint.getTimeToLive() > 0L) {
            this.handleServiceDiscoveryCheckIn();
        } else {
            this.httpServer.setHttpRequestsIdleConsumer(this.httpRequestServerHandler::httpRequestQueueIdle);
        }
        this.httpServer.setWebSocketIdleConsume(this.webSocketHandler::webSocketQueueIdle);
        this.serviceBundle.startUpCallQueue();
        this.startResponseQueueListener();
        this.httpServer.start();
    }

    private void handleServiceDiscoveryCheckIn() {
        AtomicLong lastCheckIn = new AtomicLong(Timer.clockTime());
        long checkinDuration = this.endpoint.getTimeToLive() * 1000L / 2L;
        if (this.healthServiceAsync == null) {
            this.handleDiscoveryCheckInNoHealth(lastCheckIn, checkinDuration);
        } else {
            this.handleDiscoveryCheckInWithHealth(lastCheckIn, checkinDuration);
        }
    }

    private void handleDiscoveryCheckInNoHealth(AtomicLong lastCheckIn, long checkInDuration) {
        this.httpServer.setHttpRequestsIdleConsumer(aVoid -> {
            this.httpRequestServerHandler.httpRequestQueueIdle(null);
            long now = Timer.clockTime();
            if (now > lastCheckIn.get() + checkInDuration) {
                lastCheckIn.set(now);
                this.serviceDiscovery.checkInOk(this.endpoint.getId());
            }
        });
    }

    private void handleDiscoveryCheckInWithHealth(AtomicLong lastCheckIn, long checkInDuration) {
        AtomicBoolean ok = new AtomicBoolean(true);
        this.httpServer.setHttpRequestsIdleConsumer(aVoid -> {
            this.httpRequestServerHandler.httpRequestQueueIdle(null);
            long now = Timer.clockTime();
            if (now > lastCheckIn.get() + checkInDuration) {
                lastCheckIn.set(now);
                if (ok.get()) {
                    this.serviceDiscovery.checkInOk(this.endpoint.getId());
                } else {
                    this.serviceDiscovery.checkIn(this.endpoint.getId(), HealthStatus.FAIL);
                }
                this.healthServiceAsync.ok(ok::set);
                ServiceProxyUtils.flushServiceProxy(this.healthServiceAsync);
            }
        });
    }

    @Override
    public void stop() {
        block7: {
            block6: {
                try {
                    this.serviceBundle.stop();
                }
                catch (Exception ex) {
                    if (!this.debug) break block6;
                    this.logger.debug("Unable to cleanly shutdown bundle", (Throwable)ex);
                }
            }
            try {
                if (this.httpServer instanceof Stoppable) {
                    ((Stoppable)((Object)this.httpServer)).stop();
                }
            }
            catch (Exception ex) {
                if (!this.debug) break block7;
                this.logger.debug("Unable to cleanly shutdown httpServer", (Throwable)ex);
            }
        }
        if (this.systemManager != null) {
            this.systemManager.serviceShutDown();
        }
    }

    private void startResponseQueueListener() {
        this.serviceBundle.startReturnHandlerProcessor();
        this.serviceBundle.startWebResponseReturnHandler(this.createResponseQueueListener());
    }

    private ReceiveQueueListener<Response<Object>> createResponseQueueListener() {
        return new ReceiveQueueListener<Response<Object>>(){
            final List<Response<Object>> responseBatch = new ArrayList<Response<Object>>();

            @Override
            public void receive(Response<Object> response) {
                if (ServiceEndpointServerImpl.this.debug) {
                    ServiceEndpointServerImpl.this.logger.debug("createResponseQueueListener() Received a response: " + response);
                }
                this.responseBatch.add(response);
                if (this.responseBatch.size() >= ServiceEndpointServerImpl.this.batchSize) {
                    ServiceEndpointServerImpl.this.handleResponseFromServiceBundle(new ArrayList<Response<Object>>(this.responseBatch));
                    this.responseBatch.clear();
                }
            }

            @Override
            public void limit() {
                ServiceEndpointServerImpl.this.handleResponseFromServiceBundle(new ArrayList<Response<Object>>(this.responseBatch));
                this.responseBatch.clear();
                ServiceEndpointServerImpl.this.httpRequestServerHandler.checkTimeoutsForRequests();
                ServiceEndpointServerImpl.this.webSocketHandler.checkResponseBatchSend();
            }

            @Override
            public void empty() {
                ServiceEndpointServerImpl.this.handleResponseFromServiceBundle(new ArrayList<Response<Object>>(this.responseBatch));
                this.responseBatch.clear();
                ServiceEndpointServerImpl.this.httpRequestServerHandler.checkTimeoutsForRequests();
                ServiceEndpointServerImpl.this.webSocketHandler.checkResponseBatchSend();
            }

            @Override
            public void idle() {
                ServiceEndpointServerImpl.this.handleResponseFromServiceBundle(new ArrayList<Response<Object>>(this.responseBatch));
                this.responseBatch.clear();
                ServiceEndpointServerImpl.this.httpRequestServerHandler.checkTimeoutsForRequests();
                ServiceEndpointServerImpl.this.webSocketHandler.checkResponseBatchSend();
            }
        };
    }

    private void handleResponseFromServiceBundle(List<Response<Object>> responses) {
        for (Response<Object> response : responses) {
            Request<Object> request = response.request();
            if (!(request instanceof MethodCall)) continue;
            MethodCall methodCall = (MethodCall)request;
            Request<Object> originatingRequest = methodCall.originatingRequest();
            this.handleResponseFromServiceBundle(response, originatingRequest);
        }
    }

    private void handleResponseFromServiceBundle(Response<Object> response, Request<Object> originatingRequest) {
        if (originatingRequest instanceof HttpRequest) {
            if (originatingRequest.isHandled()) {
                return;
            }
            originatingRequest.handled();
            this.httpRequestServerHandler.handleResponseFromServiceToHttpResponse(response, (HttpRequest)originatingRequest);
        } else if (originatingRequest instanceof WebSocketMessage) {
            originatingRequest.handled();
            this.webSocketHandler.handleResponseFromServiceBundleToWebSocketSender(response, (WebSocketMessage)originatingRequest);
        } else {
            throw new IllegalStateException("Unknown response " + response);
        }
    }

    @Override
    public ServiceEndpointServer flush() {
        this.serviceBundle.flush();
        return this;
    }

    @Override
    public ServiceEndpointServer initServices(Iterable<Object> services) {
        for (Object service : services) {
            if (this.debug) {
                this.logger.debug("registering service: " + service.getClass().getName());
            }
            this.serviceBundle.addService(service);
            this.httpRequestServerHandler.addRestSupportFor(service.getClass(), this.serviceBundle.address());
        }
        return this;
    }

    @Override
    public ServiceEndpointServer addServiceQueue(String address, ServiceQueue serviceQueue) {
        this.serviceBundle().addServiceQueue(address, serviceQueue);
        this.httpRequestServerHandler.addRestSupportFor(serviceQueue.service().getClass(), this.serviceBundle().address());
        return this;
    }

    @Override
    public ServiceEndpointServer initServices(Object ... services) {
        for (Object service : services) {
            if (this.debug) {
                this.logger.debug("registering service: " + service.getClass().getName());
            }
            this.serviceBundle.addService(service);
            this.httpRequestServerHandler.addRestSupportFor(service.getClass(), this.serviceBundle.address());
        }
        return this;
    }

    @Override
    public ServiceBundle serviceBundle() {
        return this.serviceBundle;
    }
}

