/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.server;

import io.advantageous.qbit.GlobalConstants;
import io.advantageous.qbit.QBit;
import io.advantageous.qbit.http.server.websocket.WebSocketMessage;
import io.advantageous.qbit.http.websocket.WebSocketSender;
import io.advantageous.qbit.message.MethodCall;
import io.advantageous.qbit.message.Request;
import io.advantageous.qbit.message.Response;
import io.advantageous.qbit.message.impl.MethodCallImpl;
import io.advantageous.qbit.message.impl.ResponseImpl;
import io.advantageous.qbit.queue.SendQueue;
import io.advantageous.qbit.service.ServiceBundle;
import io.advantageous.qbit.spi.ProtocolEncoder;
import io.advantageous.qbit.spi.ProtocolParser;
import io.advantageous.qbit.util.Timer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketServiceServerHandler {
    protected final int batchSize;
    protected final ThreadLocal<ProtocolEncoder> encoderRef = new ThreadLocal<ProtocolEncoder>(){

        @Override
        protected ProtocolEncoder initialValue() {
            return QBit.factory().createEncoder();
        }
    };
    protected final ThreadLocal<ProtocolParser> parserRef = new ThreadLocal<ProtocolParser>(){

        @Override
        protected ProtocolParser initialValue() {
            return QBit.factory().createProtocolParser();
        }
    };
    protected final long flushResponseInterval = 200L;
    private final Logger logger = LoggerFactory.getLogger(WebSocketServiceServerHandler.class);
    private final boolean debug = GlobalConstants.DEBUG || this.logger.isDebugEnabled();
    private final SendQueue<MethodCall<Object>> methodCallSendQueue;
    private final Map<String, WebSocketDelegate> webSocketDelegateMap = new ConcurrentHashMap<String, WebSocketDelegate>(100);
    private final ExecutorService protocolParserThreadPool;
    private final ExecutorService protocolEncoderThreadPool;
    protected volatile long flushResponseLastTimestamp = 0L;

    public WebSocketServiceServerHandler(int batchSize, ServiceBundle serviceBundle, int parseWorkersCount, int encodeWorkersCount) {
        this.batchSize = batchSize;
        this.methodCallSendQueue = serviceBundle.methodSendQueue();
        AtomicInteger threadId = new AtomicInteger();
        this.protocolParserThreadPool = Executors.newFixedThreadPool(parseWorkersCount, r -> {
            Thread thread = new Thread(r);
            thread.setName("WebSocketProtocolParser-" + threadId.incrementAndGet());
            thread.setDaemon(true);
            return thread;
        });
        this.protocolEncoderThreadPool = Executors.newFixedThreadPool(encodeWorkersCount, r -> {
            Thread thread = new Thread(r);
            thread.setName("WebSocketProtocolEncoder-" + threadId.incrementAndGet());
            thread.setDaemon(true);
            return thread;
        });
    }

    public void handleWebSocketClose(WebSocketMessage webSocketMessage) {
        this.webSocketDelegateMap.remove(webSocketMessage.getRemoteAddress());
    }

    public void webSocketQueueIdle(Void v) {
        this.methodCallSendQueue.flushSends();
    }

    public void handleWebSocketCall(WebSocketMessage webSocketMessage) {
        WebSocketDelegate webSocketDelegate;
        if (this.debug) {
            this.logger.debug("WebSocket message: " + webSocketMessage);
        }
        if ((webSocketDelegate = this.webSocketDelegateMap.get(webSocketMessage.getRemoteAddress())) == null) {
            webSocketDelegate = new WebSocketDelegate(this.batchSize, webSocketMessage);
            this.webSocketDelegateMap.put(webSocketMessage.getRemoteAddress(), webSocketDelegate);
        }
        this.protocolParserThreadPool.execute(() -> {
            try {
                List<MethodCall<Object>> methodCallListToBeParsedFromBody = this.createMethodCallListToBeParsedFromBody(webSocketMessage.getRemoteAddress(), webSocketMessage.getMessage(), webSocketMessage);
                this.methodCallSendQueue.sendBatch((Collection<MethodCall<Object>>)methodCallListToBeParsedFromBody);
            }
            catch (Exception ex) {
                this.logger.error("", (Throwable)ex);
            }
        });
    }

    public void handleResponseFromServiceBundleToWebSocketSender(Response<Object> response, WebSocketMessage originatingRequest) {
        WebSocketMessage webSocketMessage = originatingRequest;
        try {
            WebSocketDelegate webSocketDelegate = this.webSocketDelegateMap.get(webSocketMessage.getRemoteAddress());
            if (webSocketDelegate == null) {
                String responseAsText = this.encoderRef.get().encodeAsString(response);
                webSocketMessage.getSender().sendText(responseAsText);
            } else {
                webSocketDelegate.send(response);
            }
        }
        catch (Exception ex) {
            this.logger.warn("websocket unable to sendText response", (Throwable)ex);
        }
    }

    public List<MethodCall<Object>> createMethodCallListToBeParsedFromBody(String addressPrefix, Object body, Request<Object> originatingRequest) {
        List<Object> methodCalls = body != null ? this.parserRef.get().parseMethodCallListUsingAddressPrefix(addressPrefix, body) : Collections.emptyList();
        if (methodCalls == null || methodCalls.size() == 0) {
            if (originatingRequest instanceof WebSocketMessage) {
                WebSocketMessage webSocketMessage = (WebSocketMessage)originatingRequest;
                Response<Object> response = ResponseImpl.response(-1L, Timer.timer().now(), "SYSTEM", "ERROR", "CAN'T HANDLE CALL", originatingRequest, true);
                WebSocketSender sender = webSocketMessage.getSender();
                sender.sendText(this.encoderRef.get().encodeAsString(response));
            }
            return Collections.emptyList();
        }
        for (MethodCall methodCall : methodCalls) {
            if (!(methodCall instanceof MethodCallImpl)) continue;
            MethodCallImpl method = (MethodCallImpl)methodCall;
            method.originatingRequest(originatingRequest);
        }
        return methodCalls;
    }

    public void checkResponseBatchSend() {
        long now = Timer.timer().now();
        long duration = now - this.flushResponseLastTimestamp;
        if (duration > 200L) {
            this.flushResponseLastTimestamp = now;
            Collection<WebSocketDelegate> values = this.webSocketDelegateMap.values();
            for (WebSocketDelegate ws : values) {
                long dur = now - ws.lastSend;
                if (dur <= 200L) continue;
                ws.buildAndSendMessages(null, now);
            }
        }
    }

    class WebSocketDelegate {
        final int requestBatchSize;
        final BlockingQueue<Response<Object>> outputMessages;
        final WebSocketMessage serverWebSocket;
        volatile long lastSend;

        private WebSocketDelegate(int requestBatchSize, WebSocketMessage serverWebSocket) {
            this.requestBatchSize = requestBatchSize;
            this.outputMessages = new ArrayBlockingQueue<Response<Object>>(requestBatchSize);
            this.serverWebSocket = serverWebSocket;
        }

        public void send(Response<Object> message) {
            if (!this.outputMessages.offer(message)) {
                this.buildAndSendMessages(message, Timer.timer().now());
            }
        }

        private void buildAndSendMessages(Response<Object> message, long now) {
            if (this.outputMessages.size() == 0 && message == null) {
                return;
            }
            ArrayList<Response<Object>> messages = new ArrayList<Response<Object>>(this.outputMessages.size() + 1);
            Response currentMessage = (Response)this.outputMessages.poll();
            while (currentMessage != null) {
                messages.add(currentMessage);
                currentMessage = (Response)this.outputMessages.poll();
            }
            if (message != null) {
                messages.add(message);
            }
            WebSocketServiceServerHandler.this.protocolEncoderThreadPool.execute(() -> {
                String textMessage = WebSocketServiceServerHandler.this.encoderRef.get().encodeAsString(messages);
                this.serverWebSocket.getSender().sendText(textMessage);
            });
            this.lastSend = now;
        }
    }
}

