/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.service;

import io.advantageous.qbit.config.PropertyResolver;
import io.advantageous.qbit.service.impl.CallbackManager;
import io.advantageous.qbit.service.impl.CallbackManagerWithTimeout;
import io.advantageous.qbit.util.Timer;
import java.util.Properties;

public class CallbackManagerBuilder {
    private String name;
    private boolean handleTimeouts = false;
    private long timeOutMS = 30000L;
    private long checkInterval = 5000L;
    private Timer timer;
    public static String CONTEXT = "qbit.callbackmanager.";

    public static CallbackManagerBuilder callbackManagerBuilder() {
        return new CallbackManagerBuilder();
    }

    public CallbackManagerBuilder(PropertyResolver propertyResolver) {
        this.handleTimeouts = propertyResolver.getBooleanProperty("handleTimeouts", this.handleTimeouts);
        this.timeOutMS = propertyResolver.getLongProperty("timeOutMS", this.timeOutMS);
        this.checkInterval = propertyResolver.getLongProperty("checkInterval", this.checkInterval);
    }

    public CallbackManagerBuilder() {
        this(PropertyResolver.createSystemPropertyResolver(CONTEXT));
    }

    public CallbackManagerBuilder(Properties properties) {
        this(PropertyResolver.createPropertiesPropertyResolver(CONTEXT, properties));
    }

    public String getName() {
        return this.name;
    }

    public CallbackManagerBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public boolean isHandleTimeouts() {
        return this.handleTimeouts;
    }

    public CallbackManagerBuilder setHandleTimeouts(boolean handleTimeouts) {
        this.handleTimeouts = handleTimeouts;
        return this;
    }

    public long getTimeOutMS() {
        return this.timeOutMS;
    }

    public CallbackManagerBuilder setTimeOutMS(long timeOutMS) {
        this.timeOutMS = timeOutMS;
        return this;
    }

    public long getCheckInterval() {
        return this.checkInterval;
    }

    public CallbackManagerBuilder setCheckInterval(long checkInterval) {
        this.checkInterval = checkInterval;
        return this;
    }

    public Timer getTimer() {
        if (this.timer == null) {
            this.timer = Timer.timer();
        }
        return this.timer;
    }

    public CallbackManagerBuilder setTimer(Timer timer) {
        this.timer = timer;
        return this;
    }

    public CallbackManager build() {
        return new CallbackManagerWithTimeout(this.getTimer(), this.getName(), this.isHandleTimeouts(), this.getTimeOutMS(), this.getCheckInterval());
    }
}

