/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.service;

import io.advantageous.boon.core.reflection.ClassMeta;
import io.advantageous.boon.core.reflection.MethodAccess;
import io.advantageous.qbit.QBit;
import io.advantageous.qbit.events.EventManager;
import io.advantageous.qbit.message.MethodCall;
import io.advantageous.qbit.message.Request;
import io.advantageous.qbit.message.Response;
import io.advantageous.qbit.queue.Queue;
import io.advantageous.qbit.queue.QueueBuilder;
import io.advantageous.qbit.queue.QueueCallBackHandler;
import io.advantageous.qbit.queue.ReceiveQueueListener;
import io.advantageous.qbit.queue.impl.QueueCallBackHandlerHub;
import io.advantageous.qbit.service.AfterMethodCall;
import io.advantageous.qbit.service.BeforeMethodCall;
import io.advantageous.qbit.service.CallbackManagerBuilder;
import io.advantageous.qbit.service.ServiceMethodHandler;
import io.advantageous.qbit.service.ServiceQueue;
import io.advantageous.qbit.service.health.HealthServiceAsync;
import io.advantageous.qbit.service.health.ServiceHealthListener;
import io.advantageous.qbit.service.impl.CallbackManager;
import io.advantageous.qbit.service.impl.NoOpAfterMethodCall;
import io.advantageous.qbit.service.impl.NoOpInputMethodCallQueueListener;
import io.advantageous.qbit.service.impl.ServiceConstants;
import io.advantageous.qbit.service.impl.ServiceQueueImpl;
import io.advantageous.qbit.service.stats.ServiceQueueSizer;
import io.advantageous.qbit.service.stats.ServiceStatsListener;
import io.advantageous.qbit.service.stats.StatsCollector;
import io.advantageous.qbit.system.QBitSystemManager;
import io.advantageous.qbit.transforms.NoOpResponseTransformer;
import io.advantageous.qbit.transforms.Transformer;
import io.advantageous.qbit.util.Timer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceBuilder {
    private final Logger logger = LoggerFactory.getLogger(ServiceBuilder.class);
    private final boolean debug = this.logger.isDebugEnabled();
    private boolean handleCallbacks;
    private ServiceMethodHandler serviceMethodHandler;
    private BeforeMethodCall beforeMethodCall = ServiceConstants.NO_OP_BEFORE_METHOD_CALL;
    private BeforeMethodCall beforeMethodCallAfterTransform = ServiceConstants.NO_OP_BEFORE_METHOD_CALL;
    private AfterMethodCall afterMethodCall = new NoOpAfterMethodCall();
    private AfterMethodCall afterMethodCallAfterTransform = new NoOpAfterMethodCall();
    private ReceiveQueueListener<MethodCall<Object>> inputQueueListener = new NoOpInputMethodCallQueueListener();
    private Transformer<Request, Object> requestObjectTransformer = ServiceConstants.NO_OP_ARG_TRANSFORM;
    private Transformer<Response<Object>, Response> responseObjectTransformer = new NoOpResponseTransformer();
    private Queue<Response<Object>> responseQueue;
    private QueueBuilder requestQueueBuilder;
    private QueueBuilder responseQueueBuilder;
    private boolean asyncResponse = true;
    private boolean invokeDynamic = true;
    private String rootAddress;
    private String serviceAddress;
    private Object serviceObject;
    private QBitSystemManager qBitSystemManager;
    private List<QueueCallBackHandler> queueCallBackHandlers;
    private Timer timer;
    private StatsConfig statsConfig;
    private CallbackManager callbackManager;
    private CallbackManagerBuilder callbackManagerBuilder;
    private boolean createCallbackHandler = true;
    private EventManager eventManager;

    public static ServiceBuilder serviceBuilder() {
        return new ServiceBuilder();
    }

    public boolean isCreateCallbackHandler() {
        return this.createCallbackHandler;
    }

    public ServiceBuilder setCreateCallbackHandler(boolean createCallbackHandler) {
        this.createCallbackHandler = createCallbackHandler;
        return this;
    }

    public CallbackManagerBuilder getCallbackManagerBuilder() {
        if (this.callbackManagerBuilder == null && this.isCreateCallbackHandler()) {
            this.callbackManagerBuilder = CallbackManagerBuilder.callbackManagerBuilder();
            if (this.serviceObject != null) {
                this.callbackManagerBuilder.setName(this.serviceObject.getClass().getSimpleName());
            }
        }
        return this.callbackManagerBuilder;
    }

    public ServiceBuilder setCallbackManagerBuilder(CallbackManagerBuilder callbackManagerBuilder) {
        this.callbackManagerBuilder = callbackManagerBuilder;
        return this;
    }

    public CallbackManager getCallbackManager() {
        if (this.callbackManager == null && this.isCreateCallbackHandler()) {
            this.callbackManager = this.getCallbackManagerBuilder().build();
        }
        return this.callbackManager;
    }

    public ServiceBuilder setCallbackManager(CallbackManager callbackManager) {
        this.callbackManager = callbackManager;
        return this;
    }

    public List<QueueCallBackHandler> getQueueCallBackHandlers() {
        if (this.queueCallBackHandlers == null) {
            this.queueCallBackHandlers = new ArrayList<QueueCallBackHandler>();
        }
        return this.queueCallBackHandlers;
    }

    public ServiceBuilder setQueueCallBackHandlers(List<QueueCallBackHandler> queueCallBackHandlers) {
        this.queueCallBackHandlers = queueCallBackHandlers;
        return this;
    }

    public ServiceBuilder addQueueCallbackHandler(QueueCallBackHandler queueCallBackHandler) {
        this.getQueueCallBackHandlers().add(queueCallBackHandler);
        return this;
    }

    private QueueCallBackHandler buildQueueCallBackHandler() {
        if (this.queueCallBackHandlers == null || this.queueCallBackHandlers.size() == 0) {
            return new QueueCallBackHandler(){

                @Override
                public void queueLimit() {
                }

                @Override
                public void queueEmpty() {
                }
            };
        }
        return new QueueCallBackHandlerHub(this.queueCallBackHandlers);
    }

    public QBitSystemManager getSystemManager() {
        return this.qBitSystemManager;
    }

    public ServiceBuilder setSystemManager(QBitSystemManager qBitSystemManager) {
        this.qBitSystemManager = qBitSystemManager;
        return this;
    }

    public QueueBuilder getResponseQueueBuilder() {
        if (this.responseQueueBuilder == null) {
            this.responseQueueBuilder = QueueBuilder.queueBuilder();
        }
        return this.responseQueueBuilder;
    }

    public ServiceBuilder setResponseQueueBuilder(QueueBuilder responseQueueBuilder) {
        this.responseQueueBuilder = responseQueueBuilder;
        return this;
    }

    public Queue<Response<Object>> getResponseQueue() {
        return this.responseQueue;
    }

    public ServiceBuilder setResponseQueue(Queue<Response<Object>> responseQueue) {
        this.responseQueue = responseQueue;
        return this;
    }

    public String getServiceAddress() {
        return this.serviceAddress;
    }

    public ServiceBuilder setServiceAddress(String serviceAddress) {
        this.serviceAddress = serviceAddress;
        return this;
    }

    public Object getServiceObject() {
        return this.serviceObject;
    }

    public ServiceBuilder setServiceObject(Object serviceObject) {
        if (serviceObject == null) {
            throw new IllegalArgumentException("ServiceBuilder setServiceObject:: serviceObject cant be null");
        }
        ClassMeta classMeta = ClassMeta.classMeta(serviceObject.getClass());
        Iterable methods = classMeta.methods();
        HashSet<String> methodNames = new HashSet<String>();
        for (MethodAccess methodAccess : methods) {
            if (methodAccess.method().getDeclaringClass().isInterface()) continue;
            if (methodNames.contains(methodAccess.name())) {
                this.logger.error("QBit does not support method overloading methods in Service Queues problem name " + methodAccess.name() + " is overloaded " + methodNames + " from class " + classMeta.longName());
                continue;
            }
            methodNames.add(methodAccess.name());
        }
        this.serviceObject = serviceObject;
        return this;
    }

    public String getRootAddress() {
        return this.rootAddress;
    }

    public ServiceBuilder setRootAddress(String rootAddress) {
        this.rootAddress = rootAddress;
        return this;
    }

    public ServiceMethodHandler getServiceMethodHandler() {
        return this.serviceMethodHandler;
    }

    public ServiceBuilder setServiceMethodHandler(ServiceMethodHandler serviceMethodHandler) {
        this.serviceMethodHandler = serviceMethodHandler;
        return this;
    }

    public BeforeMethodCall getBeforeMethodCall() {
        return this.beforeMethodCall;
    }

    public ServiceBuilder setBeforeMethodCall(BeforeMethodCall beforeMethodCall) {
        this.beforeMethodCall = beforeMethodCall;
        return this;
    }

    public BeforeMethodCall getBeforeMethodCallAfterTransform() {
        return this.beforeMethodCallAfterTransform;
    }

    public ServiceBuilder setBeforeMethodCallAfterTransform(BeforeMethodCall beforeMethodCallAfterTransform) {
        this.beforeMethodCallAfterTransform = beforeMethodCallAfterTransform;
        return this;
    }

    public AfterMethodCall getAfterMethodCall() {
        return this.afterMethodCall;
    }

    public ServiceBuilder setAfterMethodCall(AfterMethodCall afterMethodCall) {
        this.afterMethodCall = afterMethodCall;
        return this;
    }

    public AfterMethodCall getAfterMethodCallAfterTransform() {
        return this.afterMethodCallAfterTransform;
    }

    public ServiceBuilder setAfterMethodCallAfterTransform(AfterMethodCall afterMethodCallAfterTransform) {
        this.afterMethodCallAfterTransform = afterMethodCallAfterTransform;
        return this;
    }

    public ReceiveQueueListener<MethodCall<Object>> getInputQueueListener() {
        return this.inputQueueListener;
    }

    public ServiceBuilder setInputQueueListener(ReceiveQueueListener<MethodCall<Object>> inputQueueListener) {
        this.inputQueueListener = inputQueueListener;
        return this;
    }

    public Transformer<Request, Object> getRequestObjectTransformer() {
        return this.requestObjectTransformer;
    }

    public ServiceBuilder setRequestObjectTransformer(Transformer<Request, Object> requestObjectTransformer) {
        this.requestObjectTransformer = requestObjectTransformer;
        return this;
    }

    public Transformer<Response<Object>, Response> getResponseObjectTransformer() {
        return this.responseObjectTransformer;
    }

    public ServiceBuilder setResponseObjectTransformer(Transformer<Response<Object>, Response> responseObjectTransformer) {
        this.responseObjectTransformer = responseObjectTransformer;
        return this;
    }

    public QueueBuilder getRequestQueueBuilder() {
        if (this.requestQueueBuilder == null) {
            this.requestQueueBuilder = QueueBuilder.queueBuilder();
        }
        return this.requestQueueBuilder;
    }

    public ServiceBuilder setRequestQueueBuilder(QueueBuilder requestQueueBuilder) {
        this.requestQueueBuilder = requestQueueBuilder;
        return this;
    }

    public boolean isAsyncResponse() {
        return this.asyncResponse;
    }

    public ServiceBuilder setAsyncResponse(boolean asyncResponse) {
        this.asyncResponse = asyncResponse;
        return this;
    }

    public boolean isInvokeDynamic() {
        return this.invokeDynamic;
    }

    public ServiceBuilder setInvokeDynamic(boolean invokeDynamic) {
        this.invokeDynamic = invokeDynamic;
        return this;
    }

    public boolean isHandleCallbacks() {
        return this.handleCallbacks;
    }

    public ServiceBuilder setHandleCallbacks(boolean handleCallbacks) {
        this.handleCallbacks = handleCallbacks;
        return this;
    }

    public Timer getTimer() {
        if (this.timer == null) {
            this.timer = Timer.timer();
        }
        return this.timer;
    }

    public ServiceBuilder setTimer(Timer timer) {
        this.timer = timer;
        return this;
    }

    public ServiceBuilder registerHealthChecks(HealthServiceAsync healthServiceAsync, String serviceName) {
        this.addQueueCallbackHandler(new ServiceHealthListener(serviceName, healthServiceAsync, this.getTimer(), 5L, 10L, TimeUnit.SECONDS));
        return this;
    }

    public ServiceBuilder registerStatsCollections(String serviceName, StatsCollector statsCollector, int flushTimeSeconds, int sampleEvery) {
        this.statsConfig = new StatsConfig(serviceName, statsCollector, flushTimeSeconds, sampleEvery);
        return this;
    }

    public ServiceBuilder registerHealthChecksWithTTLInSeconds(HealthServiceAsync healthServiceAsync, String serviceName, int seconds) {
        int ttl = seconds > 2 ? seconds : 10;
        int checkInterval = ttl / 2 == 0 ? 1 : ttl / 2;
        this.addQueueCallbackHandler(new ServiceHealthListener(serviceName, healthServiceAsync, this.getTimer(), checkInterval, ttl, TimeUnit.SECONDS));
        return this;
    }

    public ServiceQueue build(Object serviceObject) {
        this.serviceObject = serviceObject;
        return this.build();
    }

    public ServiceQueue build() {
        if (this.debug) {
            this.logger.debug("Building a service");
        }
        ServiceQueueSizer serviceQueueSizer = null;
        if (this.statsConfig != null) {
            serviceQueueSizer = new ServiceQueueSizer();
            this.addQueueCallbackHandler(new ServiceStatsListener(this.statsConfig.serviceName, this.statsConfig.statsCollector, this.getTimer(), this.statsConfig.flushTimeSeconds, TimeUnit.SECONDS, this.statsConfig.sampleEvery, serviceQueueSizer));
        }
        ServiceQueueImpl serviceQueue = new ServiceQueueImpl(this.getRootAddress(), this.getServiceAddress(), this.getServiceObject(), this.getRequestQueueBuilder(), this.getResponseQueueBuilder(), QBit.factory().createServiceMethodHandler(this.isInvokeDynamic()), this.getResponseQueue(), this.isAsyncResponse(), this.isHandleCallbacks(), this.getSystemManager(), this.getBeforeMethodCall(), this.getBeforeMethodCallAfterTransform(), this.getAfterMethodCall(), this.getAfterMethodCallAfterTransform(), this.buildQueueCallBackHandler(), this.getCallbackManager());
        if (serviceQueueSizer != null) {
            serviceQueueSizer.setServiceQueue(serviceQueue);
        }
        if (this.qBitSystemManager != null) {
            this.qBitSystemManager.registerService(serviceQueue);
        }
        if (this.eventManager != null) {
            this.eventManager.joinService(serviceQueue);
        }
        return serviceQueue;
    }

    public ServiceQueue buildAndStart() {
        return this.build().startServiceQueue();
    }

    public ServiceQueue buildAndStartAll() {
        this.setCreateCallbackHandler(true);
        return this.build().startAll();
    }

    public ServiceBuilder setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
        return this;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    private static class StatsConfig {
        final String serviceName;
        final StatsCollector statsCollector;
        final int flushTimeSeconds;
        final int sampleEvery;

        private StatsConfig(String serviceName, StatsCollector statsCollector, int flushTimeSeconds, int sampleEvery) {
            this.serviceName = serviceName;
            this.statsCollector = statsCollector;
            this.flushTimeSeconds = flushTimeSeconds;
            this.sampleEvery = sampleEvery;
        }
    }
}

