/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.service;

import io.advantageous.qbit.message.MethodCall;
import io.advantageous.qbit.message.Response;
import io.advantageous.qbit.queue.Queue;
import io.advantageous.qbit.queue.ReceiveQueueListener;
import io.advantageous.qbit.queue.SendQueue;
import io.advantageous.qbit.service.EndPoint;
import io.advantageous.qbit.service.ServiceQueue;
import io.advantageous.qbit.service.Startable;
import io.advantageous.qbit.service.dispatchers.RoundRobinServiceWorkerBuilder;
import io.advantageous.qbit.service.dispatchers.ServiceMethodDispatcher;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;

public interface ServiceBundle
extends EndPoint,
Startable {
    @Override
    public String address();

    public ServiceBundle addServiceObject(String var1, Object var2);

    default public ServiceBundle addServiceQueue(String address, ServiceQueue serviceQueue) {
        throw new IllegalStateException("Not implemented");
    }

    default public ServiceBundle addServiceConsumer(String address, Consumer<MethodCall<Object>> service) {
        this.addServiceObject(address, service);
        return this;
    }

    default public ServiceBundle addRoundRobinService(String address, int numServices, Supplier<Object> serviceInstanceSupplier) {
        RoundRobinServiceWorkerBuilder roundRobinServiceWorkerBuilder = RoundRobinServiceWorkerBuilder.roundRobinServiceWorkerBuilder().setWorkerCount(numServices);
        roundRobinServiceWorkerBuilder.setServiceObjectSupplier(serviceInstanceSupplier);
        ServiceMethodDispatcher serviceMethodDispatcher = roundRobinServiceWorkerBuilder.build();
        serviceMethodDispatcher.start();
        this.addServiceConsumer(address, serviceMethodDispatcher);
        return this;
    }

    public ServiceBundle addService(Object var1);

    public Queue<Response<Object>> responses();

    public SendQueue<MethodCall<Object>> methodSendQueue();

    public void flushSends();

    @Override
    public void stop();

    public List<String> endPoints();

    public void startReturnHandlerProcessor(ReceiveQueueListener<Response<Object>> var1);

    default public void startWebResponseReturnHandler(ReceiveQueueListener<Response<Object>> listener) {
    }

    public void startReturnHandlerProcessor();

    default public ServiceBundle startUpCallQueue() {
        return this;
    }

    @Override
    default public void start() {
        this.startUpCallQueue();
        this.startReturnHandlerProcessor();
    }

    default public ServiceBundle startServiceBundle() {
        this.start();
        return this;
    }

    public <T> T createLocalProxy(Class<T> var1, String var2);

    default public <T> T createOneWayLocalProxy(Class<T> serviceInterface, String myService) {
        return this.createLocalProxy(serviceInterface, myService);
    }
}

