/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.service;

import io.advantageous.qbit.QBit;
import io.advantageous.qbit.config.PropertyResolver;
import io.advantageous.qbit.events.EventManager;
import io.advantageous.qbit.message.Request;
import io.advantageous.qbit.message.Response;
import io.advantageous.qbit.queue.Queue;
import io.advantageous.qbit.queue.QueueBuilder;
import io.advantageous.qbit.service.BeforeMethodCall;
import io.advantageous.qbit.service.CallbackManagerBuilder;
import io.advantageous.qbit.service.ServiceBundle;
import io.advantageous.qbit.service.health.HealthServiceAsync;
import io.advantageous.qbit.service.impl.CallbackManager;
import io.advantageous.qbit.service.impl.ServiceConstants;
import io.advantageous.qbit.service.stats.StatsCollector;
import io.advantageous.qbit.system.QBitSystemManager;
import io.advantageous.qbit.transforms.Transformer;
import io.advantageous.qbit.util.Timer;
import java.util.Properties;

public class ServiceBundleBuilder {
    private static final String QBIT_SERVER_BUNDLE_BUILDER = "qbit.service.bundle.builder.";
    private QueueBuilder requestQueueBuilder;
    private QueueBuilder responseQueueBuilder;
    private QueueBuilder webResponseQueueBuilder;
    private boolean invokeDynamic = true;
    private String address = "/services";
    private boolean eachServiceInItsOwnThread = true;
    private QBitSystemManager qBitSystemManager;
    private Queue<Response<Object>> responseQueue;
    private HealthServiceAsync healthService = null;
    private StatsCollector statsCollector = null;
    private int statsFlushRateSeconds;
    private int checkTimingEveryXCalls = -1;
    private CallbackManager callbackManager;
    private CallbackManagerBuilder callbackManagerBuilder;
    private EventManager eventManager;
    private BeforeMethodCall beforeMethodCall = ServiceConstants.NO_OP_BEFORE_METHOD_CALL;
    private BeforeMethodCall beforeMethodCallAfterTransform = ServiceConstants.NO_OP_BEFORE_METHOD_CALL;
    private Transformer<Request, Object> argTransformer = ServiceConstants.NO_OP_ARG_TRANSFORM;
    private Timer timer;

    public CallbackManagerBuilder getCallbackManagerBuilder() {
        if (this.callbackManagerBuilder == null) {
            this.callbackManagerBuilder = CallbackManagerBuilder.callbackManagerBuilder();
            if (this.address != null) {
                this.callbackManagerBuilder.setName("ServiceBundle-" + this.address);
            }
        }
        return this.callbackManagerBuilder;
    }

    public ServiceBundleBuilder setCallbackManagerBuilder(CallbackManagerBuilder callbackManagerBuilder) {
        this.callbackManagerBuilder = callbackManagerBuilder;
        return this;
    }

    public CallbackManager getCallbackManager() {
        if (this.callbackManager == null) {
            this.callbackManager = this.getCallbackManagerBuilder().build();
        }
        return this.callbackManager;
    }

    public ServiceBundleBuilder setCallbackManager(CallbackManager callbackManager) {
        this.callbackManager = callbackManager;
        return this;
    }

    public static ServiceBundleBuilder serviceBundleBuilder() {
        return new ServiceBundleBuilder();
    }

    public ServiceBundleBuilder(PropertyResolver propertyResolver) {
        this.invokeDynamic = propertyResolver.getBooleanProperty("invokeDynamic", true);
        this.statsFlushRateSeconds = propertyResolver.getIntegerProperty("statsFlushRateSeconds", 5);
        this.checkTimingEveryXCalls = propertyResolver.getIntegerProperty("checkTimingEveryXCalls", 10000);
    }

    public ServiceBundleBuilder() {
        this(PropertyResolver.createSystemPropertyResolver(QBIT_SERVER_BUNDLE_BUILDER));
    }

    public ServiceBundleBuilder(Properties properties) {
        this(PropertyResolver.createPropertiesPropertyResolver(QBIT_SERVER_BUNDLE_BUILDER, properties));
    }

    public QueueBuilder getWebResponseQueueBuilder() {
        if (this.webResponseQueueBuilder == null) {
            this.webResponseQueueBuilder = new QueueBuilder();
        }
        return this.webResponseQueueBuilder;
    }

    public ServiceBundleBuilder setWebResponseQueueBuilder(QueueBuilder webResponseQueueBuilder) {
        this.webResponseQueueBuilder = webResponseQueueBuilder;
        return this;
    }

    public QBitSystemManager getSystemManager() {
        return this.qBitSystemManager;
    }

    public ServiceBundleBuilder setSystemManager(QBitSystemManager qBitSystemManager) {
        this.qBitSystemManager = qBitSystemManager;
        return this;
    }

    public boolean isInvokeDynamic() {
        return this.invokeDynamic;
    }

    public ServiceBundleBuilder setInvokeDynamic(boolean invokeDynamic) {
        this.invokeDynamic = invokeDynamic;
        return this;
    }

    public boolean isEachServiceInItsOwnThread() {
        return this.eachServiceInItsOwnThread;
    }

    public ServiceBundleBuilder setEachServiceInItsOwnThread(boolean eachServiceInItsOwnThread) {
        this.eachServiceInItsOwnThread = eachServiceInItsOwnThread;
        return this;
    }

    public BeforeMethodCall getBeforeMethodCall() {
        return this.beforeMethodCall;
    }

    public ServiceBundleBuilder setBeforeMethodCall(BeforeMethodCall beforeMethodCall) {
        this.beforeMethodCall = beforeMethodCall;
        return this;
    }

    public BeforeMethodCall getBeforeMethodCallAfterTransform() {
        return this.beforeMethodCallAfterTransform;
    }

    public ServiceBundleBuilder setBeforeMethodCallAfterTransform(BeforeMethodCall beforeMethodCallAfterTransform) {
        this.beforeMethodCallAfterTransform = beforeMethodCallAfterTransform;
        return this;
    }

    public Transformer<Request, Object> getArgTransformer() {
        return this.argTransformer;
    }

    public ServiceBundleBuilder setArgTransformer(Transformer<Request, Object> argTransformer) {
        this.argTransformer = argTransformer;
        return this;
    }

    public String getAddress() {
        return this.address;
    }

    public ServiceBundleBuilder setAddress(String address) {
        this.address = address;
        return this;
    }

    public QueueBuilder getRequestQueueBuilder() {
        if (this.requestQueueBuilder == null) {
            this.requestQueueBuilder = QueueBuilder.queueBuilder();
        }
        return this.requestQueueBuilder;
    }

    public ServiceBundleBuilder setRequestQueueBuilder(QueueBuilder queueBuilder) {
        this.requestQueueBuilder = queueBuilder;
        return this;
    }

    public QueueBuilder getResponseQueueBuilder() {
        if (this.responseQueueBuilder == null) {
            this.responseQueueBuilder = this.responseQueue != null ? new QueueBuilder(){

                @Override
                public <T> Queue<T> build() {
                    return ServiceBundleBuilder.this.responseQueue;
                }
            } : QueueBuilder.queueBuilder();
        }
        return this.responseQueueBuilder;
    }

    public ServiceBundleBuilder setResponseQueueBuilder(QueueBuilder queueBuilder) {
        this.responseQueueBuilder = queueBuilder;
        return this;
    }

    public Queue<Response<Object>> getResponseQueue() {
        return this.responseQueue;
    }

    public ServiceBundleBuilder setResponseQueue(Queue<Response<Object>> responseQueue) {
        this.responseQueue = responseQueue;
        return this;
    }

    public HealthServiceAsync getHealthService() {
        return this.healthService;
    }

    public ServiceBundleBuilder setHealthService(HealthServiceAsync healthServiceAsync) {
        this.healthService = healthServiceAsync;
        return this;
    }

    public StatsCollector getStatsCollector() {
        return this.statsCollector;
    }

    public ServiceBundleBuilder setStatsCollector(StatsCollector statsCollector) {
        this.statsCollector = statsCollector;
        return this;
    }

    public ServiceBundle build() {
        ServiceBundle serviceBundle = QBit.factory().createServiceBundle(this.getAddress(), this.getRequestQueueBuilder(), this.getResponseQueueBuilder(), this.getWebResponseQueueBuilder(), QBit.factory(), this.eachServiceInItsOwnThread, this.getBeforeMethodCall(), this.getBeforeMethodCallAfterTransform(), this.getArgTransformer(), this.invokeDynamic, this.getSystemManager(), this.getHealthService(), this.getStatsCollector(), this.getTimer(), this.getStatsFlushRateSeconds(), this.getCheckTimingEveryXCalls(), this.getCallbackManager(), this.getEventManager());
        if (serviceBundle != null && this.qBitSystemManager != null) {
            this.qBitSystemManager.registerServiceBundle(serviceBundle);
        }
        if (serviceBundle == null) {
            throw new IllegalStateException("Service Bundle was null");
        }
        return serviceBundle;
    }

    public ServiceBundle buildAndStart() {
        ServiceBundle build = this.build();
        build.startUpCallQueue();
        return build;
    }

    public ServiceBundleBuilder setTimer(Timer timer) {
        this.timer = timer;
        return this;
    }

    public Timer getTimer() {
        if (this.timer == null) {
            this.timer = Timer.timer();
        }
        return this.timer;
    }

    public int getStatsFlushRateSeconds() {
        return this.statsFlushRateSeconds;
    }

    public ServiceBundleBuilder setStatsFlushRateSeconds(int statsFlushRateSeconds) {
        this.statsFlushRateSeconds = statsFlushRateSeconds;
        return this;
    }

    public int getCheckTimingEveryXCalls() {
        return this.checkTimingEveryXCalls;
    }

    public ServiceBundleBuilder setCheckTimingEveryXCalls(int checkTimingEveryXCalls) {
        this.checkTimingEveryXCalls = checkTimingEveryXCalls;
        return this;
    }

    public ServiceBundleBuilder setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
        return this;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }
}

