/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.service;

import io.advantageous.qbit.QBit;
import io.advantageous.qbit.events.EventManager;
import io.advantageous.qbit.service.ServiceQueue;
import io.advantageous.qbit.service.impl.BaseServiceQueueImpl;

public class ServiceContext {
    static final ServiceContext serviceContext = new ServiceContext();

    public static ServiceContext serviceContext() {
        return serviceContext;
    }

    public ServiceQueue currentService() {
        return BaseServiceQueueImpl.currentService();
    }

    public EventManager eventManager() {
        return QBit.factory().systemEventManager();
    }

    public void joinEventManager() {
        EventManager eventManager = this.eventManager();
        ServiceQueue serviceQueue = this.currentService();
        if (serviceQueue != null) {
            eventManager.joinService(serviceQueue);
        }
    }

    public <T> void send(String channel, T message) {
        this.eventManager().send(channel, message);
    }
}

