/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.service.discovery;

import io.advantageous.boon.core.Lists;
import io.advantageous.boon.core.Sys;
import io.advantageous.qbit.service.discovery.ServiceDiscovery;
import io.advantageous.qbit.service.health.HealthStatus;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;

public class EndpointDefinition {
    private final HealthStatus healthStatus;
    private final String id;
    private final String name;
    private final String host;
    private final int port;
    private final long timeToLive;

    static String findHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException("unable to find host name");
        }
    }

    public EndpointDefinition(HealthStatus healthStatus, String id, String name, String host, int port) {
        this.healthStatus = healthStatus;
        this.id = id;
        this.name = name;
        this.host = host;
        this.port = port;
        this.timeToLive = Sys.sysProp((String)(EndpointDefinition.class.getName() + ".timeToLive"), (long)20L);
    }

    public EndpointDefinition(String name, String host, int port) {
        this.healthStatus = HealthStatus.PASS;
        this.id = name + "-" + port + "-" + host.replace('.', '-');
        this.name = name;
        this.host = host;
        this.port = port;
        this.timeToLive = Sys.sysProp((String)(EndpointDefinition.class.getName() + ".timeToLive"), (long)20L);
    }

    public EndpointDefinition(HealthStatus healthStatus, String id, String name, String host, int port, long timeToLive) {
        this.healthStatus = healthStatus;
        this.id = id;
        this.name = name;
        this.host = host;
        this.port = port;
        this.timeToLive = timeToLive;
    }

    public static List<EndpointDefinition> serviceDefinitions(EndpointDefinition ... endpointDefinitions) {
        return Lists.list((Object[])endpointDefinitions);
    }

    public static EndpointDefinition serviceDefinition(String name) {
        return new EndpointDefinition(HealthStatus.PASS, name + "-" + ServiceDiscovery.uniqueString(0), name, EndpointDefinition.findHostName(), 0);
    }

    public static EndpointDefinition serviceDefinition(String name, int port) {
        return new EndpointDefinition(HealthStatus.PASS, name + "-" + ServiceDiscovery.uniqueString(port), name, EndpointDefinition.findHostName(), 0);
    }

    public static EndpointDefinition serviceDefinition(String id, String name, String host, int port) {
        return new EndpointDefinition(HealthStatus.PASS, id, name, host, port);
    }

    public static EndpointDefinition serviceDefinition(String name, String host, int port) {
        return new EndpointDefinition(HealthStatus.PASS, name + "-" + ServiceDiscovery.uniqueString(port), name, host, port);
    }

    public static EndpointDefinition serviceDefinition(String name, String host) {
        return new EndpointDefinition(HealthStatus.PASS, name + "-" + ServiceDiscovery.uniqueString(0), name, host, 0);
    }

    public static EndpointDefinition serviceDefinitionWithId(String name, String host, String id) {
        return new EndpointDefinition(HealthStatus.PASS, id, name, host, 0);
    }

    public HealthStatus getHealthStatus() {
        return this.healthStatus;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EndpointDefinition)) {
            return false;
        }
        EndpointDefinition that = (EndpointDefinition)o;
        if (this.port != that.port) {
            return false;
        }
        if (this.healthStatus != that.healthStatus) {
            return false;
        }
        if (this.host != null ? !this.host.equals(that.host) : that.host != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        return !(this.name == null ? that.name != null : !this.name.equals(that.name));
    }

    public int hashCode() {
        int result = this.healthStatus != null ? this.healthStatus.hashCode() : 0;
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.host != null ? this.host.hashCode() : 0);
        result = 31 * result + this.port;
        return result;
    }

    public String toString() {
        return "ServiceDefinition{status=" + (Object)((Object)this.healthStatus) + ", id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", host='" + this.host + '\'' + ", port=" + this.port + '}';
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }
}

