/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.service.discovery;

import io.advantageous.qbit.service.Startable;
import io.advantageous.qbit.service.Stoppable;
import io.advantageous.qbit.service.discovery.EndpointDefinition;
import io.advantageous.qbit.service.health.HealthStatus;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public interface ServiceDiscovery
extends Startable,
Stoppable {
    public static String uniqueString(int port) {
        try {
            return port + "-" + InetAddress.getLocalHost().getHostName().replace('.', '-');
        }
        catch (UnknownHostException e) {
            return port + "-" + UUID.randomUUID().toString();
        }
    }

    default public EndpointDefinition register(String serviceName, int port) {
        return new EndpointDefinition(HealthStatus.PASS, serviceName + "." + ServiceDiscovery.uniqueString(port), serviceName, null, port);
    }

    default public EndpointDefinition registerWithTTL(String serviceName, int port, int timeToLiveSeconds) {
        return new EndpointDefinition(HealthStatus.PASS, serviceName + "." + ServiceDiscovery.uniqueString(port), serviceName, null, port, timeToLiveSeconds);
    }

    default public EndpointDefinition registerWithIdAndTimeToLive(String serviceName, String serviceId, int port, int timeToLiveSeconds) {
        return new EndpointDefinition(HealthStatus.PASS, serviceId, serviceName, null, port, timeToLiveSeconds);
    }

    default public EndpointDefinition registerWithId(String serviceName, String serviceId, int port) {
        return new EndpointDefinition(HealthStatus.PASS, serviceId, serviceName, null, port);
    }

    default public void watch(String serviceName) {
    }

    default public void checkIn(String serviceId, HealthStatus healthStatus) {
    }

    default public void checkInOk(String serviceId) {
    }

    default public List<EndpointDefinition> loadServices(String serviceName) {
        return Collections.emptyList();
    }

    default public List<EndpointDefinition> loadServicesNow(String serviceName) {
        return Collections.emptyList();
    }

    @Override
    default public void start() {
    }

    @Override
    default public void stop() {
    }

    default public Set<EndpointDefinition> localDefinitions() {
        return Collections.emptySet();
    }
}

