/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.service.discovery;

import io.advantageous.qbit.concurrent.PeriodicScheduler;
import io.advantageous.qbit.service.discovery.ServiceChangedEventChannel;
import io.advantageous.qbit.service.discovery.ServicePoolListener;
import io.advantageous.qbit.service.discovery.impl.ServiceDiscoveryImpl;
import io.advantageous.qbit.service.discovery.spi.ServiceDiscoveryProvider;
import java.util.concurrent.ExecutorService;

public class ServiceDiscoveryBuilder {
    private PeriodicScheduler periodicScheduler;
    private ServiceChangedEventChannel serviceChangedEventChannel;
    private ServicePoolListener servicePoolListener;
    private ExecutorService executorService;
    private ServiceDiscoveryProvider serviceDiscoveryProvider;
    private ServiceDiscoveryProvider backupProvider = null;
    private int pollForServicesIntervalSeconds = 2;
    private int checkInIntervalInSeconds = 2;

    public static ServiceDiscoveryBuilder serviceDiscoveryBuilder() {
        return new ServiceDiscoveryBuilder();
    }

    public int getPollForServicesIntervalSeconds() {
        return this.pollForServicesIntervalSeconds;
    }

    public ServiceDiscoveryBuilder setPollForServicesIntervalSeconds(int pollForServicesIntervalSeconds) {
        this.pollForServicesIntervalSeconds = pollForServicesIntervalSeconds;
        return this;
    }

    public ServiceDiscoveryProvider getServiceDiscoveryProvider() {
        return this.serviceDiscoveryProvider;
    }

    public ServiceDiscoveryBuilder setServiceDiscoveryProvider(ServiceDiscoveryProvider serviceDiscoveryProvider) {
        this.serviceDiscoveryProvider = serviceDiscoveryProvider;
        return this;
    }

    public PeriodicScheduler getPeriodicScheduler() {
        return this.periodicScheduler;
    }

    public ServiceDiscoveryBuilder setPeriodicScheduler(PeriodicScheduler periodicScheduler) {
        this.periodicScheduler = periodicScheduler;
        return this;
    }

    public ServiceChangedEventChannel getServiceChangedEventChannel() {
        return this.serviceChangedEventChannel;
    }

    public ServiceDiscoveryBuilder setServiceChangedEventChannel(ServiceChangedEventChannel serviceChangedEventChannel) {
        this.serviceChangedEventChannel = serviceChangedEventChannel;
        return this;
    }

    public ServicePoolListener getServicePoolListener() {
        return this.servicePoolListener;
    }

    public ServiceDiscoveryBuilder setServicePoolListener(ServicePoolListener servicePoolListener) {
        this.servicePoolListener = servicePoolListener;
        return this;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public ServiceDiscoveryBuilder setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public ServiceDiscoveryProvider getBackupProvider() {
        return this.backupProvider;
    }

    public ServiceDiscoveryBuilder setBackupProvider(ServiceDiscoveryProvider backupProvider) {
        this.backupProvider = backupProvider;
        return this;
    }

    public int getCheckInIntervalInSeconds() {
        return this.checkInIntervalInSeconds;
    }

    public ServiceDiscoveryBuilder setCheckInIntervalInSeconds(int checkInIntervalInSeconds) {
        this.checkInIntervalInSeconds = checkInIntervalInSeconds;
        return this;
    }

    public ServiceDiscoveryImpl build() {
        return new ServiceDiscoveryImpl(this.getPeriodicScheduler(), this.getServiceChangedEventChannel(), this.getServiceDiscoveryProvider(), this.getBackupProvider(), this.getServicePoolListener(), this.getExecutorService(), this.getPollForServicesIntervalSeconds(), this.getCheckInIntervalInSeconds());
    }
}

