/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.service.discovery;

import io.advantageous.qbit.service.discovery.EndpointDefinition;
import io.advantageous.qbit.service.discovery.ServicePoolListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

public class ServicePool {
    private final String serviceName;
    private final AtomicReference<Map<String, EndpointDefinition>> pool = new AtomicReference(new ConcurrentHashMap());
    private final ServicePoolListener servicePoolListener;

    public ServicePool(String serviceName, ServicePoolListener servicePoolListener) {
        this.serviceName = serviceName;
        this.servicePoolListener = servicePoolListener == null ? serviceNameChanged -> {} : servicePoolListener;
    }

    public List<EndpointDefinition> services() {
        return new ArrayList<EndpointDefinition>(this.pool.get().values());
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public boolean setHealthyNodes(List<EndpointDefinition> services) {
        return this.setHealthyNodes(services, this.servicePoolListener);
    }

    public synchronized boolean setHealthyNodes(List<EndpointDefinition> services, ServicePoolListener servicePoolListener) {
        Map<String, EndpointDefinition> oldMap = this.pool.get();
        ConcurrentHashMap<String, EndpointDefinition> newMap = new ConcurrentHashMap<String, EndpointDefinition>(services.size());
        int oldServicesRemoved = 0;
        int newServices = 0;
        for (EndpointDefinition service : services) {
            if (!oldMap.containsKey(service.getId())) {
                ++newServices;
                servicePoolListener.serviceAdded(this.serviceName, service);
            }
            newMap.put(service.getId(), service);
        }
        for (EndpointDefinition service : oldMap.values()) {
            if (newMap.containsKey(service.getId())) continue;
            ++oldServicesRemoved;
            servicePoolListener.serviceRemoved(this.serviceName, service);
        }
        this.pool.set(newMap);
        return this.handleEvents(servicePoolListener, newServices, oldServicesRemoved);
    }

    private boolean handleEvents(ServicePoolListener servicePoolListener, int newServices, int oldServicesRemoved) {
        boolean changed;
        if (oldServicesRemoved > 0) {
            servicePoolListener.servicesRemoved(this.serviceName, newServices);
        }
        if (newServices > 0) {
            servicePoolListener.servicesAdded(this.serviceName, newServices);
        }
        boolean bl = changed = oldServicesRemoved > 0 || newServices > 0;
        if (changed) {
            servicePoolListener.servicePoolChanged(this.serviceName);
        }
        return changed;
    }
}

