/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.service.discovery.impl;

import io.advantageous.boon.core.Sys;
import io.advantageous.qbit.GlobalConstants;
import io.advantageous.qbit.QBit;
import io.advantageous.qbit.concurrent.PeriodicScheduler;
import io.advantageous.qbit.service.discovery.EndpointDefinition;
import io.advantageous.qbit.service.discovery.ServiceChangedEventChannel;
import io.advantageous.qbit.service.discovery.ServiceDiscovery;
import io.advantageous.qbit.service.discovery.ServicePool;
import io.advantageous.qbit.service.discovery.ServicePoolListener;
import io.advantageous.qbit.service.discovery.impl.ServiceHealthCheckIn;
import io.advantageous.qbit.service.discovery.spi.ServiceDiscoveryProvider;
import io.advantageous.qbit.service.health.HealthStatus;
import io.advantageous.qbit.util.ConcurrentHashSet;
import io.advantageous.qbit.util.Timer;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceDiscoveryImpl
implements ServiceDiscovery {
    private final PeriodicScheduler periodicScheduler;
    private final BlockingQueue<String> doneQueue = new LinkedTransferQueue<String>();
    private final BlockingQueue<ServiceHealthCheckIn> checkInsQueue = new LinkedTransferQueue<ServiceHealthCheckIn>();
    private final BlockingQueue<EndpointDefinition> registerQueue = new LinkedTransferQueue<EndpointDefinition>();
    private final ServiceChangedEventChannel serviceChangedEventChannel;
    private final ServicePoolListener servicePoolListener;
    private final ExecutorService executorService;
    private final ConcurrentHashMap<String, ServicePool> servicePoolMap = new ConcurrentHashMap();
    private final ConcurrentHashSet<EndpointDefinition> endpointDefinitions = new ConcurrentHashSet();
    private final ServiceDiscoveryProvider provider;
    private final Logger logger = LoggerFactory.getLogger(ServiceDiscoveryImpl.class);
    private final boolean debug = GlobalConstants.DEBUG || this.logger.isDebugEnabled();
    private final boolean trace = this.logger.isTraceEnabled();
    private final int pollForServicesIntervalMS;
    private final int checkInIntervalInMS;
    private final ServiceDiscoveryProvider backupProvider;
    private final ConcurrentHashSet<String> serviceNamesBeingLoaded = new ConcurrentHashSet();
    private final AtomicBoolean stop = new AtomicBoolean();
    private final Set<String> serviceNames = new TreeSet<String>();
    private long lastCheckIn;

    public ServiceDiscoveryImpl(PeriodicScheduler periodicScheduler, ServiceChangedEventChannel serviceChangedEventChannel, ServiceDiscoveryProvider provider, ServiceDiscoveryProvider backupProvider, ServicePoolListener servicePoolListener, ExecutorService executorService, int pollForServicesIntervalSeconds, int checkInIntervalInSeconds) {
        this.backupProvider = backupProvider;
        this.checkInIntervalInMS = checkInIntervalInSeconds * 1000;
        this.provider = provider;
        this.pollForServicesIntervalMS = pollForServicesIntervalSeconds * 1000;
        this.periodicScheduler = periodicScheduler == null ? QBit.factory().periodicScheduler() : periodicScheduler;
        this.serviceChangedEventChannel = serviceChangedEventChannel == null ? serviceName -> {} : serviceChangedEventChannel;
        this.servicePoolListener = servicePoolListener == null ? serviceName -> {} : servicePoolListener;
        ExecutorService executorService2 = this.executorService = executorService == null ? Executors.newCachedThreadPool(runnable -> new Thread(runnable, "ServiceDiscovery")) : executorService;
        if (this.trace) {
            this.logger.trace("ServiceDiscoveryImpl created" + provider);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (!this.stop.get()) {
                this.stop();
            }
        }));
    }

    @Override
    public EndpointDefinition registerWithTTL(String serviceName, int port, int timeToLiveSeconds) {
        if (this.trace) {
            this.logger.trace("ServiceDiscoveryImpl::registerWithTTL() " + serviceName + " " + port);
        }
        this.watch(serviceName);
        EndpointDefinition endpointDefinition = new EndpointDefinition(HealthStatus.PASS, serviceName + "-" + ServiceDiscovery.uniqueString(port), serviceName, null, port, timeToLiveSeconds);
        return this.doRegister(endpointDefinition);
    }

    @Override
    public EndpointDefinition registerWithIdAndTimeToLive(String serviceName, String serviceId, int port, int timeToLiveSeconds) {
        if (this.trace) {
            this.logger.trace("ServiceDiscoveryImpl::registerWithIdAndTimeToLive() " + serviceName + " " + port);
        }
        this.watch(serviceName);
        EndpointDefinition endpointDefinition = new EndpointDefinition(HealthStatus.PASS, serviceId, serviceName, null, port, timeToLiveSeconds);
        return this.doRegister(endpointDefinition);
    }

    private EndpointDefinition doRegister(EndpointDefinition endpointDefinition) {
        this.endpointDefinitions.add(endpointDefinition);
        this.registerQueue.offer(endpointDefinition);
        return endpointDefinition;
    }

    @Override
    public EndpointDefinition register(String serviceName, int port) {
        if (this.trace) {
            this.logger.trace("ServiceDiscoveryImpl::register()" + serviceName + " " + port);
        }
        this.watch(serviceName);
        EndpointDefinition endpointDefinition = new EndpointDefinition(HealthStatus.PASS, serviceName + "-" + ServiceDiscovery.uniqueString(port), serviceName, null, port);
        return this.doRegister(endpointDefinition);
    }

    @Override
    public EndpointDefinition registerWithId(String serviceName, String serviceId, int port) {
        if (this.trace) {
            this.logger.trace("ServiceDiscoveryImpl::registerWithId()" + serviceName + " " + port);
        }
        this.watch(serviceName);
        EndpointDefinition endpointDefinition = new EndpointDefinition(HealthStatus.PASS, serviceId, serviceName, null, port);
        return this.doRegister(endpointDefinition);
    }

    @Override
    public void watch(String serviceName) {
        if (this.trace) {
            this.logger.trace("ServiceDiscoveryImpl::watch()" + serviceName);
        }
        if (!this.serviceNames.contains(serviceName)) {
            this.serviceNames.add(serviceName);
            this.doneQueue.offer(serviceName);
        }
    }

    @Override
    public void checkIn(String serviceId, HealthStatus healthStatus) {
        if (this.trace) {
            this.logger.trace("ServiceDiscoveryImpl::checkIn()" + serviceId, (Object)healthStatus);
        }
        this.checkInsQueue.offer(new ServiceHealthCheckIn(serviceId, healthStatus));
    }

    @Override
    public void checkInOk(String serviceId) {
        if (this.trace) {
            this.logger.trace("ServiceDiscoveryImpl::checkInOk()" + serviceId);
        }
        this.checkInsQueue.offer(new ServiceHealthCheckIn(serviceId, HealthStatus.PASS));
    }

    public ServicePool servicePool(String serviceName) {
        ServicePool servicePool = this.servicePoolMap.get(serviceName);
        if (servicePool == null) {
            servicePool = new ServicePool(serviceName, this.servicePoolListener);
            this.servicePoolMap.put(serviceName, servicePool);
        }
        return servicePool;
    }

    @Override
    public List<EndpointDefinition> loadServices(String serviceName) {
        ServicePool servicePool;
        if (this.trace) {
            this.logger.trace("ServiceDiscoveryImpl::loadServices()" + serviceName);
        }
        if ((servicePool = this.servicePoolMap.get(serviceName)) == null) {
            servicePool = new ServicePool(serviceName, this.servicePoolListener);
            this.servicePoolMap.put(serviceName, servicePool);
            this.watch(serviceName);
            return Collections.emptyList();
        }
        return servicePool.services();
    }

    @Override
    public List<EndpointDefinition> loadServicesNow(String serviceName) {
        ServicePool servicePool;
        if (this.trace) {
            this.logger.trace("ServiceDiscoveryImpl::loadServices()" + serviceName);
        }
        if ((servicePool = this.servicePoolMap.get(serviceName)) == null) {
            servicePool = new ServicePool(serviceName, this.servicePoolListener);
            this.servicePoolMap.put(serviceName, servicePool);
            try {
                List<EndpointDefinition> healthyServices = this.provider.loadServices(serviceName);
                servicePool.setHealthyNodes(healthyServices, this.servicePoolListener);
            }
            catch (Exception ex) {
                this.logger.warn("Unable to load healthy nodes from primary service discovery provider", (Throwable)ex);
                List<EndpointDefinition> healthyServices = this.backupProvider.loadServices(serviceName);
                servicePool.setHealthyNodes(healthyServices, this.servicePoolListener);
            }
            this.watch(serviceName);
        }
        return servicePool.services();
    }

    @Override
    public void start() {
        if (this.debug) {
            this.logger.debug("Starting Service Discovery " + this.provider);
        }
        this.periodicScheduler.repeat(() -> {
            try {
                this.logger.info("Starting Consul monitor");
                this.monitor();
            }
            catch (Exception e) {
                this.logger.error("ServiceDiscoveryImpl::Error while running monitor", (Throwable)e);
            }
        }, this.pollForServicesIntervalMS, TimeUnit.MILLISECONDS);
    }

    public void monitor() throws Exception {
        while (!this.stop.get()) {
            long now;
            long duration;
            if (this.registerQueue.size() > 0) {
                this.provider.registerServices(this.registerQueue);
            }
            if (this.doneQueue.size() > 0) {
                this.executorService.submit(() -> this.loadHealthyServices());
            }
            if (this.checkInsQueue.size() > 0) {
                this.provider.checkIn(this.checkInsQueue);
            }
            if (this.registerQueue.size() == 0) {
                Sys.sleep((long)this.pollForServicesIntervalMS);
            }
            if (this.doneQueue.size() != 0 || (duration = (now = Timer.timer().now()) - this.lastCheckIn) <= (long)this.checkInIntervalInMS) continue;
            this.lastCheckIn = now;
            this.doneQueue.addAll(this.serviceNames);
        }
    }

    private void loadHealthyServices() {
        try {
            String serviceName = (String)this.doneQueue.poll();
            while (serviceName != null) {
                String serviceNameToFetch = serviceName;
                if (!this.serviceNamesBeingLoaded.contains(serviceNameToFetch)) {
                    this.serviceNamesBeingLoaded.add(serviceNameToFetch);
                    this.executorService.submit(() -> this.doLoadHealthServices(serviceNameToFetch));
                }
                serviceName = (String)this.doneQueue.poll();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void doLoadHealthServices(String serviceNameToFetch) {
        try {
            List<EndpointDefinition> healthyServices = this.provider.loadServices(serviceNameToFetch);
            this.populateServiceMap(serviceNameToFetch, healthyServices);
        }
        catch (Exception ex) {
            this.doFailOverHealthServicesLoad(serviceNameToFetch, ex);
        }
        finally {
            this.serviceNamesBeingLoaded.remove(serviceNameToFetch);
        }
    }

    private void doFailOverHealthServicesLoad(String serviceNameToFetch, Exception ex) {
        if (this.backupProvider != null) {
            if (this.debug) {
                this.logger.debug("ServiceDiscoveryImpl::loadHealthyServices Error while loading healthy services for " + serviceNameToFetch, (Throwable)ex);
            }
            List<EndpointDefinition> healthyServices = this.backupProvider.loadServices(serviceNameToFetch);
            this.populateServiceMap(serviceNameToFetch, healthyServices);
            this.serviceNamesBeingLoaded.remove(serviceNameToFetch);
        } else {
            this.logger.error("ServiceDiscoveryImpl::loadHealthyServices Error while loading healthy services for " + serviceNameToFetch, (Throwable)ex);
        }
        Sys.sleep((long)10000L);
    }

    private void populateServiceMap(String serviceName, List<EndpointDefinition> healthyServices) {
        ServicePool servicePool = this.servicePool(serviceName);
        if (servicePool.setHealthyNodes(healthyServices)) {
            this.serviceChangedEventChannel.servicePoolChanged(serviceName);
            this.serviceChangedEventChannel.flushEvents();
        }
    }

    @Override
    public void stop() {
        if (this.debug) {
            this.logger.debug("Stopping Service Discovery");
        }
        this.provider.unregisterServices(this.endpointDefinitions);
        this.periodicScheduler.stop();
        this.stop.set(true);
    }

    @Override
    public Set<EndpointDefinition> localDefinitions() {
        return this.endpointDefinitions;
    }
}

