/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.service.dispatchers;

import io.advantageous.qbit.service.ServiceBuilder;
import io.advantageous.qbit.service.ServiceQueue;
import io.advantageous.qbit.service.dispatchers.ServiceMethodDispatcher;
import io.advantageous.qbit.service.dispatchers.ServiceWorkers;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class RoundRobinServiceWorkerBuilder {
    private ServiceBuilder serviceBuilder;
    private ServiceWorkers serviceDispatcher;
    private int workerCount = -1;
    private int flushInterval = -1;
    private TimeUnit timeUnit = TimeUnit.MILLISECONDS;
    private Supplier<Object> serviceObjectSupplier;

    public static RoundRobinServiceWorkerBuilder roundRobinServiceWorkerBuilder() {
        return new RoundRobinServiceWorkerBuilder();
    }

    public Supplier<Object> getServiceObjectSupplier() {
        return this.serviceObjectSupplier;
    }

    public RoundRobinServiceWorkerBuilder setServiceObjectSupplier(Supplier<Object> serviceObjectSupplier) {
        this.serviceObjectSupplier = serviceObjectSupplier;
        return this;
    }

    public int getWorkerCount() {
        if (this.workerCount == -1) {
            this.workerCount = Runtime.getRuntime().availableProcessors();
        }
        return this.workerCount;
    }

    public RoundRobinServiceWorkerBuilder setWorkerCount(int workerCount) {
        this.workerCount = workerCount;
        return this;
    }

    public ServiceBuilder getServiceBuilder() {
        if (this.serviceBuilder == null) {
            this.serviceBuilder = ServiceBuilder.serviceBuilder();
        }
        return this.serviceBuilder;
    }

    public RoundRobinServiceWorkerBuilder setServiceBuilder(ServiceBuilder serviceBuilder) {
        this.serviceBuilder = serviceBuilder;
        return this;
    }

    public ServiceWorkers getServiceDispatcher() {
        if (this.serviceDispatcher == null) {
            this.serviceDispatcher = this.flushInterval == -1 ? ServiceWorkers.workers() : ServiceWorkers.workers(this.flushInterval, this.timeUnit);
        }
        return this.serviceDispatcher;
    }

    public RoundRobinServiceWorkerBuilder setServiceDispatcher(ServiceWorkers serviceDispatcher) {
        this.serviceDispatcher = serviceDispatcher;
        return this;
    }

    public int getFlushInterval() {
        return this.flushInterval;
    }

    public RoundRobinServiceWorkerBuilder setFlushInterval(int flushInterval) {
        this.flushInterval = flushInterval;
        return this;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public RoundRobinServiceWorkerBuilder setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
        return this;
    }

    public ServiceMethodDispatcher build() {
        if (this.getServiceObjectSupplier() == null) {
            throw new IllegalStateException("serviceObjectSupplier must be set");
        }
        ServiceBuilder serviceBuilder = this.getServiceBuilder();
        for (int index = 0; index < this.getWorkerCount(); ++index) {
            ServiceQueue serviceQueue = serviceBuilder.setServiceObject(this.getServiceObjectSupplier().get()).build();
            this.getServiceDispatcher().addServices(serviceQueue);
        }
        return this.getServiceDispatcher();
    }
}

