/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.service.dispatchers;

import io.advantageous.boon.core.reflection.BeanUtils;
import io.advantageous.qbit.message.MethodCall;
import io.advantageous.qbit.queue.SendQueue;
import io.advantageous.qbit.service.ServiceQueue;
import io.advantageous.qbit.service.Startable;
import io.advantageous.qbit.service.Stoppable;
import io.advantageous.qbit.service.dispatchers.RoundRobinServiceDispatcher;
import io.advantageous.qbit.service.dispatchers.ServiceMethodDispatcher;
import io.advantageous.qbit.service.dispatchers.ShardRule;
import io.advantageous.qbit.service.dispatchers.ShardedMethodDispatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ServiceWorkers
implements ServiceMethodDispatcher {
    protected final boolean startServices;
    private final int flushInterval;
    private final TimeUnit timeUnit;
    protected List<ServiceQueue> serviceQueues = new ArrayList<ServiceQueue>();
    protected final List<SendQueue<MethodCall<Object>>> sendQueues = new ArrayList<SendQueue<MethodCall<Object>>>();
    protected final AtomicInteger index = new AtomicInteger();

    public ServiceWorkers(boolean startServices) {
        this.startServices = startServices;
        this.flushInterval = 50;
        this.timeUnit = TimeUnit.MILLISECONDS;
    }

    public ServiceWorkers(int flushInterval, TimeUnit timeUnit) {
        this.startServices = true;
        this.flushInterval = flushInterval;
        this.timeUnit = timeUnit;
    }

    public ServiceWorkers() {
        this.startServices = true;
        this.flushInterval = 50;
        this.timeUnit = TimeUnit.MILLISECONDS;
    }

    public static RoundRobinServiceDispatcher workers(int flushInterval, TimeUnit timeUnit) {
        return new RoundRobinServiceDispatcher(flushInterval, timeUnit);
    }

    public static RoundRobinServiceDispatcher workers() {
        return new RoundRobinServiceDispatcher();
    }

    public static ShardedMethodDispatcher shardedWorkers(ShardRule shardRule) {
        return new ShardedMethodDispatcher(shardRule);
    }

    public static ShardedMethodDispatcher shardedWorkers(int flushInterval, TimeUnit timeUnit, ShardRule shardRule) {
        return new ShardedMethodDispatcher(flushInterval, timeUnit, shardRule);
    }

    public static ShardedMethodDispatcher shardOnFirstArgumentWorkers() {
        return new ShardedMethodDispatcher((methodName, methodArgs, numWorkers) -> {
            int shardKey = methodArgs[0].hashCode() % numWorkers;
            return shardKey;
        });
    }

    public static ShardedMethodDispatcher shardOnSecondArgumentWorkers() {
        return new ShardedMethodDispatcher((methodName, methodArgs, numWorkers) -> {
            int shardKey = methodArgs[1].hashCode() % numWorkers;
            return shardKey;
        });
    }

    public static ShardedMethodDispatcher shardOnThirdArgumentWorkers() {
        return new ShardedMethodDispatcher((methodName, methodArgs, numWorkers) -> {
            int shardKey = methodArgs[2].hashCode() % numWorkers;
            return shardKey;
        });
    }

    public static ShardedMethodDispatcher shardOnFourthArgumentWorkers() {
        return new ShardedMethodDispatcher((methodName, methodArgs, numWorkers) -> {
            int shardKey = methodArgs[3].hashCode() % numWorkers;
            return shardKey;
        });
    }

    public static ShardedMethodDispatcher shardOnFifthArgumentWorkers() {
        return new ShardedMethodDispatcher((methodName, methodArgs, numWorkers) -> {
            int shardKey = methodArgs[4].hashCode() % numWorkers;
            return shardKey;
        });
    }

    public static ShardedMethodDispatcher shardOnBeanPath(String beanPath) {
        return new ShardedMethodDispatcher((methodName, methodArgs, numWorkers) -> {
            int shardKey = BeanUtils.idx((Object)methodArgs, (String)beanPath).hashCode() % numWorkers;
            return shardKey;
        });
    }

    public ServiceWorkers addService(ServiceQueue serviceQueue) {
        this.serviceQueues.add(serviceQueue);
        return this;
    }

    public ServiceWorkers addServices(ServiceQueue ... servicesArray) {
        for (ServiceQueue serviceQueue : servicesArray) {
            this.addService(serviceQueue);
        }
        return this;
    }

    @Override
    public void start() {
        this.startServiceWorkers();
    }

    public ServiceWorkers startServiceWorkers() {
        this.serviceQueues = Collections.unmodifiableList(this.serviceQueues);
        if (this.startServices) {
            this.serviceQueues.forEach(Startable::start);
            this.serviceQueues.forEach(ServiceQueue::startCallBackHandler);
        }
        for (ServiceQueue serviceQueue : this.serviceQueues) {
            if (this.flushInterval > 0) {
                SendQueue<MethodCall<Object>> methodCallSendQueue = serviceQueue.requestsWithAutoFlush(this.flushInterval, this.timeUnit);
                methodCallSendQueue.start();
                this.sendQueues.add(methodCallSendQueue);
                continue;
            }
            this.sendQueues.add(serviceQueue.requests());
        }
        return this;
    }

    @Override
    public void accept(MethodCall<Object> methodCall) {
        int localIndex = this.index.getAndIncrement() % this.serviceQueues.size();
        SendQueue<MethodCall<Object>> methodCallSendQueue = this.sendQueues.get(localIndex);
        methodCallSendQueue.send(methodCall);
    }

    @Override
    public void flush() {
        this.sendQueues.forEach(SendQueue::flushSends);
        this.serviceQueues.forEach(ServiceQueue::flush);
    }

    @Override
    public void stop() {
        this.sendQueues.forEach(Stoppable::stop);
        this.serviceQueues.forEach(ServiceQueue::stop);
    }
}

