/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.service.dispatchers;

import io.advantageous.qbit.message.MethodCall;
import io.advantageous.qbit.queue.SendQueue;
import io.advantageous.qbit.service.dispatchers.ServiceWorkers;
import io.advantageous.qbit.service.dispatchers.ShardRule;
import java.util.concurrent.TimeUnit;

public class ShardedMethodDispatcher
extends ServiceWorkers {
    private final ShardRule shardRule;

    public ShardedMethodDispatcher(ShardRule shardRule) {
        this.shardRule = shardRule;
    }

    public ShardedMethodDispatcher(int flushInterval, TimeUnit timeUnit, ShardRule shardRule) {
        super(flushInterval, timeUnit);
        this.shardRule = shardRule;
    }

    @Override
    public void accept(MethodCall<Object> methodCall) {
        Object[] args = methodCall.args();
        int shard = this.shardRule.shard(methodCall.name(), args, this.serviceQueues.size());
        int index = shard >= 0 ? shard : shard * -1;
        SendQueue methodCallSendQueue = (SendQueue)this.sendQueues.get(index);
        methodCallSendQueue.send(methodCall);
    }
}

