/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.service.dispatchers;

import io.advantageous.qbit.service.ServiceBuilder;
import io.advantageous.qbit.service.ServiceQueue;
import io.advantageous.qbit.service.dispatchers.ServiceMethodDispatcher;
import io.advantageous.qbit.service.dispatchers.ServiceWorkers;
import io.advantageous.qbit.service.dispatchers.ShardRule;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class ShardedServiceWorkerBuilder {
    private ShardRule shardRule;
    private ServiceBuilder serviceBuilder;
    private ServiceWorkers serviceDispatcher;
    private int workerCount = -1;
    private int flushInterval = -1;
    private TimeUnit timeUnit = TimeUnit.MILLISECONDS;
    private Supplier<Object> serviceObjectSupplier;

    public static ShardedServiceWorkerBuilder shardedServiceWorkerBuilder() {
        return new ShardedServiceWorkerBuilder();
    }

    public Supplier<Object> getServiceObjectSupplier() {
        return this.serviceObjectSupplier;
    }

    public ShardedServiceWorkerBuilder setServiceObjectSupplier(Supplier<Object> serviceObjectSupplier) {
        this.serviceObjectSupplier = serviceObjectSupplier;
        return this;
    }

    public int getWorkerCount() {
        if (this.workerCount == -1) {
            this.workerCount = Runtime.getRuntime().availableProcessors();
        }
        return this.workerCount;
    }

    public ShardedServiceWorkerBuilder setWorkerCount(int workerCount) {
        this.workerCount = workerCount;
        return this;
    }

    public ShardRule getShardRule() {
        if (this.shardRule == null) {
            int workerCount = this.getWorkerCount();
            this.shardRule = (methodName, methodArgs, numWorkers) -> methodArgs[0].hashCode() % workerCount;
        }
        return this.shardRule;
    }

    public ShardedServiceWorkerBuilder setShardRule(ShardRule shardRule) {
        this.shardRule = shardRule;
        return this;
    }

    public ServiceBuilder getServiceBuilder() {
        if (this.serviceBuilder == null) {
            this.serviceBuilder = ServiceBuilder.serviceBuilder();
        }
        return this.serviceBuilder;
    }

    public ShardedServiceWorkerBuilder setServiceBuilder(ServiceBuilder serviceBuilder) {
        this.serviceBuilder = serviceBuilder;
        return this;
    }

    public ServiceWorkers getServiceDispatcher() {
        if (this.serviceDispatcher == null) {
            this.serviceDispatcher = this.flushInterval == -1 ? ServiceWorkers.shardedWorkers(this.getShardRule()) : ServiceWorkers.shardedWorkers(this.getFlushInterval(), this.getTimeUnit(), this.getShardRule());
        }
        return this.serviceDispatcher;
    }

    public ShardedServiceWorkerBuilder setServiceDispatcher(ServiceWorkers serviceDispatcher) {
        this.serviceDispatcher = serviceDispatcher;
        return this;
    }

    public int getFlushInterval() {
        return this.flushInterval;
    }

    public ShardedServiceWorkerBuilder setFlushInterval(int flushInterval) {
        this.flushInterval = flushInterval;
        return this;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public ShardedServiceWorkerBuilder setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
        return this;
    }

    public ServiceMethodDispatcher build() {
        if (this.getServiceObjectSupplier() == null) {
            throw new IllegalStateException("serviceObjectSupplier must be set");
        }
        ServiceBuilder serviceBuilder = this.getServiceBuilder();
        for (int index = 0; index < this.getWorkerCount(); ++index) {
            ServiceQueue serviceQueue = serviceBuilder.setServiceObject(this.getServiceObjectSupplier().get()).build();
            this.getServiceDispatcher().addServices(serviceQueue);
        }
        return this.getServiceDispatcher();
    }
}

