/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.service.health;

import io.advantageous.qbit.config.PropertyResolver;
import io.advantageous.qbit.service.ServiceBuilder;
import io.advantageous.qbit.service.ServiceQueue;
import io.advantageous.qbit.service.health.HealthService;
import io.advantageous.qbit.service.health.HealthServiceAsync;
import io.advantageous.qbit.service.health.HealthServiceImpl;
import io.advantageous.qbit.util.Timer;
import java.util.Properties;
import java.util.concurrent.TimeUnit;

public class HealthServiceBuilder {
    public static final String CONTEXT = "qbit.service.health.";
    private HealthServiceAsync proxy;
    private HealthService implementation;
    private ServiceBuilder serviceBuilder;
    private ServiceQueue serviceQueue;
    private Timer timer;
    private long recheckInterval = 10L;
    private TimeUnit timeUnit;
    private boolean autoFlush;

    public HealthServiceBuilder(PropertyResolver propertyResolver) {
        this.recheckInterval = propertyResolver.getLongProperty("recheckIntervalSeconds", this.recheckInterval);
        this.timeUnit = TimeUnit.SECONDS;
    }

    public HealthServiceBuilder() {
        this(PropertyResolver.createSystemPropertyResolver(CONTEXT));
    }

    public HealthServiceBuilder(Properties properties) {
        this(PropertyResolver.createPropertiesPropertyResolver(CONTEXT, properties));
    }

    public static HealthServiceBuilder healthServiceBuilder() {
        return new HealthServiceBuilder();
    }

    public long getRecheckInterval() {
        return this.recheckInterval;
    }

    public HealthServiceBuilder setRecheckInterval(long recheckInterval) {
        this.recheckInterval = recheckInterval;
        return this;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public HealthServiceBuilder setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
        return this;
    }

    public Timer getTimer() {
        if (this.timer == null) {
            this.timer = Timer.timer();
        }
        return this.timer;
    }

    public HealthServiceBuilder setTimer(Timer timer) {
        this.timer = timer;
        return this;
    }

    public ServiceQueue getServiceQueue() {
        if (this.serviceQueue == null) {
            this.serviceQueue = this.getServiceBuilder().setServiceObject(this.getImplementation()).build();
        }
        return this.serviceQueue;
    }

    public HealthServiceBuilder setServiceQueue(ServiceQueue serviceQueue) {
        this.serviceQueue = serviceQueue;
        return this;
    }

    public HealthServiceAsync getProxy() {
        if (this.proxy == null) {
            this.proxy = this.autoFlush ? this.getServiceQueue().createProxyWithAutoFlush(HealthServiceAsync.class, 50, TimeUnit.MILLISECONDS) : this.getServiceQueue().createProxy(HealthServiceAsync.class);
        }
        return this.proxy;
    }

    public HealthServiceBuilder setProxy(HealthServiceAsync proxy) {
        this.proxy = proxy;
        return this;
    }

    public HealthService getImplementation() {
        if (this.implementation == null) {
            this.implementation = new HealthServiceImpl(this.getTimer(), this.getRecheckInterval(), this.getTimeUnit());
        }
        return this.implementation;
    }

    public HealthServiceBuilder setImplementation(HealthService implementation) {
        this.implementation = implementation;
        return this;
    }

    public ServiceBuilder getServiceBuilder() {
        if (this.serviceBuilder == null) {
            this.serviceBuilder = ServiceBuilder.serviceBuilder();
        }
        return this.serviceBuilder;
    }

    public HealthServiceBuilder setServiceBuilder(ServiceBuilder serviceBuilder) {
        this.serviceBuilder = serviceBuilder;
        return this;
    }

    public HealthServiceAsync build() {
        return this.getProxy();
    }

    public HealthServiceAsync buildAndStart() {
        HealthServiceAsync proxy = this.getProxy();
        this.getServiceQueue().start();
        this.getServiceQueue().startCallBackHandler();
        return proxy;
    }

    public HealthServiceBuilder setAutoFlush() {
        this.autoFlush = true;
        return this;
    }

    public HealthServiceAsync buildHealthSystemReporterWithAutoFlush() {
        return this.getServiceQueue().createProxyWithAutoFlush(HealthServiceAsync.class, 1, TimeUnit.SECONDS);
    }

    public HealthServiceAsync buildHealthSystemReporter() {
        return this.getServiceQueue().createProxy(HealthServiceAsync.class);
    }
}

