/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.service.health;

import io.advantageous.boon.core.Lists;
import io.advantageous.qbit.annotation.QueueCallback;
import io.advantageous.qbit.annotation.QueueCallbackType;
import io.advantageous.qbit.service.Stoppable;
import io.advantageous.qbit.service.health.HealthService;
import io.advantageous.qbit.service.health.HealthStatus;
import io.advantageous.qbit.service.health.NodeHealthStat;
import io.advantageous.qbit.util.Timer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthServiceImpl
implements HealthService,
Stoppable {
    private final Timer timer;
    private final long recheckIntervalMS;
    private final Map<String, NodeHealthStat> serviceHealthStatMap = new ConcurrentHashMap<String, NodeHealthStat>();
    private long lastCheckIn;
    private long now;
    private final Logger logger = LoggerFactory.getLogger(HealthServiceImpl.class);
    private final boolean debug = this.logger.isDebugEnabled();
    private static int healthServiceCount;

    public HealthServiceImpl(Timer timer, long recheckInterval, TimeUnit timeUnit) {
        this.timer = timer;
        this.recheckIntervalMS = timeUnit.toMillis(recheckInterval);
        this.lastCheckIn = this.now = timer.now();
        ++healthServiceCount;
        if (this.logger.isDebugEnabled()) {
            Exception ex = new Exception();
            ex.fillInStackTrace();
            this.logger.debug("Health Service CREATED", (Throwable)ex);
        }
        if (healthServiceCount > 1) {
            this.logger.info("More than ONE Health Service created {}, if that is not intended turn on debugging", (Object)healthServiceCount);
        }
        this.logger.info("Health Service CREATED {}", (Object)this.hashCode());
    }

    @Override
    public void register(String name, long ttl, TimeUnit timeUnit) {
        this.logger.info("HealthService::register() {} {} {}", new Object[]{name, ttl, timeUnit});
        this.serviceHealthStatMap.put(name, new NodeHealthStat(name, timeUnit.toMillis(ttl)));
    }

    @Override
    public void checkInOk(String name) {
        if (this.debug) {
            this.logger.debug("HealthService::checkInOk() {} ", (Object)name);
        }
        NodeHealthStat nodeHealthStat = this.getServiceHealthStat(name);
        nodeHealthStat.setLastCheckIn(this.now);
        nodeHealthStat.setReason(null);
        nodeHealthStat.setStatus(HealthStatus.PASS);
    }

    @Override
    public void checkIn(String name, HealthStatus status) {
        if (status == HealthStatus.FAIL) {
            this.logger.error("HealthService::checkIn() {} {}", (Object)name, (Object)status);
        } else if (status == HealthStatus.WARN) {
            this.logger.warn("HealthService::checkIn() {} {}", (Object)name, (Object)status);
        } else if (this.debug) {
            this.logger.debug("HealthService::checkIn() {} {}", (Object)name, (Object)status);
        }
        NodeHealthStat nodeHealthStat = this.getServiceHealthStat(name);
        nodeHealthStat.setStatus(status);
        nodeHealthStat.setReason(null);
        nodeHealthStat.setLastCheckIn(this.now);
    }

    @Override
    public boolean ok() {
        boolean ok;
        if (this.debug) {
            this.logger.debug("HealthService::ok()");
        }
        if (!(ok = this.serviceHealthStatMap.values().stream().allMatch(serviceHealthStat -> serviceHealthStat.getStatus() == HealthStatus.PASS))) {
            this.logger.error("HealthService::ok() was ok? {}", (Object)ok);
        } else if (this.debug) {
            this.logger.debug("HealthService::ok() was ok? {}", (Object)ok);
        }
        return ok;
    }

    @Override
    public List<String> findHealthyNodes() {
        this.logger.info("HealthService::findHealthyNodes() called");
        ArrayList<String> names = new ArrayList<String>();
        this.serviceHealthStatMap.values().stream().filter(serviceHealthStat -> serviceHealthStat.getStatus() == HealthStatus.PASS).forEach(serviceHealthStat -> names.add(serviceHealthStat.getName()));
        this.logger.info("HealthService::findHealthyNodes() called returns {}", names);
        return names;
    }

    @Override
    public List<String> findAllNodes() {
        this.logger.info("HealthService::findAllNodes() called");
        ArrayList<String> names = new ArrayList<String>();
        this.serviceHealthStatMap.values().stream().forEach(serviceHealthStat -> names.add(serviceHealthStat.getName()));
        this.logger.info("HealthService::findAllNodes() called returns {}", names);
        return names;
    }

    @Override
    public List<String> findAllNodesWithStatus(HealthStatus queryStatus) {
        ArrayList<String> names = new ArrayList<String>();
        this.serviceHealthStatMap.values().stream().filter(serviceHealthStat -> serviceHealthStat.getStatus() == queryStatus).forEach(serviceHealthStat -> names.add(serviceHealthStat.getName()));
        return names;
    }

    @Override
    public List<String> findNotHealthyNodes() {
        ArrayList<String> names = new ArrayList<String>();
        this.serviceHealthStatMap.values().stream().filter(serviceHealthStat -> serviceHealthStat.getStatus() != HealthStatus.PASS).forEach(serviceHealthStat -> names.add(serviceHealthStat.getName()));
        return names;
    }

    @Override
    public List<NodeHealthStat> loadNodes() {
        this.logger.info("HealthService::loadNodes() called");
        return Lists.deepCopy(this.serviceHealthStatMap.values());
    }

    @Override
    public void unregister(String nodeName) {
        this.serviceHealthStatMap.remove(nodeName);
    }

    @QueueCallback(value={QueueCallbackType.IDLE, QueueCallbackType.LIMIT})
    public void process() {
        this.now = this.timer.now();
        long duration = this.now - this.lastCheckIn;
        if (duration > this.recheckIntervalMS) {
            this.lastCheckIn = this.now;
            this.checkTTLs();
        }
    }

    private void checkTTLs() {
        Collection<NodeHealthStat> services = this.serviceHealthStatMap.values();
        services.forEach(serviceHealthStat -> this.checkTTL((NodeHealthStat)serviceHealthStat));
    }

    private void checkTTL(NodeHealthStat nodeHealthStat) {
        boolean proceed;
        if (this.debug) {
            this.logger.debug("HealthService::checkTTL() {}", (Object)nodeHealthStat.getName());
        }
        boolean bl = proceed = nodeHealthStat.getStatus() == HealthStatus.PASS;
        if (!proceed) {
            return;
        }
        long duration = this.now - nodeHealthStat.getLastCheckIn();
        if (duration > nodeHealthStat.getTtlInMS()) {
            this.logger.error("HealthService::checkTTL() {} FAILED TTL check, duration {}", (Object)nodeHealthStat.getName(), (Object)duration);
            nodeHealthStat.setReason(HealthFailReason.FAILED_TTL);
            nodeHealthStat.setStatus(HealthStatus.FAIL);
        }
    }

    private NodeHealthStat getServiceHealthStat(String name) {
        NodeHealthStat nodeHealthStat = this.serviceHealthStatMap.get(name);
        if (nodeHealthStat == null) {
            throw new IllegalStateException("Trying to manage a service that you have not registered");
        }
        return nodeHealthStat;
    }

    @Override
    public void stop() {
        this.logger.info("Health Service stopped");
    }

    public static enum HealthFailReason {
        FAILED_TTL,
        NONE,
        OTHER;

    }
}

