/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.service.health;

import io.advantageous.qbit.queue.QueueCallBackHandler;
import io.advantageous.qbit.service.ServiceContext;
import io.advantageous.qbit.service.ServiceQueue;
import io.advantageous.qbit.service.health.HealthServiceAsync;
import io.advantageous.qbit.service.health.HealthStatus;
import io.advantageous.qbit.util.Timer;
import java.util.concurrent.TimeUnit;

public class ServiceHealthListener
implements QueueCallBackHandler {
    private final String serviceName;
    private final HealthServiceAsync healthServiceAsync;
    private final long checkInIntervalMS;
    private final Timer timer;
    private final long ttlMS;
    private long now;
    private long lastCheckTime;

    public ServiceHealthListener(String serviceName, HealthServiceAsync healthServiceAsync, Timer timer, long checkInInterval, long ttL, TimeUnit timeUnit) {
        this.serviceName = serviceName;
        this.healthServiceAsync = healthServiceAsync;
        this.checkInIntervalMS = timeUnit.toMillis(checkInInterval);
        this.timer = timer;
        this.ttlMS = timeUnit.toMillis(ttL);
        this.lastCheckTime = this.now;
    }

    @Override
    public void queueLimit() {
        this.check();
    }

    @Override
    public void queueEmpty() {
        this.check();
    }

    private void check() {
        this.now = this.timer.now();
        long duration = this.now - this.lastCheckTime;
        if (duration > this.checkInIntervalMS) {
            this.lastCheckTime = this.now;
            ServiceQueue serviceQueue = ServiceContext.serviceContext().currentService();
            boolean failing = serviceQueue.failing();
            if (!failing) {
                this.healthServiceAsync.checkInOk(this.serviceName);
            } else {
                this.healthServiceAsync.checkIn(this.serviceName, HealthStatus.FAIL);
            }
            this.healthServiceAsync.clientProxyFlush();
        }
    }

    @Override
    public void queueInit() {
        this.healthServiceAsync.register(this.serviceName, this.ttlMS, TimeUnit.MILLISECONDS);
    }

    @Override
    public void queueIdle() {
        this.check();
    }

    @Override
    public void queueShutdown() {
        this.healthServiceAsync.unregister(this.serviceName);
    }
}

