/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.service.impl;

import io.advantageous.boon.core.reflection.BeanUtils;
import io.advantageous.qbit.Factory;
import io.advantageous.qbit.GlobalConstants;
import io.advantageous.qbit.QBit;
import io.advantageous.qbit.client.ClientProxy;
import io.advantageous.qbit.concurrent.PeriodicScheduler;
import io.advantageous.qbit.events.EventManager;
import io.advantageous.qbit.message.Event;
import io.advantageous.qbit.message.MethodCall;
import io.advantageous.qbit.message.MethodCallBuilder;
import io.advantageous.qbit.message.Request;
import io.advantageous.qbit.message.Response;
import io.advantageous.qbit.queue.Queue;
import io.advantageous.qbit.queue.QueueBuilder;
import io.advantageous.qbit.queue.QueueCallBackHandler;
import io.advantageous.qbit.queue.ReceiveQueue;
import io.advantageous.qbit.queue.ReceiveQueueListener;
import io.advantageous.qbit.queue.SendQueue;
import io.advantageous.qbit.reactive.Callback;
import io.advantageous.qbit.service.AfterMethodCall;
import io.advantageous.qbit.service.BeforeMethodCall;
import io.advantageous.qbit.service.ServiceContext;
import io.advantageous.qbit.service.ServiceMethodHandler;
import io.advantageous.qbit.service.ServiceProxyUtils;
import io.advantageous.qbit.service.ServiceQueue;
import io.advantageous.qbit.service.impl.CallbackManager;
import io.advantageous.qbit.service.impl.ServiceConstants;
import io.advantageous.qbit.service.impl.ServiceQueueImpl;
import io.advantageous.qbit.system.QBitSystemManager;
import io.advantageous.qbit.time.Duration;
import io.advantageous.qbit.transforms.NoOpResponseTransformer;
import io.advantageous.qbit.transforms.Transformer;
import io.advantageous.qbit.util.MultiMap;
import io.advantageous.qbit.util.Timer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseServiceQueueImpl
implements ServiceQueue {
    private static final ThreadLocal<ServiceQueue> serviceThreadLocal = new ThreadLocal();
    protected final QBitSystemManager systemManager;
    protected final Logger logger = LoggerFactory.getLogger(ServiceQueueImpl.class);
    protected final boolean debug = GlobalConstants.DEBUG && this.logger.isDebugEnabled();
    protected final Object service;
    protected final Queue<Response<Object>> responseQueue;
    protected final Queue<MethodCall<Object>> requestQueue;
    protected final Queue<Event<Object>> eventQueue;
    protected final QueueBuilder requestQueueBuilder;
    protected final QueueBuilder responseQueueBuilder;
    protected final boolean handleCallbacks;
    private final Factory factory;
    protected volatile long lastResponseFlushTime = Timer.timer().now();
    protected final ServiceMethodHandler serviceMethodHandler;
    protected final SendQueue<Response<Object>> responseSendQueue;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final BeforeMethodCall beforeMethodCall;
    private final BeforeMethodCall beforeMethodCallAfterTransform;
    private final AfterMethodCall afterMethodCall;
    private final AfterMethodCall afterMethodCallAfterTransform;
    private Transformer<Request, Object> requestObjectTransformer = ServiceConstants.NO_OP_ARG_TRANSFORM;
    private Transformer<Response<Object>, Response> responseObjectTransformer = new NoOpResponseTransformer();
    private final CallbackManager callbackManager;
    private final QueueCallBackHandler queueCallBackHandler;
    private AtomicBoolean failing = new AtomicBoolean();

    public BaseServiceQueueImpl(String rootAddress, String serviceAddress, Object service, QueueBuilder requestQueueBuilder, QueueBuilder responseQueueBuilder, ServiceMethodHandler serviceMethodHandler, Queue<Response<Object>> responseQueue, boolean async, boolean handleCallbacks, QBitSystemManager systemManager, BeforeMethodCall beforeMethodCall, BeforeMethodCall beforeMethodCallAfterTransform, AfterMethodCall afterMethodCall, AfterMethodCall afterMethodCallAfterTransform, QueueCallBackHandler queueCallBackHandler, CallbackManager callbackManager) {
        this.beforeMethodCall = beforeMethodCall;
        this.beforeMethodCallAfterTransform = beforeMethodCallAfterTransform;
        this.afterMethodCall = afterMethodCall;
        this.afterMethodCallAfterTransform = afterMethodCallAfterTransform;
        this.callbackManager = callbackManager;
        this.queueCallBackHandler = queueCallBackHandler == null ? new QueueCallBackHandler(){

            @Override
            public void queueLimit() {
            }

            @Override
            public void queueEmpty() {
            }
        } : queueCallBackHandler;
        this.requestQueueBuilder = requestQueueBuilder == null ? new QueueBuilder() : (QueueBuilder)BeanUtils.copy((Object)requestQueueBuilder);
        this.responseQueueBuilder = responseQueueBuilder == null ? new QueueBuilder() : (QueueBuilder)BeanUtils.copy((Object)responseQueueBuilder);
        if (responseQueue == null) {
            this.logger.info("RESPONSE QUEUE WAS NULL CREATING ONE for service");
            this.responseQueue = this.responseQueueBuilder.setName("Response Queue  " + serviceMethodHandler.address()).build();
        } else {
            this.responseQueue = responseQueue;
        }
        this.responseSendQueue = this.responseQueue.sendQueueWithAutoFlush(100, TimeUnit.MILLISECONDS);
        this.service = service;
        this.serviceMethodHandler = serviceMethodHandler;
        this.serviceMethodHandler.init(service, rootAddress, serviceAddress, this.responseSendQueue);
        this.eventQueue = this.requestQueueBuilder.setName("Event Queue" + serviceMethodHandler.address()).build();
        this.handleCallbacks = handleCallbacks;
        this.requestQueue = this.initRequestQueue(serviceMethodHandler, async);
        this.systemManager = systemManager;
        this.factory = QBit.factory();
    }

    public static ServiceQueue currentService() {
        return serviceThreadLocal.get();
    }

    @Override
    public void start() {
        this.start(this.serviceMethodHandler, true);
    }

    @Override
    public ServiceQueue startServiceQueue() {
        this.start(this.serviceMethodHandler, true);
        return this;
    }

    @Override
    public ServiceQueue start(boolean joinEventManager) {
        this.start(this.serviceMethodHandler, joinEventManager);
        return this;
    }

    @Override
    public Queue<MethodCall<Object>> requestQueue() {
        return this.requestQueue;
    }

    @Override
    public Queue<Response<Object>> responseQueue() {
        return this.responseQueue;
    }

    protected Queue<MethodCall<Object>> initRequestQueue(final ServiceMethodHandler serviceMethodHandler, boolean async) {
        Queue<MethodCall<Object>> requestQueue = async ? this.requestQueueBuilder.setName("Send Queue  " + serviceMethodHandler.address()).build() : new Queue<MethodCall<Object>>(){

            @Override
            public ReceiveQueue<MethodCall<Object>> receiveQueue() {
                return null;
            }

            @Override
            public SendQueue<MethodCall<Object>> sendQueue() {
                return new SendQueue<MethodCall<Object>>(){

                    @Override
                    public boolean send(MethodCall<Object> item) {
                        return BaseServiceQueueImpl.this.doHandleMethodCall(item, serviceMethodHandler);
                    }

                    @Override
                    public void sendAndFlush(MethodCall<Object> item) {
                        BaseServiceQueueImpl.this.doHandleMethodCall(item, serviceMethodHandler);
                    }

                    @SafeVarargs
                    public final void sendMany(MethodCall<Object> ... items) {
                        for (MethodCall<Object> item : items) {
                            BaseServiceQueueImpl.this.doHandleMethodCall(item, serviceMethodHandler);
                        }
                    }

                    @Override
                    public void sendBatch(Collection<MethodCall<Object>> items) {
                        for (MethodCall<Object> item : items) {
                            BaseServiceQueueImpl.this.doHandleMethodCall(item, serviceMethodHandler);
                        }
                    }

                    @Override
                    public void sendBatch(Iterable<MethodCall<Object>> items) {
                        for (MethodCall<Object> item : items) {
                            BaseServiceQueueImpl.this.doHandleMethodCall(item, serviceMethodHandler);
                        }
                    }

                    @Override
                    public boolean shouldBatch() {
                        return false;
                    }

                    @Override
                    public void flushSends() {
                    }

                    @Override
                    public int size() {
                        return 0;
                    }
                };
            }

            @Override
            public void startListener(ReceiveQueueListener<MethodCall<Object>> listener) {
            }

            @Override
            public void stop() {
            }

            @Override
            public int size() {
                return 0;
            }
        };
        return requestQueue;
    }

    @Override
    public ServiceQueue startCallBackHandler() {
        if (!this.handleCallbacks) {
            this.callbackManager.startReturnHandlerProcessor(this.responseQueue);
            return this;
        }
        throw new IllegalStateException("Unable to handle callbacks in a new thread when handleCallbacks is set");
    }

    public BaseServiceQueueImpl requestObjectTransformer(Transformer<Request, Object> requestObjectTransformer) {
        this.requestObjectTransformer = requestObjectTransformer;
        return this;
    }

    public BaseServiceQueueImpl responseObjectTransformer(Transformer<Response<Object>, Response> responseObjectTransformer) {
        this.responseObjectTransformer = responseObjectTransformer;
        return this;
    }

    private boolean doHandleMethodCall(MethodCall<Object> methodCall, ServiceMethodHandler serviceMethodHandler) {
        if (this.debug) {
            this.logger.debug("ServiceImpl::doHandleMethodCall() METHOD CALL" + methodCall);
        }
        if (this.callbackManager != null) {
            this.callbackManager.registerCallbacks(methodCall);
        }
        boolean[] continueFlag = new boolean[1];
        methodCall = this.beforeMethodProcessing(methodCall, continueFlag);
        if (continueFlag[0]) {
            if (this.debug) {
                this.logger.debug("ServiceImpl::doHandleMethodCall() before handling stopped processing");
            }
            return false;
        }
        Response response = serviceMethodHandler.receiveMethodCall(methodCall);
        if (response != ServiceConstants.VOID) {
            if (!this.afterMethodCall.after(methodCall, response)) {
                return false;
            }
            if (!this.afterMethodCallAfterTransform.after(methodCall, response = this.responseObjectTransformer.transform(response))) {
                return false;
            }
            if (!this.responseSendQueue.send(response)) {
                this.logger.error("Unable to send response {} for method {} for object {}", new Object[]{response, methodCall.name(), methodCall.objectName()});
            }
        }
        return false;
    }

    private void start(final ServiceMethodHandler serviceMethodHandler, boolean joinEventManager) {
        ReceiveQueue<Response<Object>> responseReceiveQueue;
        if (this.started.get()) {
            this.logger.warn("Service {} already started. It will not start twice.", (Object)this.name());
            return;
        }
        this.logger.info("Starting service {}", (Object)this.name());
        this.started.set(true);
        ReceiveQueue<Response<Object>> receiveQueue = responseReceiveQueue = this.handleCallbacks ? this.responseQueue.receiveQueue() : null;
        if (this.handleCallbacks) {
            // empty if block
        }
        final ReceiveQueue<Event<Object>> eventReceiveQueue = this.eventQueue.receiveQueue();
        serviceThreadLocal.set(this);
        if (!(this.service instanceof EventManager) && joinEventManager) {
            ServiceContext.serviceContext().joinEventManager();
        }
        serviceMethodHandler.queueInit();
        this.flushEventManagerCalls();
        serviceThreadLocal.set(null);
        this.requestQueue.startListener(new ReceiveQueueListener<MethodCall<Object>>(){

            @Override
            public void init() {
                serviceThreadLocal.set(BaseServiceQueueImpl.this);
                BaseServiceQueueImpl.this.queueCallBackHandler.queueInit();
                serviceMethodHandler.init();
            }

            @Override
            public void receive(MethodCall<Object> methodCall) {
                BaseServiceQueueImpl.this.queueCallBackHandler.beforeReceiveCalled();
                BaseServiceQueueImpl.this.doHandleMethodCall(methodCall, serviceMethodHandler);
                BaseServiceQueueImpl.this.queueCallBackHandler.afterReceiveCalled();
            }

            @Override
            public void empty() {
                serviceThreadLocal.set(BaseServiceQueueImpl.this);
                this.handle();
                serviceMethodHandler.empty();
                BaseServiceQueueImpl.this.queueCallBackHandler.queueEmpty();
            }

            @Override
            public void startBatch() {
                serviceThreadLocal.set(BaseServiceQueueImpl.this);
                serviceMethodHandler.startBatch();
                BaseServiceQueueImpl.this.queueCallBackHandler.queueStartBatch();
            }

            @Override
            public void limit() {
                serviceThreadLocal.set(BaseServiceQueueImpl.this);
                this.handle();
                serviceMethodHandler.limit();
                BaseServiceQueueImpl.this.queueCallBackHandler.queueLimit();
            }

            @Override
            public void shutdown() {
                serviceThreadLocal.set(BaseServiceQueueImpl.this);
                this.handle();
                serviceMethodHandler.shutdown();
                BaseServiceQueueImpl.this.queueCallBackHandler.queueShutdown();
                serviceThreadLocal.set(null);
            }

            @Override
            public void idle() {
                serviceThreadLocal.set(BaseServiceQueueImpl.this);
                this.handle();
                serviceMethodHandler.idle();
                BaseServiceQueueImpl.this.queueCallBackHandler.queueIdle();
                if (BaseServiceQueueImpl.this.callbackManager != null) {
                    BaseServiceQueueImpl.this.callbackManager.process(0L);
                }
                serviceThreadLocal.set(null);
            }

            public void handle() {
                BaseServiceQueueImpl.this.manageResponseQueue();
                BaseServiceQueueImpl.this.handleCallBacks(responseReceiveQueue);
                BaseServiceQueueImpl.this.handleEvents(eventReceiveQueue, serviceMethodHandler);
            }
        });
    }

    private void handleEvents(ReceiveQueue<Event<Object>> eventReceiveQueue, ServiceMethodHandler serviceMethodHandler) {
        Event<Object> event = eventReceiveQueue.poll();
        while (event != null) {
            serviceMethodHandler.handleEvent(event);
            event = eventReceiveQueue.poll();
        }
        this.flushEventManagerCalls();
    }

    private void handleCallBacks(ReceiveQueue<Response<Object>> responseReceiveQueue) {
        if (this.handleCallbacks) {
            Response<Object> response = responseReceiveQueue.poll();
            while (response != null) {
                this.callbackManager.handleResponse(response);
                response = responseReceiveQueue.poll();
            }
        }
    }

    private void flushEventManagerCalls() {
        EventManager eventManager = this.factory.eventManagerProxy();
        if (eventManager != null) {
            ServiceProxyUtils.flushServiceProxy(eventManager);
            this.factory.clearEventManagerProxy();
        }
    }

    private void manageResponseQueue() {
        long now = Timer.timer().now();
        if (now - this.lastResponseFlushTime > 50L) {
            this.lastResponseFlushTime = now;
            this.responseSendQueue.flushSends();
        }
    }

    private MethodCall<Object> beforeMethodProcessing(MethodCall<Object> methodCall, boolean[] continueFlag) {
        if (!this.beforeMethodCall.before(methodCall)) {
            continueFlag[0] = false;
        }
        if (this.requestObjectTransformer != null && this.requestObjectTransformer != ServiceConstants.NO_OP_ARG_TRANSFORM) {
            Object arg = this.requestObjectTransformer.transform(methodCall);
            methodCall = MethodCallBuilder.transformed(methodCall, arg);
        }
        if (this.beforeMethodCallAfterTransform != null && this.beforeMethodCallAfterTransform != ServiceConstants.NO_OP_BEFORE_METHOD_CALL && !this.beforeMethodCallAfterTransform.before(methodCall)) {
            continueFlag[0] = false;
        }
        return methodCall;
    }

    @Override
    public SendQueue<MethodCall<Object>> requests() {
        return this.requestQueue.sendQueue();
    }

    @Override
    public SendQueue<MethodCall<Object>> requestsWithAutoFlush(int flushInterval, TimeUnit timeUnit) {
        return this.requestQueue.sendQueueWithAutoFlush(flushInterval, timeUnit);
    }

    @Override
    public ReceiveQueue<Response<Object>> responses() {
        return this.responseQueue.receiveQueue();
    }

    @Override
    public String name() {
        return this.serviceMethodHandler.name();
    }

    @Override
    public String address() {
        return this.serviceMethodHandler.address();
    }

    @Override
    public void stop() {
        block8: {
            block7: {
                this.started.set(false);
                try {
                    if (this.requestQueue != null) {
                        this.requestQueue.stop();
                    }
                }
                catch (Exception ex) {
                    if (!this.debug) break block7;
                    this.logger.debug("Unable to stop request queue", (Throwable)ex);
                }
            }
            try {
                if (this.responseQueue != null) {
                    this.responseQueue.stop();
                }
            }
            catch (Exception ex) {
                if (!this.debug) break block8;
                this.logger.debug("Unable to stop response queues", (Throwable)ex);
            }
        }
        if (this.systemManager != null) {
            this.systemManager.serviceShutDown();
        }
    }

    @Override
    public Collection<String> addresses(String address) {
        return this.serviceMethodHandler.addresses();
    }

    @Override
    public void flush() {
        this.lastResponseFlushTime = 0L;
        this.manageResponseQueue();
    }

    @Override
    public boolean failing() {
        return this.failing.get();
    }

    @Override
    public void setFailing() {
        this.failing.set(true);
    }

    @Override
    public void recover() {
        this.failing.set(false);
    }

    @Override
    public Object service() {
        return this.service;
    }

    @Override
    public <T> T createProxyWithAutoFlush(Class<T> serviceInterface, int interval, TimeUnit timeUnit) {
        SendQueue<MethodCall<Object>> methodCallSendQueue = this.requestQueue.sendQueueWithAutoFlush(interval, timeUnit);
        methodCallSendQueue.start();
        return this.proxy(serviceInterface, methodCallSendQueue);
    }

    @Override
    public <T> T createProxyWithAutoFlush(Class<T> serviceInterface, Duration duration) {
        return this.createProxyWithAutoFlush(serviceInterface, (int)duration.getDuration(), duration.getTimeUnit());
    }

    @Override
    public <T> T createProxyWithAutoFlush(Class<T> serviceInterface, PeriodicScheduler periodicScheduler, int interval, TimeUnit timeUnit) {
        SendQueue<MethodCall<Object>> methodCallSendQueue = this.requestQueue.sendQueueWithAutoFlush(periodicScheduler, interval, timeUnit);
        methodCallSendQueue.start();
        return this.proxy(serviceInterface, methodCallSendQueue);
    }

    @Override
    public <T> T createProxy(Class<T> serviceInterface) {
        SendQueue<MethodCall<Object>> methodCallSendQueue = this.requestQueue.sendQueue();
        return this.proxy(serviceInterface, methodCallSendQueue);
    }

    private <T> T proxy(Class<T> serviceInterface, final SendQueue<MethodCall<Object>> methodCallSendQueue) {
        final String uuid = serviceInterface.getName() + "::" + UUID.randomUUID().toString();
        if (!this.started.get()) {
            this.logger.info("ServiceQueue::create(...), A proxy is being asked for a service that is not started ", (Object)this.name());
        }
        InvocationHandler invocationHandler = new InvocationHandler(){
            private long messageId = 0L;
            private long timestamp = Timer.timer().now();
            private int times = 10;

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getName().equals("toString")) {
                    return "PROXY OBJECT " + BaseServiceQueueImpl.this.address();
                }
                if (method.getName().equals("clientProxyFlush")) {
                    methodCallSendQueue.flushSends();
                    return null;
                }
                if (method.getName().equals("stop")) {
                    methodCallSendQueue.stop();
                    return null;
                }
                ++this.messageId;
                --this.times;
                if (this.times == 0) {
                    this.timestamp = Timer.timer().now();
                    this.times = 10;
                } else {
                    ++this.timestamp;
                }
                MethodCallLocal call = new MethodCallLocal(method.getName(), uuid, this.timestamp, this.messageId, args);
                methodCallSendQueue.send(call);
                return null;
            }
        };
        Object o = Proxy.newProxyInstance(serviceInterface.getClassLoader(), new Class[]{serviceInterface, ClientProxy.class}, invocationHandler);
        return (T)o;
    }

    @Override
    public SendQueue<Event<Object>> events() {
        return this.eventQueue.sendQueueWithAutoFlush(50, TimeUnit.MILLISECONDS);
    }

    public String toString() {
        return "ServiceQueue{service=" + this.service.getClass().getSimpleName() + '}';
    }

    static class MethodCallLocal
    implements MethodCall<Object> {
        private final String name;
        private final long timestamp;
        private final Object[] arguments;
        private final String uuid;
        private final long messageId;
        private final boolean hasCallback;

        @Override
        public boolean hasCallback() {
            return this.hasCallback;
        }

        public MethodCallLocal(String name, String uuid, long timestamp, long messageId, Object[] args) {
            this.name = name;
            this.timestamp = timestamp;
            this.arguments = args;
            this.uuid = uuid;
            this.messageId = messageId;
            this.hasCallback = this.detectCallback();
        }

        private boolean detectCallback() {
            Object[] args = this.arguments;
            if (args == null) {
                return false;
            }
            for (int index = 0; index < args.length; ++index) {
                if (!(args[index] instanceof Callback)) continue;
                return true;
            }
            return false;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String address() {
            return this.name;
        }

        @Override
        public String returnAddress() {
            return this.uuid;
        }

        @Override
        public MultiMap<String, String> params() {
            return null;
        }

        @Override
        public MultiMap<String, String> headers() {
            return null;
        }

        @Override
        public boolean hasParams() {
            return false;
        }

        @Override
        public boolean hasHeaders() {
            return false;
        }

        @Override
        public long timestamp() {
            return this.timestamp;
        }

        @Override
        public boolean isHandled() {
            return false;
        }

        @Override
        public void handled() {
        }

        @Override
        public String objectName() {
            return "";
        }

        @Override
        public Request<Object> originatingRequest() {
            return null;
        }

        @Override
        public long id() {
            return this.messageId;
        }

        @Override
        public Object body() {
            return this.arguments;
        }

        @Override
        public boolean isSingleton() {
            return true;
        }
    }
}

