/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.service.impl;

import io.advantageous.qbit.message.MethodCall;
import io.advantageous.qbit.message.Response;
import io.advantageous.qbit.queue.Queue;
import io.advantageous.qbit.reactive.Callback;
import io.advantageous.qbit.service.impl.CallbackManager;
import io.advantageous.qbit.service.impl.HandlerKey;
import io.advantageous.qbit.util.Timer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallbackManagerWithTimeout
implements CallbackManager {
    private final String name;
    private final boolean handleTimeouts;
    private final long timeOutMS;
    private final long checkInterval;
    private final Timer timer;
    private long lastCheckTime;
    private long now;
    private final Logger logger = LoggerFactory.getLogger(CallbackManagerWithTimeout.class);
    private final boolean debug = this.logger.isDebugEnabled();
    private final Map<HandlerKey, Callback<Object>> handlers = new ConcurrentHashMap<HandlerKey, Callback<Object>>();

    public CallbackManagerWithTimeout(Timer timer, String name, boolean handleTimeouts, long timeOutMS, long checkInterval) {
        this.name = name;
        this.handleTimeouts = handleTimeouts;
        this.timeOutMS = timeOutMS;
        this.checkInterval = checkInterval > 0L ? checkInterval : 5000L;
        this.now = this.lastCheckTime = timer.now();
        this.timer = timer;
    }

    private void registerHandlerCallbackForClient(MethodCall<Object> methodCall, Callback<Object> handler) {
        this.handlers.put(new HandlerKey(methodCall.returnAddress(), methodCall.address(), methodCall.id(), methodCall.timestamp()), handler);
    }

    @Override
    public void registerCallbacks(MethodCall<Object> methodCall) {
        block3: {
            Object[] array;
            Object args;
            block2: {
                args = methodCall.body();
                if (!(args instanceof Iterable)) break block2;
                Iterable list = (Iterable)args;
                for (Object arg : list) {
                    if (!(arg instanceof Callback)) continue;
                    this.registerHandlerCallbackForClient(methodCall, (Callback)arg);
                }
                break block3;
            }
            if (!(args instanceof Object[])) break block3;
            for (Object arg : array = (Object[])args) {
                if (!(arg instanceof Callback)) continue;
                this.registerHandlerCallbackForClient(methodCall, (Callback)arg);
            }
        }
    }

    @Override
    public void startReturnHandlerProcessor(Queue<Response<Object>> responseQueue) {
        responseQueue.startListener(response -> this.handleResponse((Response<Object>)response));
    }

    @Override
    public void handleResponse(Response<Object> response) {
        HandlerKey handlerKey = new HandlerKey(response.returnAddress(), response.address(), response.id(), response.timestamp());
        Callback<Object> handler = this.handlers.remove(handlerKey);
        if (handler == null) {
            if (response.request().hasCallback()) {
                this.logger.error("Could not find handler for key {}", (Object)handlerKey);
            }
            return;
        }
        if (response.wasErrors()) {
            if (this.debug) {
                this.logger.debug("Service threw an exception address {} return address {} message id {} response error {}", new Object[]{response.address(), response.returnAddress(), response.id(), response.body()});
            }
            if (response.body() instanceof Throwable) {
                handler.onError((Throwable)response.body());
            } else {
                handler.onError(new Exception(response.body().toString()));
            }
        } else {
            handler.accept(response.body());
        }
    }

    @Override
    public void process(long currentTime) {
        this.now = currentTime != 0L ? currentTime : this.timer.now();
        long duration = this.now - this.lastCheckTime;
        if (duration > this.checkInterval) {
            this.lastCheckTime = this.now;
            if (this.handleTimeouts) {
                this.checkForTimeOuts(this.timeOutMS);
            } else {
                if (this.handlers.size() > 8000 && this.debug) {
                    this.logger.debug("Issue with handlers growing too large size {} service name {}", (Object)this.handlers.size(), (Object)this.name);
                }
                if (this.handlers.size() > 32000) {
                    this.logger.error("Issue with handlers growing very large size {} service name {}", (Object)this.handlers.size(), (Object)this.name);
                    this.checkForTimeOuts(60000L);
                }
            }
        }
    }

    private void checkForTimeOuts(long timeOutMS) {
        if (this.debug) {
            this.logger.debug("checking for timeouts");
        }
        ArrayList<Map.Entry<HandlerKey, Callback<Object>>> entries = new ArrayList<Map.Entry<HandlerKey, Callback<Object>>>(this.handlers.entrySet());
        for (Map.Entry<HandlerKey, Callback<Object>> entry : entries) {
            long duration = this.now - entry.getKey().timestamp;
            if (duration <= timeOutMS) continue;
            if (this.debug) {
                this.logger.debug("{} Call has timed out duration {} {} {}", new Object[]{this.name, this.now - entry.getKey().timestamp, entry.getKey().returnAddress, entry.getKey().messageId, new Date(entry.getKey().timestamp)});
            }
            this.handlers.remove(entry.getKey());
            entry.getValue().onTimeout();
        }
    }

    public int outstandingCallbacksCount() {
        return this.handlers.size();
    }
}

