/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.service.impl;

import io.advantageous.boon.core.Str;
import io.advantageous.boon.core.reflection.BeanUtils;
import io.advantageous.qbit.Factory;
import io.advantageous.qbit.GlobalConstants;
import io.advantageous.qbit.annotation.AnnotationUtils;
import io.advantageous.qbit.events.EventManager;
import io.advantageous.qbit.message.MethodCall;
import io.advantageous.qbit.message.MethodCallBuilder;
import io.advantageous.qbit.message.Request;
import io.advantageous.qbit.message.Response;
import io.advantageous.qbit.message.impl.ResponseImpl;
import io.advantageous.qbit.queue.Queue;
import io.advantageous.qbit.queue.QueueBuilder;
import io.advantageous.qbit.queue.ReceiveQueueListener;
import io.advantageous.qbit.queue.SendQueue;
import io.advantageous.qbit.service.BeforeMethodCall;
import io.advantageous.qbit.service.ServiceBuilder;
import io.advantageous.qbit.service.ServiceBundle;
import io.advantageous.qbit.service.ServiceFlushable;
import io.advantageous.qbit.service.ServiceMethodNotFoundException;
import io.advantageous.qbit.service.ServiceQueue;
import io.advantageous.qbit.service.Stoppable;
import io.advantageous.qbit.service.health.HealthServiceAsync;
import io.advantageous.qbit.service.impl.CallbackManager;
import io.advantageous.qbit.service.impl.ServiceConstants;
import io.advantageous.qbit.service.stats.StatsCollector;
import io.advantageous.qbit.system.QBitSystemManager;
import io.advantageous.qbit.transforms.Transformer;
import io.advantageous.qbit.util.ConcurrentHashSet;
import io.advantageous.qbit.util.Timer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceBundleImpl
implements ServiceBundle {
    private final Logger logger = LoggerFactory.getLogger(ServiceBundleImpl.class);
    private final boolean debug = GlobalConstants.DEBUG && this.logger.isDebugEnabled();
    private final boolean asyncCalls;
    private final boolean invokeDynamic;
    private final QBitSystemManager systemManager;
    private final CallbackManager callbackManager;
    private final Map<String, Consumer<MethodCall<Object>>> serviceMapping = new ConcurrentHashMap<String, Consumer<MethodCall<Object>>>();
    private final Set<Stoppable> servicesToStop = new ConcurrentHashSet<Stoppable>(10);
    private final Set<ServiceFlushable> servicesToFlush = new ConcurrentHashSet<ServiceFlushable>(10);
    private final Set<SendQueue<MethodCall<Object>>> sendQueues = new ConcurrentHashSet<SendQueue<MethodCall<Object>>>(10);
    private final Queue<MethodCall<Object>> methodQueue;
    private final SendQueue<MethodCall<Object>> methodSendQueue;
    private final Queue<Response<Object>> responseQueue;
    private final Queue<Response<Object>> webResponseQueue;
    private final String rootAddress;
    private final Factory factory;
    private final BeforeMethodCall beforeMethodCall;
    private final BeforeMethodCall beforeMethodCallAfterTransform;
    private final Transformer<Request, Object> argTransformer;
    private final TreeSet<String> addressesByDescending = new TreeSet((o1, o2) -> o2.compareTo((String)o1));
    private final TreeSet<String> seenAddressesDescending = new TreeSet((o1, o2) -> o2.compareTo((String)o1));
    private final QueueBuilder requestQueueBuilder;
    private final QueueBuilder responseQueueBuilder;
    private final HealthServiceAsync healthService;
    private final StatsCollector statsCollector;
    private final Timer timer;
    private final int sampleStatFlushRate;
    private final int checkTimingEveryXCalls;
    private final EventManager eventManager;

    public ServiceBundleImpl(String address, QueueBuilder requestQueueBuilder, QueueBuilder responseQueueBuilder, QueueBuilder webResponseQueueBuilder, Factory factory, boolean asyncCalls, BeforeMethodCall beforeMethodCall, BeforeMethodCall beforeMethodCallAfterTransform, Transformer<Request, Object> argTransformer, boolean invokeDynamic, QBitSystemManager systemManager, HealthServiceAsync healthService, StatsCollector statsCollector, Timer timer, int sampleStatFlushRate, int checkTimingEveryXCalls, CallbackManager callbackManager, EventManager eventManager) {
        this.healthService = healthService;
        this.statsCollector = statsCollector;
        this.invokeDynamic = invokeDynamic;
        this.systemManager = systemManager;
        this.timer = timer;
        this.sampleStatFlushRate = sampleStatFlushRate;
        this.checkTimingEveryXCalls = checkTimingEveryXCalls;
        this.callbackManager = callbackManager;
        String rootAddress = address.endsWith("/") ? address.substring(0, address.length() - 1) : address;
        this.beforeMethodCall = beforeMethodCall;
        this.beforeMethodCallAfterTransform = beforeMethodCallAfterTransform;
        this.argTransformer = argTransformer;
        this.rootAddress = rootAddress;
        this.factory = factory;
        this.asyncCalls = asyncCalls;
        this.requestQueueBuilder = requestQueueBuilder;
        this.responseQueueBuilder = responseQueueBuilder;
        this.methodQueue = requestQueueBuilder.setName("Call Queue " + address).build();
        this.responseQueue = responseQueueBuilder.setName("Response Queue " + address).build();
        this.webResponseQueue = webResponseQueueBuilder.setName("Web Response Queue " + address).build();
        this.methodSendQueue = this.methodQueue.sendQueue();
        this.eventManager = eventManager;
    }

    private void doCall(MethodCall<Object> methodCall) {
        if (this.debug) {
            this.logger.debug(ServiceBundleImpl.class.getName(), new Object[]{"::doCall() ", methodCall.name(), methodCall.address(), "\n", methodCall});
        }
        try {
            this.callbackManager.registerCallbacks(methodCall);
            boolean[] continueFlag = new boolean[1];
            methodCall = this.handleBeforeMethodCall(methodCall, continueFlag);
            if (!continueFlag[0]) {
                if (this.debug) {
                    this.logger.debug(ServiceBundleImpl.class.getName() + "::doCall() " + "Flag from before call handling does not want to continue");
                }
            } else {
                Consumer<MethodCall<Object>> methodDispatcher = this.getMethodDispatcher(methodCall);
                methodDispatcher.accept(methodCall);
            }
        }
        catch (Exception ex) {
            ResponseImpl response = new ResponseImpl(methodCall, ex);
            this.responseQueue.sendQueue().sendAndFlush(response);
        }
    }

    @Override
    public String address() {
        return this.rootAddress;
    }

    @Override
    public ServiceBundle addService(Object object) {
        if (this.debug) {
            this.logger.debug("ServiceBundleImpl::addServiceObject(object)- service added");
        }
        this.addServiceObject(null, object);
        return this;
    }

    @Override
    public ServiceBundle addServiceObject(String serviceAddress, Object serviceObject) {
        String bindStatHealthName;
        this.logger.info(ServiceBundleImpl.class.getName() + " serviceAddress " + serviceAddress + " service object " + serviceObject);
        if (serviceObject instanceof Consumer) {
            this.addServiceConsumer(serviceAddress, (Consumer)serviceObject);
            return this;
        }
        if (serviceObject instanceof ServiceQueue) {
            this.addServiceService(serviceAddress, (ServiceQueue)serviceObject);
            return this;
        }
        ServiceBuilder serviceBuilder = ServiceBuilder.serviceBuilder().setRootAddress(this.rootAddress).setServiceObject(serviceObject).setServiceAddress(serviceAddress).setTimer(this.timer).setResponseQueue(this.responseQueue).setAsyncResponse(this.asyncCalls).setInvokeDynamic(this.invokeDynamic).setSystemManager(this.systemManager).setRequestQueueBuilder((QueueBuilder)BeanUtils.copy((Object)this.requestQueueBuilder)).setRequestQueueBuilder(this.requestQueueBuilder).setHandleCallbacks(false).setCreateCallbackHandler(false).setEventManager(this.eventManager);
        String string = bindStatHealthName = serviceAddress == null ? AnnotationUtils.readServiceName(serviceObject) : serviceAddress;
        if (this.healthService != null) {
            serviceBuilder.registerHealthChecks(this.healthService, bindStatHealthName);
        }
        if (this.statsCollector != null) {
            serviceBuilder.registerStatsCollections(bindStatHealthName, this.statsCollector, this.sampleStatFlushRate, this.checkTimingEveryXCalls);
        }
        ServiceQueue serviceQueue = serviceBuilder.buildAndStart();
        this.addServiceService(serviceAddress, serviceQueue);
        return this;
    }

    @Override
    public ServiceBundle addServiceConsumer(String serviceAddress, Consumer<MethodCall<Object>> methodCallConsumer) {
        String address = serviceAddress;
        if (address != null && !address.isEmpty()) {
            this.serviceMapping.put(address, methodCallConsumer);
            this.serviceMapping.put(address.toLowerCase(), methodCallConsumer);
            if (methodCallConsumer instanceof ServiceFlushable) {
                this.servicesToFlush.add((ServiceFlushable)((Object)methodCallConsumer));
            }
            if (methodCallConsumer instanceof Stoppable) {
                this.servicesToStop.add((Stoppable)((Object)methodCallConsumer));
            }
        } else {
            throw new IllegalStateException("Service consumer must have an address");
        }
        return this;
    }

    public void addServiceService(String serviceAddress, ServiceQueue serviceQueue) {
        this.addServiceService(null, serviceAddress, serviceQueue);
    }

    public void addServiceService(String objectName, String serviceAddress, ServiceQueue serviceQueue) {
        this.servicesToStop.add(serviceQueue);
        this.servicesToFlush.add(serviceQueue);
        QueueDispatch dispatch = new QueueDispatch(serviceQueue);
        if (serviceAddress != null && !serviceAddress.isEmpty()) {
            this.serviceMapping.put(serviceAddress, dispatch);
        }
        if (objectName != null) {
            this.serviceMapping.put(objectName, dispatch);
        }
        this.serviceMapping.put(serviceQueue.name().toLowerCase(), dispatch);
        this.serviceMapping.put(serviceQueue.name(), dispatch);
        this.serviceMapping.put(serviceQueue.address(), dispatch);
        this.serviceMapping.put(serviceQueue.address().toLowerCase(), dispatch);
        this.sendQueues.add(dispatch.requests);
        Collection<String> addresses = serviceQueue.addresses(this.rootAddress);
        if (this.debug) {
            this.logger.debug(ServiceBundleImpl.class.getName() + " addresses: " + addresses);
        }
        for (String addr : addresses) {
            this.addressesByDescending.add(addr);
            this.serviceMapping.put(addr, dispatch);
        }
    }

    @Override
    public Queue<Response<Object>> responses() {
        return this.responseQueue;
    }

    @Override
    public SendQueue<MethodCall<Object>> methodSendQueue() {
        return this.methodQueue.sendQueue();
    }

    @Override
    public void call(MethodCall<Object> methodCall) {
        if (this.debug) {
            this.logger.debug(ServiceBundleImpl.class.getName() + "::call() " + methodCall.name() + " " + " " + methodCall.address() + "\n" + methodCall);
        }
        this.methodSendQueue.send(methodCall);
    }

    @Override
    public void call(List<MethodCall<Object>> methodCalls) {
        if (this.debug) {
            this.logger.debug("ServiceBundleImpl::call()- methodCalls: \n" + methodCalls);
        }
        this.methodSendQueue.sendBatch((Collection<MethodCall<Object>>)methodCalls);
    }

    @Override
    public <T> T createLocalProxy(Class<T> serviceInterface, String myService) {
        Consumer<MethodCall<Object>> callConsumer = this.serviceMapping.get(myService);
        if (callConsumer == null) {
            this.logger.error("Service requested does not exist " + myService);
        }
        return this.factory.createLocalProxy(serviceInterface, myService, this);
    }

    @Override
    public <T> T createOneWayLocalProxy(Class<T> serviceInterface, String myService) {
        Consumer<MethodCall<Object>> callConsumer = this.serviceMapping.get(myService);
        if (callConsumer == null) {
            throw new IllegalStateException("Service requested does not exist " + myService);
        }
        if (callConsumer instanceof QueueDispatch) {
            return ((QueueDispatch)callConsumer).serviceQueue.createProxyWithAutoFlush(serviceInterface, 100, TimeUnit.MILLISECONDS);
        }
        return this.factory.createLocalProxy(serviceInterface, myService, this);
    }

    private MethodCall<Object> handleBeforeMethodCall(MethodCall<Object> methodCall, boolean[] continueFlag) {
        methodCall = this.beforeMethodCall(methodCall, continueFlag);
        return methodCall;
    }

    private Consumer<MethodCall<Object>> getMethodDispatcher(MethodCall<Object> methodCall) {
        boolean hasObjectName;
        Consumer<MethodCall<Object>> methodCallConsumer = null;
        boolean hasAddress = !Str.isEmpty((String)methodCall.address());
        boolean hasMethodName = !Str.isEmpty((String)methodCall.name());
        boolean bl = hasObjectName = !Str.isEmpty((String)methodCall.objectName());
        if (hasMethodName && hasObjectName) {
            methodCallConsumer = this.serviceMapping.get(methodCall.objectName());
        }
        if (hasAddress && methodCallConsumer == null) {
            methodCallConsumer = this.getMethodDispatchByAddress(methodCall);
        }
        if (methodCallConsumer == null) {
            this.logger.error("No service at method address " + methodCall.address() + " method name " + methodCall.name() + " object name " + methodCall.objectName() + "\n SERVICES" + this.serviceMapping.keySet() + "\n");
            Set<String> uris = this.serviceMapping.keySet();
            uris.forEach(it -> this.logger.error("known URI path " + it));
            throw new ServiceMethodNotFoundException("there is no object at this address: " + methodCall.address() + "\n method name=" + methodCall.name() + "\n objectName=" + methodCall.objectName(), methodCall.address());
        }
        return methodCallConsumer;
    }

    private Consumer<MethodCall<Object>> getMethodDispatchByAddress(MethodCall<Object> methodCall) {
        String callAddress = methodCall.address();
        Consumer<MethodCall<Object>> methodConsumerByAddress = this.serviceMapping.get(callAddress);
        if (methodConsumerByAddress == null) {
            String addr = this.seenAddressesDescending.higher(callAddress);
            if (addr != null && callAddress.startsWith(addr)) {
                methodConsumerByAddress = this.serviceMapping.get(addr);
                return methodConsumerByAddress;
            }
            addr = this.addressesByDescending.higher(callAddress);
            if (addr != null && callAddress.startsWith(addr) && (methodConsumerByAddress = this.serviceMapping.get(addr)) != null) {
                this.seenAddressesDescending.add(addr);
            }
        }
        return methodConsumerByAddress;
    }

    private MethodCall<Object> beforeMethodCall(MethodCall<Object> methodCall, boolean[] continueCall) {
        if (this.beforeMethodCall.before(methodCall)) {
            continueCall[0] = true;
            methodCall = this.transformBeforeMethodCall(methodCall);
            continueCall[0] = this.beforeMethodCallAfterTransform.before(methodCall);
            return methodCall;
        }
        continueCall[0] = false;
        return methodCall;
    }

    private MethodCall<Object> transformBeforeMethodCall(MethodCall<Object> methodCall) {
        if (this.argTransformer == null || this.argTransformer == ServiceConstants.NO_OP_ARG_TRANSFORM) {
            return methodCall;
        }
        Object arg = this.argTransformer.transform(methodCall);
        return MethodCallBuilder.transformed(methodCall, arg);
    }

    @Override
    public void flushSends() {
        this.methodSendQueue.flushSends();
    }

    @Override
    public void stop() {
        if (this.debug) {
            this.logger.debug(ServiceBundleImpl.class.getName(), (Object)"::stop()");
        }
        this.methodQueue.stop();
        for (Stoppable service : this.servicesToStop) {
            service.stop();
        }
        try {
            this.responseQueue.stop();
        }
        catch (Exception ex) {
            this.logger.debug("", (Throwable)ex);
        }
        try {
            this.webResponseQueue.stop();
        }
        catch (Exception ex) {
            this.logger.debug("", (Throwable)ex);
        }
        if (this.systemManager != null) {
            this.systemManager.serviceShutDown();
        }
    }

    @Override
    public List<String> endPoints() {
        return new ArrayList<String>(this.serviceMapping.keySet());
    }

    @Override
    public void startReturnHandlerProcessor(ReceiveQueueListener<Response<Object>> listener) {
        this.responseQueue.startListener(listener);
    }

    @Override
    public void startWebResponseReturnHandler(ReceiveQueueListener<Response<Object>> listener) {
        this.webResponseQueue.startListener(listener);
    }

    @Override
    public void startReturnHandlerProcessor() {
        final SendQueue<Response<Object>> webResponseSendQueue = this.webResponseQueue.sendQueue();
        this.responseQueue.startListener(new ReceiveQueueListener<Response<Object>>(){

            @Override
            public void receive(Response<Object> response) {
                Request<Object> originatingRequest = response.request().originatingRequest();
                if (originatingRequest == null) {
                    ServiceBundleImpl.this.callbackManager.handleResponse(response);
                } else {
                    webResponseSendQueue.send(response);
                }
            }

            @Override
            public void empty() {
                webResponseSendQueue.flushSends();
            }

            @Override
            public void limit() {
                webResponseSendQueue.flushSends();
            }

            @Override
            public void shutdown() {
            }

            @Override
            public void idle() {
                webResponseSendQueue.flushSends();
            }

            @Override
            public void startBatch() {
            }
        });
    }

    @Override
    public ServiceBundle startUpCallQueue() {
        this.methodQueue.startListener(new ReceiveQueueListener<MethodCall<Object>>(){
            long time;
            long lastTimeAutoFlush;

            @Override
            public void receive(MethodCall<Object> item) {
                ServiceBundleImpl.this.doCall(item);
            }

            @Override
            public void empty() {
                this.time = ServiceBundleImpl.this.timer.now();
                if (this.time > this.lastTimeAutoFlush + 50L) {
                    for (SendQueue sendQueue : ServiceBundleImpl.this.sendQueues) {
                        sendQueue.flushSends();
                    }
                    this.lastTimeAutoFlush = this.time;
                }
            }
        });
        return this;
    }

    @Override
    public void flush() {
        this.flushSends();
        for (ServiceFlushable service : this.servicesToFlush) {
            service.flush();
        }
    }

    @Override
    public ServiceBundle addServiceQueue(String objectName, ServiceQueue serviceQueue) {
        String objectAddress = objectName.startsWith("/") ? this.address() + objectName : Str.add((String[])new String[]{this.address(), "/", objectName});
        this.addServiceService(objectName, objectAddress, serviceQueue);
        return this;
    }

    static class QueueDispatch
    implements Consumer<MethodCall<Object>> {
        final ServiceQueue serviceQueue;
        final SendQueue<MethodCall<Object>> requests;

        QueueDispatch(ServiceQueue serviceQueue) {
            this.serviceQueue = serviceQueue;
            this.requests = serviceQueue.requests();
        }

        @Override
        public void accept(MethodCall<Object> objectMethodCall) {
            this.requests.send(objectMethodCall);
        }
    }
}

