/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.service.stats;

import io.advantageous.qbit.queue.QueueCallBackHandler;
import io.advantageous.qbit.service.stats.ServiceQueueSizer;
import io.advantageous.qbit.service.stats.StatsCollector;
import io.advantageous.qbit.util.Timer;
import java.util.concurrent.TimeUnit;

public class ServiceStatsListener
implements QueueCallBackHandler {
    private final String serviceName;
    private final long flushStatsInterval;
    private final long checkQueueSizeInterval;
    private final Timer timer;
    private final int sampleEvery;
    private final ServiceQueueSizer serviceQueueSizer;
    private long now;
    private long lastFlush;
    private long lastSizeCheck;
    private final StatsCollector statsCollector;
    private final String startBatchCountKey;
    private final String queueRequestSizeKey;
    private final String queueResponseSizeKey;
    private final String receiveCountKey;
    private final String receiveTimeKey;
    private int startBatchCount;
    private int receiveCount;
    private long sampleUntilCount;
    private long beforeReceiveTime;
    private boolean timeIt;
    private int lastRequestSize = -1;
    private int lastResponseSize = -1;

    public ServiceStatsListener(String serviceName, StatsCollector statsCollector, Timer timer, long checkInInterval, TimeUnit timeUnit, int sampleEvery, ServiceQueueSizer serviceQueueSizer) {
        this.serviceName = serviceName;
        this.flushStatsInterval = timeUnit.toMillis(checkInInterval);
        this.checkQueueSizeInterval = this.flushStatsInterval * 10L;
        this.timer = timer;
        this.statsCollector = statsCollector;
        this.lastFlush = timer.now();
        this.startBatchCountKey = serviceName + ".startBatchCount";
        this.receiveCountKey = serviceName + ".receiveCount";
        this.receiveTimeKey = serviceName + ".callTimeSample";
        this.queueRequestSizeKey = serviceName + ".queueRequestSize";
        this.queueResponseSizeKey = serviceName + ".queueResponseSize";
        this.sampleEvery = sampleEvery == 0 ? -1 : sampleEvery;
        this.serviceQueueSizer = serviceQueueSizer;
    }

    @Override
    public void queueStartBatch() {
        ++this.startBatchCount;
    }

    @Override
    public void beforeReceiveCalled() {
        if (this.sampleEvery == -1) {
            return;
        }
        ++this.sampleUntilCount;
        if (this.sampleUntilCount > (long)this.sampleEvery) {
            this.sampleUntilCount = 0L;
            this.timeIt = true;
            this.beforeReceiveTime = System.nanoTime();
        }
    }

    @Override
    public void afterReceiveCalled() {
        ++this.receiveCount;
        if (this.sampleEvery == -1) {
            return;
        }
        if (this.timeIt) {
            this.timeIt = false;
            long stopTime = System.nanoTime();
            long duration = stopTime - this.beforeReceiveTime;
            if (duration > 0L) {
                this.statsCollector.recordTiming(this.receiveTimeKey, (int)duration);
            }
        }
    }

    @Override
    public void queueLimit() {
        this.sendStats();
    }

    @Override
    public void queueEmpty() {
        this.sendStats();
    }

    @Override
    public void queueInit() {
        this.statsCollector.recordLevel(this.serviceName, 1L);
    }

    @Override
    public void queueIdle() {
        this.sendStats();
    }

    @Override
    public void queueShutdown() {
        this.statsCollector.recordLevel(this.serviceName, 1L);
    }

    private void sendStats() {
        this.now = this.timer.now();
        this.calculateSizeIfNeeded();
        this.flushStatsIfNeeded();
    }

    private void calculateSizeIfNeeded() {
        if (this.serviceQueueSizer == null) {
            return;
        }
        long duration = this.now - this.lastSizeCheck;
        if (duration > this.checkQueueSizeInterval) {
            this.lastSizeCheck = this.now;
            int requestSize = this.serviceQueueSizer.requestSize();
            int responseSize = this.serviceQueueSizer.responseSize();
            if (requestSize != this.lastRequestSize) {
                this.lastRequestSize = requestSize;
                this.statsCollector.recordLevel(this.queueRequestSizeKey, requestSize);
            }
            if (responseSize != this.lastResponseSize) {
                this.lastResponseSize = responseSize;
                this.statsCollector.recordLevel(this.queueResponseSizeKey, responseSize);
            }
        }
    }

    private void flushStatsIfNeeded() {
        long duration = this.now - this.lastFlush;
        if (duration > this.flushStatsInterval) {
            this.lastFlush = this.now;
            if (this.startBatchCount > 0) {
                this.statsCollector.recordCount(this.startBatchCountKey, this.startBatchCount);
            }
            this.startBatchCount = 0;
            if (this.receiveCount > 0) {
                this.statsCollector.recordCount(this.receiveCountKey, this.receiveCount);
            }
            this.receiveCount = 0;
            this.statsCollector.clientProxyFlush();
        }
    }
}

