/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.service.stats;

import io.advantageous.boon.primitive.Lng;
import java.util.AbstractList;
import java.util.Arrays;

public class StatList
extends AbstractList<Long> {
    private long[] values;
    private int end;

    public StatList(int capacity) {
        this.values = new long[capacity];
    }

    public StatList() {
        this.values = new long[10];
    }

    public StatList(long[] values) {
        this.values = values;
        this.end = values.length;
    }

    private static double meanDouble(long[] values, int start, int length) {
        double mean = (double)StatList.bigSum(values, start, length) / (double)length;
        return mean;
    }

    @Override
    public void clear() {
        this.values = new long[10];
        this.end = 0;
    }

    @Override
    public Long get(int index) {
        return this.values[index];
    }

    public final long getLong(int index) {
        return this.values[index];
    }

    @Override
    public boolean add(Long integer) {
        if (this.end + 1 >= this.values.length) {
            this.values = Lng.grow((long[])this.values);
        }
        this.values[this.end] = integer;
        ++this.end;
        return true;
    }

    public boolean addLong(long integer) {
        if (this.end + 1 >= this.values.length) {
            this.values = Lng.grow((long[])this.values);
        }
        this.values[this.end] = integer;
        ++this.end;
        return true;
    }

    public StatList add(int integer) {
        if (this.end + 1 >= this.values.length) {
            this.values = Lng.grow((long[])this.values);
        }
        this.values[this.end] = integer;
        ++this.end;
        return this;
    }

    public boolean addArray(long ... newValues) {
        if (this.end + newValues.length >= this.values.length) {
            this.values = Lng.grow((long[])this.values, (int)((this.values.length + newValues.length) * 2));
        }
        System.arraycopy(newValues, 0, this.values, this.end, newValues.length);
        this.end += newValues.length;
        return true;
    }

    @Override
    public Long set(int index, Long element) {
        long oldValue = this.values[index];
        this.values[index] = element;
        return oldValue;
    }

    public long setLong(int index, long element) {
        long oldValue = this.values[index];
        this.values[index] = element;
        return oldValue;
    }

    @Override
    public int size() {
        return this.end;
    }

    public long sum() {
        return Lng.sum((long[])this.values, (int)this.end);
    }

    public long[] toValueArray() {
        return Arrays.copyOfRange(this.values, 0, this.end);
    }

    public long reduceBy(Object function) {
        return Lng.reduceBy((long[])this.values, (int)this.end, (Object)function);
    }

    public long reduceBy(Object function, String name) {
        return Lng.reduceBy((long[])this.values, (int)this.end, (Object)function, (String)name);
    }

    public long reduceBy(Lng.ReduceBy reduceBy) {
        return Lng.reduceBy((long[])this.values, (int)this.end, (Lng.ReduceBy)reduceBy);
    }

    public float mean() {
        return (float)StatList.meanDouble(this.values, 0, this.end);
    }

    public float standardDeviation() {
        double variance = Lng.varianceDouble((long[])this.values, (int)0, (int)this.end);
        return (float)Math.sqrt(variance);
    }

    public float variance() {
        return (float)Lng.varianceDouble((long[])this.values, (int)0, (int)this.end);
    }

    public long max() {
        return Lng.max((long[])this.values, (int)this.end);
    }

    public long min() {
        return Lng.min((long[])this.values, (int)this.end);
    }

    public long median() {
        return Lng.median((long[])this.values, (int)this.end);
    }

    public void sort() {
        Arrays.sort(this.values, 0, this.end);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatList integers = (StatList)o;
        if (this.end != integers.end) {
            return false;
        }
        return Lng.equals((int)0, (int)this.end, (long[])this.values, (long[])integers.values);
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.values != null ? Lng.hashCode((int)0, (int)this.end, (long[])this.values) : 0);
        result = 31 * result + this.end;
        return result;
    }

    public static long bigSum(long[] values) {
        return StatList.bigSum(values, 0, values.length);
    }

    public static long bigSum(long[] values, int length) {
        return StatList.bigSum(values, 0, length);
    }

    public static long bigSum(long[] values, int start, int length) {
        long sum = 0L;
        for (int index = start; index < length; ++index) {
            sum += values[index];
        }
        return sum;
    }
}

