/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.service.stats;

import io.advantageous.qbit.service.ServiceProxyUtils;
import io.advantageous.qbit.service.stats.StatList;
import io.advantageous.qbit.service.stats.StatsCollector;
import java.util.HashMap;
import java.util.Map;

public class StatsCollectorBuffer
implements StatsCollector {
    private final Map<String, RecordCount> counts = new HashMap<String, RecordCount>();
    private final Map<String, RecordLevel> levels = new HashMap<String, RecordLevel>();
    private final Map<String, RecordTiming> timings = new HashMap<String, RecordTiming>();
    private final StatsCollector statsCollector;

    public StatsCollectorBuffer(StatsCollector statsCollector) {
        this.statsCollector = statsCollector;
    }

    @Override
    public void increment(String name) {
        this.recordCount(name, 1L);
    }

    @Override
    public void recordCount(String name, long count) {
        RecordCount recordCount = this.counts.get(name);
        if (recordCount == null) {
            recordCount = new RecordCount(name);
            this.counts.put(name, recordCount);
        }
        recordCount.set(count);
    }

    @Override
    public void recordLevel(String name, long level) {
        RecordLevel recordLevel = this.levels.get(name);
        if (recordLevel == null) {
            recordLevel = new RecordLevel(name);
            this.levels.put(name, recordLevel);
        }
        recordLevel.set(level);
    }

    @Override
    public void recordTiming(String name, long timing) {
        RecordTiming recordTiming = this.timings.get(name);
        if (recordTiming == null) {
            recordTiming = new RecordTiming(name);
            this.timings.put(name, recordTiming);
        }
        recordTiming.set(timing);
    }

    public void sendStats() {
        this.counts.values().forEach(recordCount -> {
            if (recordCount.count > 0L) {
                this.statsCollector.recordCount(recordCount.name, recordCount.count);
                recordCount.count = 0L;
            }
        });
        this.levels.values().forEach(recordLevel -> {
            if (recordLevel.level != recordLevel.lastLevelSent) {
                recordLevel.setLastLevelSent(recordLevel.level);
                this.statsCollector.recordLevel(recordLevel.name, recordLevel.level);
            }
        });
        this.timings.values().forEach(recordTiming -> {
            if (recordTiming.list.size() == 0) {
                return;
            }
            long max = recordTiming.list.max();
            if (max > 0L) {
                this.statsCollector.recordTiming(recordTiming.name, max);
            }
            recordTiming.list.clear();
        });
        ServiceProxyUtils.flushServiceProxy(this.statsCollector);
    }

    @Override
    public void clientProxyFlush() {
        this.sendStats();
    }

    static class RecordLevel {
        long level;
        long lastLevelSent;
        final String name;

        RecordLevel(String name) {
            this.name = name;
        }

        void set(long level) {
            this.level = level;
        }

        void setLastLevelSent(long lastLevelSent) {
            this.lastLevelSent = lastLevelSent;
        }
    }

    static class RecordCount {
        long count;
        final String name;

        RecordCount(String name) {
            this.name = name;
        }

        void set(long count) {
            this.count += count;
        }
    }

    static class RecordTiming {
        final StatList list = new StatList();
        final String name;

        RecordTiming(String name) {
            this.name = name;
        }

        void set(long timing) {
            this.list.addLong(timing);
        }
    }
}

