/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.system;

import io.advantageous.qbit.GlobalConstants;
import io.advantageous.qbit.QBit;
import io.advantageous.qbit.server.Server;
import io.advantageous.qbit.service.ServiceBundle;
import io.advantageous.qbit.service.ServiceQueue;
import io.advantageous.qbit.service.Startable;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QBitSystemManager {
    private final List<ServiceQueue> serviceQueueList = new CopyOnWriteArrayList<ServiceQueue>();
    private final List<ServiceBundle> serviceBundleList = new CopyOnWriteArrayList<ServiceBundle>();
    private final List<Server> serverList = new CopyOnWriteArrayList<Server>();
    private final Logger logger = LoggerFactory.getLogger(QBitSystemManager.class);
    private final boolean debug = GlobalConstants.DEBUG || this.logger.isDebugEnabled();
    private final boolean coreSystemShutdown;
    private volatile int countTracked;
    private CountDownLatch countDownLatch;

    public QBitSystemManager() {
        this(true, true);
    }

    public QBitSystemManager(boolean coreSystemShutdown, boolean handleShutDownHook) {
        this.coreSystemShutdown = coreSystemShutdown;
        if (handleShutDownHook) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    QBitSystemManager.this.logger.info("QBit shutting down gracefully... " + new Date());
                    QBitSystemManager.this.shutDown();
                    QBitSystemManager.this.waitForShutdown();
                    if (QBitSystemManager.this.logger.isInfoEnabled()) {
                        QBitSystemManager.this.logger.info("QBit shutdown gracefully " + new Date());
                    }
                }
            });
        }
    }

    public void registerService(ServiceQueue serviceQueue) {
        if (this.debug) {
            this.logger.debug("register: " + serviceQueue);
        }
        ++this.countTracked;
        this.serviceQueueList.add(serviceQueue);
    }

    public void registerServer(Server server) {
        ++this.countTracked;
        this.serverList.add(server);
    }

    public void registerServiceBundle(ServiceBundle bundle) {
        ++this.countTracked;
        this.serviceBundleList.add(bundle);
    }

    public void shutDown() {
        for (ServiceQueue serviceQueue : this.serviceQueueList) {
            try {
                serviceQueue.stop();
            }
            catch (Exception ex) {
                if (!this.debug) continue;
                this.logger.debug("Unable to shutdown service", (Throwable)ex);
            }
        }
        for (Server server : this.serverList) {
            try {
                server.stop();
            }
            catch (Exception ex) {
                if (!this.debug) continue;
                this.logger.debug("Unable to shutdown server", (Throwable)ex);
            }
        }
        for (ServiceBundle bundle : this.serviceBundleList) {
            try {
                bundle.stop();
            }
            catch (Exception ex) {
                if (!this.debug) continue;
                this.logger.debug("Unable to shutdown bundle", (Throwable)ex);
            }
        }
        this.countTracked = 0;
        if (this.coreSystemShutdown) {
            QBit.factory().shutdownSystemEventBus();
        }
    }

    public void serviceShutDown() {
        if (this.countDownLatch != null) {
            this.countDownLatch.countDown();
        }
        if (this.debug) {
            this.logger.debug("serviceShutDown: " + (this.countDownLatch != null ? this.countDownLatch.getCount() : 0L));
        }
    }

    public void waitForShutdown() {
        block5: {
            if (this.countDownLatch == null) {
                this.countDownLatch = new CountDownLatch(this.countTracked);
            }
            try {
                this.countDownLatch.await();
            }
            catch (InterruptedException e) {
                if (!this.debug) break block5;
                this.logger.debug("done", (Throwable)e);
            }
        }
        if (this.coreSystemShutdown) {
            QBit.factory().shutdownSystemEventBus();
        }
        if (this.debug) {
            this.logger.debug("Shutdown complete!");
        }
    }

    public void startAll() {
        this.serviceQueueList.forEach(Startable::start);
        this.serverList.forEach(Startable::start);
        this.serviceBundleList.forEach(ServiceBundle::startUpCallQueue);
        this.countDownLatch = new CountDownLatch(this.countTracked);
        if (this.debug) {
            this.logger.debug("startAll", (Object)this.countDownLatch.getCount());
        }
        if (this.debug) {
            this.logger.debug("startAll", (Object)this.countTracked);
        }
    }
}

