/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.time;

import java.util.concurrent.TimeUnit;

public class Duration {
    public static final Duration NEVER = new Duration(Long.MAX_VALUE, TimeUnit.SECONDS);
    public static final Duration NANOSECONDS = new Duration(1L, TimeUnit.NANOSECONDS);
    public static final Duration MINUTE;
    public static final Duration ONE_MINUTE;
    public static final Duration MINUTES;
    public static final Duration SECOND;
    public static final Duration ONE_SECOND;
    public static final Duration SECONDS;
    public static final Duration FIVE_SECONDS;
    public static final Duration TEN_SECONDS;
    public static final Duration HOUR;
    public static final Duration ONE_HOUR;
    public static final Duration HOURS;
    public static final Duration TWO_HOURS;
    public static final Duration FOUR_HOURS;
    public static final Duration DAY;
    public static final Duration DAYS;
    public static final Duration ONE_DAY;
    public static final Duration ONE_WEEK;
    public static final Duration MILLISECONDS;
    public static final Duration TEN_MILLIS;
    public static final Duration TWENTY_FIVE_MILLIS;
    public static final Duration FIFTY_MILLIS;
    public static final Duration HUNDRED_MILLIS;
    private final long duration;
    private final TimeUnit timeUnit;

    public static Duration seconds(long units) {
        return SECONDS.units(units);
    }

    public static Duration minutes(long units) {
        return MINUTES.units(units);
    }

    public static Duration milliseconds(long units) {
        return MILLISECONDS.units(units);
    }

    public static Duration nanoseconds(long units) {
        return NANOSECONDS.units(units);
    }

    public static Duration hours(long units) {
        return HOURS.units(units);
    }

    public static Duration days(long units) {
        return DAYS.units(units);
    }

    public Duration(long duration, TimeUnit timeUnit) {
        this.duration = duration;
        this.timeUnit = timeUnit;
    }

    public long getDuration() {
        return this.duration;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public long toMillis() {
        return this.timeUnit.toMillis(this.duration);
    }

    public Duration multiply(long times) {
        return new Duration(this.duration * times, this.timeUnit);
    }

    public Duration units(long units) {
        return new Duration(this.duration * units, this.timeUnit);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Duration duration1 = (Duration)o;
        return this.duration == duration1.duration && this.timeUnit == duration1.timeUnit;
    }

    public int hashCode() {
        int result = (int)(this.duration ^ this.duration >>> 32);
        result = 31 * result + (this.timeUnit != null ? this.timeUnit.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Duration{duration=" + this.getDuration() + ", timeUnit=" + (Object)((Object)this.getTimeUnit()) + '}';
    }

    static {
        ONE_MINUTE = MINUTE = new Duration(1L, TimeUnit.MINUTES);
        MINUTES = MINUTE;
        ONE_SECOND = SECOND = new Duration(1L, TimeUnit.SECONDS);
        SECONDS = SECOND;
        FIVE_SECONDS = SECONDS.multiply(5L);
        TEN_SECONDS = SECONDS.multiply(10L);
        HOURS = ONE_HOUR = (HOUR = new Duration(1L, TimeUnit.HOURS));
        TWO_HOURS = HOURS.multiply(2L);
        FOUR_HOURS = HOUR.multiply(4L);
        DAYS = DAY = new Duration(1L, TimeUnit.DAYS);
        ONE_DAY = DAY;
        ONE_WEEK = DAY.units(7L);
        MILLISECONDS = new Duration(1L, TimeUnit.MILLISECONDS);
        TEN_MILLIS = MILLISECONDS.units(10L);
        TWENTY_FIVE_MILLIS = MILLISECONDS.multiply(25L);
        FIFTY_MILLIS = MILLISECONDS.multiply(50L);
        HUNDRED_MILLIS = MILLISECONDS.units(100L);
    }
}

