/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ConcurrentHashSet<T>
implements Set<T> {
    private static final Object NOTHING = new Object();
    private final Map<T, Object> map;

    public ConcurrentHashSet(int size) {
        this.map = new ConcurrentHashMap<T, Object>(size);
    }

    public ConcurrentHashSet() {
        this.map = new ConcurrentHashMap<T, Object>();
    }

    @Override
    public boolean add(T e) {
        return this.map.put(e, NOTHING) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) == null;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.map.keySet().containsAll(collection);
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        boolean added = false;
        for (T e : collection) {
            if (this.map.put(e, NOTHING) != null) continue;
            added = true;
        }
        return added;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.map.keySet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.map.keySet().toArray(a);
    }
}

