/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.util;

import io.advantageous.qbit.util.MultiMapImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public interface MultiMap<K, V>
extends Iterable<Map.Entry<K, Collection<V>>>,
Map<K, V> {
    public static final MultiMap EMPTY = new MultiMap(){
        private final Map empty = Collections.emptyMap();

        @Override
        public Iterator<Map.Entry> iterator() {
            return this.empty.entrySet().iterator();
        }

        public MultiMap add(Object key, Object o) {
            return null;
        }

        public Object getFirst(Object key) {
            return null;
        }

        public Iterable getAll(Object key) {
            return Collections.EMPTY_LIST;
        }

        public boolean removeValueFrom(Object key, Object o) {
            return false;
        }

        public boolean removeMulti(Object key) {
            return false;
        }

        public Iterable keySetMulti() {
            return Collections.EMPTY_LIST;
        }

        public Iterable valueMulti() {
            return Collections.EMPTY_LIST;
        }

        public void putAll(MultiMap params) {
        }

        public Map baseMap() {
            return this.empty;
        }

        public Object getSingleObject(Object name) {
            return null;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean containsKey(Object key) {
            return false;
        }

        @Override
        public boolean containsValue(Object value) {
            return false;
        }

        @Override
        public Object get(Object key) {
            return this.empty.get(key);
        }

        @Override
        public Object put(Object key, Object value) {
            return this.empty.put(key, value);
        }

        @Override
        public Object remove(Object key) {
            return this.empty.remove(key);
        }

        @Override
        public void putAll(Map m) {
            this.empty.putAll(m);
        }

        @Override
        public void clear() {
            this.empty.clear();
        }

        @Override
        public Set keySet() {
            return this.empty.keySet();
        }

        @Override
        public Collection values() {
            return this.empty.values();
        }

        @Override
        public Set<Map.Entry> entrySet() {
            return this.empty.entrySet();
        }
    };

    public static <K, V> MultiMap<K, V> multiMap() {
        return new MultiMapImpl();
    }

    public static <K, V> MultiMap<K, V> empty() {
        return EMPTY;
    }

    @Override
    public Iterator<Map.Entry<K, Collection<V>>> iterator();

    default public MultiMap<K, V> add(K key, V v) {
        throw new UnsupportedOperationException("add");
    }

    public V getFirst(K var1);

    public Iterable<V> getAll(K var1);

    default public boolean removeValueFrom(K key, V v) {
        throw new UnsupportedOperationException("removeValueFrom");
    }

    default public boolean removeMulti(K key) {
        throw new UnsupportedOperationException("removeMulti");
    }

    public Iterable<K> keySetMulti();

    @Override
    default public void putAll(MultiMap<K, V> params) {
        throw new UnsupportedOperationException("putAll");
    }

    default public Map<? extends K, ? extends Collection<V>> baseMap() {
        throw new UnsupportedOperationException("baseMap");
    }

    public V getSingleObject(K var1);

    @Override
    default public boolean containsValue(Object value) {
        throw new UnsupportedOperationException("Unsupported");
    }

    @Override
    default public V put(K key, V value) {
        throw new UnsupportedOperationException("Unsupported");
    }

    @Override
    default public V remove(Object key) {
        throw new UnsupportedOperationException("Unsupported");
    }

    @Override
    default public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException("Unsupported");
    }

    @Override
    default public void clear() {
        throw new UnsupportedOperationException("Unsupported");
    }

    @Override
    default public Collection<V> values() {
        throw new UnsupportedOperationException("Unsupported");
    }

    @Override
    default public Set<Map.Entry<K, V>> entrySet() {
        return Collections.emptySet();
    }

    default public Iterable<V> valueMulti() {
        throw new UnsupportedOperationException("Unsupported");
    }
}

