/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.util;

import io.advantageous.qbit.util.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;

public class MultiMapImpl<K, V>
implements MultiMap<K, V> {
    private int initialSize = 10;
    private Map<K, Collection<V>> map;
    private Class<? extends Collection> collectionClass = ArrayList.class;

    public MultiMapImpl(Class<? extends Collection> collectionClass, int initialSize) {
        this.collectionClass = collectionClass;
        this.initialSize = initialSize;
    }

    public MultiMapImpl(Class<? extends Collection> collectionClass) {
        this.collectionClass = collectionClass;
        this.map = new ConcurrentHashMap<K, Collection<V>>();
    }

    public MultiMapImpl() {
        this.map = new ConcurrentHashMap<K, Collection<V>>();
    }

    public MultiMapImpl(Map<K, V[]> parameterMap) {
        this.map = new ConcurrentHashMap<K, Collection<V>>(parameterMap.size());
        Set<Map.Entry<K, V[]>> entries = parameterMap.entrySet();
        for (Map.Entry<K, V[]> entry : entries) {
            for (V value : entry.getValue()) {
                this.add(entry.getKey(), value);
            }
        }
    }

    static Collection<Object> createCollectionFromClass(Class<?> type, int size) {
        if (type == List.class) {
            return new ArrayList<Object>(size);
        }
        if (type == SortedSet.class) {
            return new TreeSet<Object>();
        }
        if (type == Set.class) {
            return new LinkedHashSet<Object>(size);
        }
        if (type.isAssignableFrom(List.class)) {
            return new ArrayList<Object>();
        }
        if (type.isAssignableFrom(SortedSet.class)) {
            return new TreeSet<Object>();
        }
        if (type.isAssignableFrom(Set.class)) {
            return new LinkedHashSet<Object>(size);
        }
        return new ArrayList<Object>(size);
    }

    @Override
    public Iterator<Map.Entry<K, Collection<V>>> iterator() {
        return this.map.entrySet().iterator();
    }

    @Override
    public MultiMap<K, V> add(K key, V v) {
        Collection<V> collection = this.map.get(key);
        if (collection == null) {
            collection = this.createCollection(key);
        }
        collection.add(v);
        return this;
    }

    @Override
    public V put(K key, V value) {
        Collection<V> collection = this.map.get(key);
        if (collection == null) {
            collection = this.createCollection(key);
        }
        collection.add(value);
        return null;
    }

    @Override
    public V remove(Object key) {
        this.map.remove(key);
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        Set<Map.Entry<K, V>> entries = m.entrySet();
        for (Map.Entry<K, V> entry : entries) {
            this.add(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public V get(Object key) {
        return this.getFirst(key);
    }

    @Override
    public V getFirst(K key) {
        Collection<V> collection = this.map.get(key);
        if (collection == null || collection.size() == 0) {
            return null;
        }
        return collection.iterator().next();
    }

    @Override
    public Iterable<V> getAll(K key) {
        Collection<V> collection = this.map.get(key);
        if (collection == null) {
            return Collections.emptyList();
        }
        return collection;
    }

    @Override
    public boolean removeValueFrom(K key, V v) {
        Collection<V> collection = this.map.get(key);
        if (collection == null) {
            return false;
        }
        return collection.remove(v);
    }

    @Override
    public boolean removeMulti(K key) {
        return this.map.remove(key) != null;
    }

    private Collection<V> createCollection(K key) {
        Collection<Object> collection = MultiMapImpl.createCollectionFromClass(this.collectionClass, this.initialSize);
        this.map.put(key, collection);
        return collection;
    }

    @Override
    public Iterable<K> keySetMulti() {
        return this.map.keySet();
    }

    @Override
    public Iterable<V> valueMulti() {
        ArrayList<V> list = new ArrayList<V>();
        Collection<Collection<V>> values = this.map.values();
        for (Collection<V> c : values) {
            for (V o : c) {
                list.add(o);
            }
        }
        return list;
    }

    @Override
    public Collection<V> values() {
        ArrayList<V> list = new ArrayList<V>();
        Collection<Collection<V>> values = this.map.values();
        for (Collection<V> c : values) {
            for (V o : c) {
                list.add(o);
            }
        }
        return list;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        final Set<Map.Entry<K, Collection<V>>> entries = this.map.entrySet();
        return new Set<Map.Entry<K, V>>(){

            @Override
            public int size() {
                return entries.size();
            }

            @Override
            public boolean isEmpty() {
                return entries.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                return entries.contains(o);
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                final Iterator iterator = entries.iterator();
                return new Iterator<Map.Entry<K, V>>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        final Map.Entry next = (Map.Entry)iterator.next();
                        Collection value = (Collection)next.getValue();
                        Object theValue = null;
                        if (value instanceof List) {
                            theValue = ((List)value).get(0);
                        }
                        final Object item = theValue;
                        return new Map.Entry<K, V>(){

                            @Override
                            public K getKey() {
                                return next.getKey();
                            }

                            @Override
                            public V getValue() {
                                return item;
                            }

                            @Override
                            public V setValue(V value) {
                                return null;
                            }
                        };
                    }

                    @Override
                    public void remove() {
                    }
                };
            }

            @Override
            public Object[] toArray() {
                throw new UnsupportedOperationException();
            }

            @Override
            public <T> T[] toArray(T[] a) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean add(Map.Entry<K, V> kvEntry) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o) {
                return false;
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<K, V>> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        if (!this.map.containsKey(key)) {
            return false;
        }
        Collection<V> collection = this.map.get(key);
        return collection != null && collection.size() != 0;
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(MultiMap<K, V> params) {
        this.map.putAll(params.baseMap());
    }

    @Override
    public Map<? extends K, ? extends Collection<V>> baseMap() {
        return this.map;
    }

    @Override
    public V getSingleObject(K name) {
        Collection<V> vs = this.map.get(name);
        if (vs == null || vs.size() == 0) {
            return null;
        }
        if (vs.size() == 1) {
            vs.iterator().hasNext();
            return vs.iterator().next();
        }
        return null;
    }

    public String toString() {
        return "MultiMapImpl{initialSize=" + this.initialSize + ", map=" + this.map + ", collectionClass=" + this.collectionClass + '}';
    }
}

