/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.util;

import io.advantageous.qbit.client.Client;
import io.advantageous.qbit.client.ClientBuilder;
import java.net.URI;

public class RemoteFactoryUtil {
    private RemoteFactoryUtil() {
    }

    public static <T> T getRemote(URI address, Class<T> clazz) {
        return RemoteFactoryUtil.getRemoteByName(address, clazz, clazz.getName());
    }

    public static <T> T getRemoteByName(URI address, Class<T> clazz, String name) {
        Client client = ClientBuilder.clientBuilder().setHost(address.getHost()).setPort(address.getPort()).setUri(address.getPath()).build();
        try {
            T clientProxy = client.createProxy(clazz, name);
            client.start();
            return clientProxy;
        }
        catch (Exception ex) {
            try {
                client.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new IllegalStateException(ex);
        }
    }
}

