/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.util;

import io.advantageous.qbit.util.Timer;

public class TestTimer
extends Timer {
    private long time = 0L;

    @Override
    public long time() {
        return this.time == 0L ? Timer.timer().time() : this.time;
    }

    @Override
    public long now() {
        return this.time();
    }

    public void setTime() {
        this.time = Timer.timer().time();
    }

    public TestTimer useRealTime() {
        this.time = 0L;
        return this;
    }

    public TestTimer minutes(int minutes) {
        long delta = minutes * 60 * 1000;
        this.time += delta;
        return this;
    }

    public TestTimer days(int days) {
        long delta = days * 60 * 60 * 1000 * 24;
        this.time += delta;
        return this;
    }

    public TestTimer hours(int hours) {
        long delta = hours * 60 * 60 * 1000;
        this.time += delta;
        return this;
    }

    public TestTimer seconds(int seconds) {
        long delta = seconds * 1000;
        this.time += delta;
        return this;
    }

    public TestTimer ms(int delta) {
        this.time += (long)delta;
        return this;
    }

    public int unixTime() {
        long t = this.time();
        return (int)(t / 1000L);
    }
}

