/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.util;

import io.advantageous.qbit.GlobalConstants;
import io.advantageous.qbit.concurrent.ExecutorContext;
import io.advantageous.qbit.concurrent.ScheduledExecutorBuilder;
import java.time.Clock;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Timer {
    private static final AtomicReference<Timer> timeHolder = new AtomicReference();
    private final Logger logger = LoggerFactory.getLogger(Timer.class);
    private final boolean debug = GlobalConstants.DEBUG || this.logger.isDebugEnabled();
    private final AtomicLong time = new AtomicLong(Clock.systemUTC().millis());
    private ExecutorContext executorContext;

    public static Timer timer() {
        if (timeHolder.get() == null && timeHolder.compareAndSet(timeHolder.get(), new Timer())) {
            timeHolder.get().start();
        }
        return timeHolder.get();
    }

    public static long clockTime() {
        return Timer.timer().now();
    }

    public void stop() {
        if (this.debug) {
            this.logger.debug("timer stopped");
        }
        if (this.executorContext != null) {
            this.executorContext.stop();
        }
        this.executorContext = null;
    }

    private void start() {
        if (this.debug) {
            this.logger.debug("timer started");
        }
        if (this.executorContext != null) {
            throw new IllegalStateException("You can't startClient a timer twice");
        }
        this.executorContext = ScheduledExecutorBuilder.scheduledExecutorBuilder().setPriority(10).setThreadName("Timer OutputQueue Manager").setDaemon(true).setInitialDelay(50).setPeriod(50).setRunnable(this::manageTimer).build();
        this.executorContext.start();
    }

    private void manageTimer() {
        int count = 0;
        this.time.set(Clock.systemUTC().millis());
        while (true) {
            ++count;
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
            this.time.addAndGet(5L);
            if (count <= 10) continue;
            this.time.set(Clock.systemUTC().millis());
            count = 0;
        }
    }

    public long time() {
        return this.time.get();
    }

    public long now() {
        return this.time.get();
    }
}

