/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.ng;

import java.awt.RenderingHints;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Logger;
import org.geotools.data.AbstractDataStoreFactory;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.directory.DirectoryDataStore;
import org.geotools.data.directory.FileStoreFactory;
import org.geotools.data.shapefile.ng.ShapefileDataStore;
import org.geotools.data.shapefile.ng.files.ShpFiles;
import org.geotools.util.KVP;
import org.geotools.util.logging.Logging;

public class ShapefileDataStoreFactory
extends AbstractDataStoreFactory {
    static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.shapefile");
    public static final DataAccessFactory.Param URLP = new DataAccessFactory.Param("url", URL.class, "url to a .shp file", true, null, (Map)new KVP(new Object[]{"ext", "shp"}));
    public static final DataAccessFactory.Param NAMESPACEP = new DataAccessFactory.Param("namespace", URI.class, "uri to a the namespace", false, null, (Map)new KVP(new Object[]{"level", "advanced"}));
    public static final DataAccessFactory.Param MEMORY_MAPPED = new DataAccessFactory.Param("memory mapped buffer", Boolean.class, "enable/disable the use of memory-mapped io", false, (Object)false, (Map)new KVP(new Object[]{"level", "advanced"}));
    public static final DataAccessFactory.Param CACHE_MEMORY_MAPS = new DataAccessFactory.Param("cache and reuse memory maps", Boolean.class, "only memory map a file one, then cache and reuse the map", false, (Object)true, (Map)new KVP(new Object[]{"level", "advanced"}));
    public static final DataAccessFactory.Param FILE_TYPE = new DataAccessFactory.Param("filetype", String.class, "Discriminator for directory stores", false, (Object)"shapefile", (Map)new KVP(new Object[]{"level", "advanced"}));
    public static final DataAccessFactory.Param CREATE_SPATIAL_INDEX = new DataAccessFactory.Param("create spatial index", Boolean.class, "enable/disable the automatic creation of spatial index", false, (Object)true, (Map)new KVP(new Object[]{"level", "advanced"}));
    public static final DataAccessFactory.Param DBFCHARSET = new DataAccessFactory.Param("charset", Charset.class, "character used to decode strings from the DBF file", false, Charset.forName("ISO-8859-1"), (Map)new KVP(new Object[]{"level", "advanced"})){

        public Object parse(String text) throws IOException {
            return Charset.forName(text);
        }

        public String text(Object value) {
            return ((Charset)value).name();
        }
    };
    public static final DataAccessFactory.Param FSTYPE = new DataAccessFactory.Param("fstype", String.class, "Enable using a setting of 'shape-ng'.", false, (Object)"shape-ng", (Map)new KVP(new Object[]{"level", "advanced", "options", Arrays.asList("shape-ng")}));
    public static final DataAccessFactory.Param DBFTIMEZONE = new DataAccessFactory.Param("timezone", TimeZone.class, "time zone used to read dates from the DBF file", false, TimeZone.getDefault(), (Map)new KVP(new Object[]{"level", "advanced"})){

        public Object parse(String text) throws IOException {
            return TimeZone.getTimeZone(text);
        }

        public String text(Object value) {
            return ((TimeZone)value).getID();
        }
    };

    public String getDisplayName() {
        return "Shapefile Next Generation";
    }

    public String getDescription() {
        return "ESRI(tm) Shapefiles (*.shp)";
    }

    public DataAccessFactory.Param[] getParametersInfo() {
        return new DataAccessFactory.Param[]{URLP, NAMESPACEP, CREATE_SPATIAL_INDEX, DBFCHARSET, DBFTIMEZONE, MEMORY_MAPPED, CACHE_MEMORY_MAPS, FILE_TYPE, FSTYPE};
    }

    public boolean isAvailable() {
        return true;
    }

    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return Collections.EMPTY_MAP;
    }

    public DataStore createDataStore(Map<String, Serializable> params) throws IOException {
        URL url = this.lookup(URLP, params, URL.class);
        Boolean isMemoryMapped = this.lookup(MEMORY_MAPPED, params, Boolean.class);
        Boolean cacheMemoryMaps = this.lookup(CACHE_MEMORY_MAPS, params, Boolean.class);
        URI namespace = this.lookup(NAMESPACEP, params, URI.class);
        Charset dbfCharset = this.lookup(DBFCHARSET, params, Charset.class);
        TimeZone dbfTimeZone = this.lookup(DBFTIMEZONE, params, TimeZone.class);
        Boolean isCreateSpatialIndex = this.lookup(CREATE_SPATIAL_INDEX, params, Boolean.class);
        File dir = DataUtilities.urlToFile((URL)url);
        if (dir != null && dir.isDirectory()) {
            return new DirectoryDataStore(DataUtilities.urlToFile((URL)url), new ShpFileStoreFactory(this, params));
        }
        ShpFiles shpFiles = new ShpFiles(url);
        boolean isLocal = shpFiles.isLocal();
        boolean useMemoryMappedBuffer = isLocal && isMemoryMapped != false;
        boolean createIndex = isCreateSpatialIndex != false && isLocal;
        ShapefileDataStore store = new ShapefileDataStore(url);
        if (namespace != null) {
            store.setNamespaceURI(namespace.toString());
        }
        store.setMemoryMapped(useMemoryMappedBuffer);
        store.setBufferCachingEnabled(cacheMemoryMaps);
        store.setCharset(dbfCharset);
        store.setTimeZone(dbfTimeZone);
        store.setIndexed(createIndex);
        return store;
    }

    public DataStore createNewDataStore(Map<String, Serializable> params) throws IOException {
        return this.createDataStore(params);
    }

    <T> T lookup(DataAccessFactory.Param param, Map<String, Serializable> params, Class<T> target) throws IOException {
        Object result = param.lookUp(params);
        if (result == null) {
            return (T)param.getDefaultValue();
        }
        return (T)result;
    }

    public boolean canProcess(Map params) {
        if (!super.canProcess(params)) {
            return false;
        }
        try {
            URL url = (URL)URLP.lookUp(params);
            if (this.canProcess(url)) {
                return true;
            }
            Object fileType = FILE_TYPE.lookUp(params);
            File dir = DataUtilities.urlToFile((URL)url);
            return dir.isDirectory() && (fileType == null || "shapefile".equals(fileType));
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean canProcess(URL f) {
        return f != null && f.getFile().toUpperCase().endsWith("SHP");
    }

    public static class ShpFileStoreFactory
    implements FileStoreFactory {
        ShapefileDataStoreFactory shpFactory;
        Map originalParams;

        public ShpFileStoreFactory(ShapefileDataStoreFactory factory, Map originalParams) {
            this.shpFactory = factory;
            this.originalParams = originalParams;
        }

        @Override
        public DataStore getDataStore(File file) throws IOException {
            URL url = DataUtilities.fileToURL((File)file);
            if (this.shpFactory.canProcess(url)) {
                HashMap<String, Serializable> params = new HashMap<String, Serializable>(this.originalParams);
                params.put(ShapefileDataStoreFactory.URLP.key, url);
                return this.shpFactory.createDataStore(params);
            }
            return null;
        }
    }
}

