/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.ng.files;

import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.geotools.data.shapefile.ng.files.FileWriter;
import org.geotools.data.shapefile.ng.files.ShpFiles;

public class WritableByteChannelDecorator
implements WritableByteChannel {
    private final WritableByteChannel wrapped;
    private final ShpFiles shapefileFiles;
    private final URL url;
    private final FileWriter requestor;
    private boolean closed;

    public WritableByteChannelDecorator(WritableByteChannel newChannel, ShpFiles shapefileFiles, URL url, FileWriter requestor) {
        this.wrapped = newChannel;
        this.shapefileFiles = shapefileFiles;
        this.url = url;
        this.requestor = requestor;
        this.closed = false;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.wrapped.write(src);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.wrapped.close();
        }
        finally {
            if (!this.closed) {
                this.closed = true;
                this.shapefileFiles.unlockWrite(this.url, this.requestor);
            }
        }
    }

    @Override
    public boolean isOpen() {
        return this.wrapped.isOpen();
    }
}

