/*
 * Decompiled with CFR 0.152.
 */
package ru.concel.routing.astar;

import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.set.hash.TLongHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.FutureTask;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import ru.concel.routing.astar.Node;
import ru.concel.routing.astar.NodeFactory;
import ru.concel.routing.astar.NodeFactoryIsNotInstalled;
import ru.concel.routing.astar.NodeHeap;
import ru.concel.routing.astar.PathNode;
import ru.concel.routing.astar.fitness.AStarDistancesCalculator;
import ru.concel.routing.astar.fitness.DistanceCalculaionResult;
import ru.concel.routing.astar.path.CalculatedPath;
import ru.concel.routing.astar.path.Point;
import ru.concel.routing.astar.path.Segment;
import ru.concel.routing.astar.transport.LinkParameters;
import ru.concel.routing.astar.transport.TagsMatching;
import ru.concel.routing.astar.transport.TransportType;
import ru.concel.routing.map.LinkMode;
import ru.concel.routing.map.RouteFromStartToLink;
import ru.concel.routing.map.RoutingMap;

public class AStar {
    private static Logger logger = Logger.getLogger(AStar.class);
    private RoutingMap map;
    private AStarDistancesCalculator heuristic;
    private TLongHashSet closedList = new TLongHashSet();
    private SortedNodeList openList = new SortedNodeList();
    private TransportType[] types;
    private static HashMap<String, Long> typeNames = new HashMap();
    private static HashMap<String, TransportType> tranTypes = new HashMap();

    public AStar(RoutingMap map, AStarDistancesCalculator heuristic) throws NodeFactoryIsNotInstalled {
        if (!Node.getFactory().isPresent()) {
            Node.setFactory(new NodeFactory(NodeHeap::new));
        }
        this.map = map;
        this.heuristic = heuristic;
    }

    public PathNode calcShortestPath(double lat_start, double lon_start, double lat_finish, double lon_finish, long timestart, Long[] transport, BiFunction<PathNode, SortedNodeList, FutureTask<Object>> step) throws Exception {
        int linksCount = TransportType.getRegisteredTypes().filter(t -> t.getID() == transport[0].longValue()).findFirst().get().getLinksCountForEndPoints();
        List<RouteFromStartToLink> pp0 = this.map.createLinkFromPointToMap(lat_start, lon_start, LinkMode.FROM, linksCount, new HashMap<String, String>());
        List<RouteFromStartToLink> pp1 = this.map.createLinkFromPointToMap(lat_finish, lon_finish, LinkMode.TO, linksCount, new HashMap<String, String>());
        logger.debug((Object)("calcShortestPath invoke with transport in [" + Arrays.stream(transport).map(t -> t.toString() + "(" + TransportType.getRegisteredTypes().filter(tt -> tt.getID() == t.longValue()).findFirst().map(r -> r.getTypeName() + " " + r.getSubName()).get() + ")").collect(Collectors.joining(", ")) + "]"));
        PathNode ret = this._calcShortestPath(pp0.get((int)0).id, pp1.get((int)0).id, timestart, transport, step);
        this.map.cleanTempPoints(pp0);
        this.map.cleanTempPoints(pp1);
        return ret;
    }

    public TransportType[] getTransportTypes() {
        TransportType[] transportTypeArray;
        if (this.types == null) {
            this.types = (TransportType[])TransportType.getRegisteredTypes().toArray(TransportType[]::new);
            transportTypeArray = this.types;
        } else {
            transportTypeArray = this.types;
        }
        return transportTypeArray;
    }

    public TransportType[] getDefaultTransportTypes() {
        return (TransportType[])TransportType.getDefaultTypes().toArray(TransportType[]::new);
    }

    public long addTransportType(String name, String subname, List<TagsMatching.Matching> m, double maxspeed, double regularSpeed, int linksCountForEndPoints) {
        return TransportType.addType(name, subname, m, maxspeed, regularSpeed, linksCountForEndPoints);
    }

    public void updateTransportType(long id, String name, String subname, List<TagsMatching.Matching> m, double maxspeed, double regularSpeed, int linksCountForEndPoints) {
        TransportType.updateType(id, name, subname, m, maxspeed, regularSpeed, linksCountForEndPoints);
    }

    public CalculatedPath calcShortestPathJSON(double lat_start, double lon_start, double lat_finish, double lon_finish, long timestart, Long[] transport, BiFunction<CalculatedPath, SortedNodeList, FutureTask<Object>> step) throws Exception {
        PathNode current = this.calcShortestPath(lat_start, lon_start, lat_finish, lon_finish, timestart, transport, step == null ? null : (p, l) -> (FutureTask)step.apply(this.calcJSONPath((PathNode)p), (SortedNodeList)l));
        CalculatedPath ret = this.calcJSONPath(current);
        return ret;
    }

    private long getTransportID(String name) {
        if (typeNames.size() == 0) {
            Arrays.stream(this.getTransportTypes()).forEach(t -> {
                typeNames.put(t.getTypeName(), t.getID());
                tranTypes.put(t.getTypeName(), (TransportType)t);
            });
        }
        return typeNames.get(name);
    }

    private CalculatedPath calcJSONPath(PathNode current) {
        if (current == null || current.getPreviousNode() == null) {
            return new CalculatedPath(new Segment[0], "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u043e\u043b\u043e\u0436\u0438\u0442\u044c \u043c\u0430\u0440\u0448\u0440\u0443\u0442");
        }
        PathNode prev = null;
        ArrayList<Segment> segments = new ArrayList<Segment>();
        ArrayList<Point> points = new ArrayList<Point>();
        try {
            do {
                if (prev != null) {
                    points.add(0, new Point(new double[]{prev.getNode().getLon(), prev.getNode().getLat()}, prev.getArrivalTime(), prev.getDepartureTime(), prev.getNode().getTags()));
                }
                if (!(prev == null || prev.getType().equals(current.getType()) && prev.getSubtype().equals(current.getSubtype()))) {
                    HashMap<String, String> tags = new HashMap<String, String>();
                    tags.putAll(current.getNode().getTags());
                    tags.put("id", current.getNode().getId() + "");
                    points.add(0, new Point(new double[]{current.getNode().getLon(), current.getNode().getLat()}, current.getDistanceFromStart(), current.getDepartureTime(), tags));
                    segments.add(0, new Segment(prev.getTransportType().getTypeName(), this.getTransportID(prev.getTransportType().getTypeName()), points.toArray(new Point[0]), prev.getTags()));
                    points = new ArrayList();
                    current = prev;
                    prev = null;
                } else {
                    prev = current;
                }
                if (current.getPreviousNode() != null) continue;
                TransportType tt = null;
                if (tt == null && prev != null) {
                    tt = prev.getTransportType();
                }
                points.add(0, new Point(new double[]{prev.getNode().getLon(), prev.getNode().getLat()}, prev.getDistanceFromStart(), prev.getDepartureTime(), prev.getNode().getTags()));
                String tn = "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e";
                long id = -1L;
                if (tt != null) {
                    tn = tt.getTypeName();
                    id = this.getTransportID(tn);
                }
                segments.add(0, new Segment(tn, id, points.toArray(new Point[0]), prev != null ? prev.getTags() : null));
            } while ((current = current.getPreviousNode()) != null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CalculatedPath ret = new CalculatedPath(segments.toArray(new Segment[0]), "\u0413\u043e\u0442\u043e\u0432\u043e");
        return ret;
    }

    private PathNode _calcShortestPath(long start, long finish, long timestart, Long[] transport, BiFunction<PathNode, SortedNodeList, FutureTask<Object>> stepFunction) throws Exception {
        PathNode startNode = new PathNode(this.map.get(start));
        TransportType tt = TransportType.getRegisteredTypes().filter(t -> t.getID() == transport[0].longValue()).findFirst().get();
        startNode.setType(tt.getTypeName());
        startNode.setSubtype("");
        startNode.setTransportType(tt);
        PathNode goalNode = new PathNode(this.map.get(finish));
        startNode.setDistanceFromStart((double)timestart / 3600.0);
        startNode.setArrivalTime((double)timestart / 3600.0);
        startNode.setDepartureTime((double)timestart / 3600.0);
        this.closedList.clear();
        this.openList.clear();
        this.openList.add(startNode);
        while (true) {
            PathNode current = this.openList.poll();
            if (stepFunction != null) {
                stepFunction.apply(current, this.openList).get();
            }
            if (current == null) {
                return null;
            }
            if (current.getNode().getId() == goalNode.getNode().getId()) {
                return current;
            }
            this.closedList.add(current.getNode().getId());
            PathNode cr = current;
            cr.getNode().getLinks().stream().map(l -> new LinkParameters(l.getTo(), l.getWeight(), l.getTags())).forEach(linkParameters -> {
                boolean neighborIsBetter;
                PathNode np;
                if (this.closedList.contains(linkParameters.to.getId())) {
                    return;
                }
                DistanceCalculaionResult r = this.heuristic.getDistanceBetweenNeighbours(cr.getNode(), (LinkParameters)linkParameters, cr.getType(), cr.getSubtype(), cr.getTransportType(), cr.getDistanceFromStart());
                double neighborDistanceFromStart = r.depart + r.additionalFitness;
                if (!this.openList.contains(linkParameters.to.getId())) {
                    np = new PathNode(linkParameters.to);
                    neighborIsBetter = true;
                } else {
                    np = this.openList.getNode(linkParameters.to.getId());
                    boolean bl = neighborDistanceFromStart == np.getDistanceFromStart() ? pathNode.additionalFitness + r.additionalFitness < np.additionalFitness : (neighborIsBetter = neighborDistanceFromStart < np.getDistanceFromStart());
                    if (neighborIsBetter) {
                        this.openList.remove(np.getNode().getId());
                    }
                }
                if (neighborIsBetter) {
                    Map<String, String> tags = linkParameters.properties;
                    if (tags != null) {
                        tags.forEach((k, v) -> np.addTag((String)k, (String)v));
                    }
                    np.setPreviousNode(cr);
                    np.setDistanceFromStart(neighborDistanceFromStart);
                    np.setType(r.stype);
                    np.setSubtype(r.subtype);
                    np.setArrivalTime(r.arrival);
                    np.setType(r.stype);
                    np.setSubtype(r.subtype);
                    np.setTransportType(r.type);
                    np.setAdditionalFitness(pathNode.additionalFitness + r.additionalFitness);
                    np.setDepartureTime(r.depart);
                    np.setHeuristicDistanceFromGoal(this.heuristic.getAStarEstimatedDistanceToGoal(linkParameters.to, goalNode.getNode(), r.type));
                    this.openList.add(np);
                    cr.getNode().addTag("link to <a onclick=\"point(" + linkParameters.to.getId() + "," + (double)Math.round((np.getHeuristicDistanceFromGoal() + np.getDistanceFromStart()) * 1000.0) / 1000.0 + ")\" href=\"#\">" + linkParameters.to.getId() + "</a>", (double)Math.round(np.getDistanceFromStart() * 1000.0) / 1000.0 + " " + (double)Math.round(np.getHeuristicDistanceFromGoal() * 1000.0) / 1000.0 + " " + (double)Math.round((np.getHeuristicDistanceFromGoal() + np.getDistanceFromStart()) * 1000.0) / 1000.0);
                    cr.getNode().addTag("afit", "" + np.additionalFitness);
                }
            });
        }
    }

    public static class SortedNodeList {
        private PriorityQueue<PathNode> list = new PriorityQueue();
        private TLongObjectHashMap<PathNode> ids = new TLongObjectHashMap();
        private TLongHashSet removed = new TLongHashSet();

        public PathNode poll() {
            PathNode ret = this.list.poll();
            if (ret == null) {
                return null;
            }
            while (this.removed.contains(ret.getNode().getId())) {
                this.removed.remove(ret.getNode().getId());
                this.ids.remove(ret.getNode().getId());
                ret = this.list.poll();
            }
            return ret;
        }

        public Iterable<PathNode> getIterator() {
            final Iterator<PathNode> i = this.list.iterator();
            return new Iterable<PathNode>(){

                @Override
                public Iterator<PathNode> iterator() {
                    return new Iterator<PathNode>(){
                        PathNode next;

                        private void calcNext() {
                            while (i.hasNext()) {
                                this.next = (PathNode)i.next();
                                if (removed.contains(this.next.getNode().getId())) continue;
                            }
                        }

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public PathNode next() {
                            this.calcNext();
                            return this.next;
                        }
                    };
                }
            };
        }

        public void remove(long l) {
            this.removed.add(l);
        }

        public void clear() {
            this.list.clear();
            this.ids.clear();
            this.removed.clear();
        }

        public void add(PathNode node) {
            this.ids.put(node.getNode().getId(), (Object)node);
            this.list.add(node);
            this.removed.remove(node.getNode().getId());
        }

        public boolean contains(long id) {
            return this.ids.containsKey(id) && !this.removed.contains(id);
        }

        public PathNode getNode(long id) {
            if (this.removed.contains(id)) {
                return null;
            }
            return (PathNode)this.ids.get(id);
        }
    }
}

