/*
 * Decompiled with CFR 0.152.
 */
package ru.concel.routing.astar;

import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import ru.concel.routing.astar.Link;
import ru.concel.routing.astar.NodeFactory;
import ru.concel.routing.astar.NodeFactoryIsNotInstalled;

public abstract class Node {
    private static Optional<NodeFactory> factory = Optional.empty();
    private boolean linksNeedForIndex = true;

    public static boolean isNodeFactoryInstalled() {
        return factory.isPresent();
    }

    public static void setFactory(NodeFactory f) {
        factory = Optional.of(f);
    }

    public static Optional<NodeFactory> getFactory() throws NodeFactoryIsNotInstalled {
        if (!factory.isPresent()) {
            throw new NodeFactoryIsNotInstalled();
        }
        return factory;
    }

    public boolean isLinksNeedForIndex() {
        return this.linksNeedForIndex;
    }

    public void setLinksNeedForIndex(boolean linksNeedForIndex) {
        this.linksNeedForIndex = linksNeedForIndex;
    }

    public abstract boolean equals(Object var1);

    public abstract boolean isHasTags();

    public abstract void addTag(String var1, String var2);

    public abstract HashMap<String, String> getTags();

    public abstract Set<Link> getLinks();

    public abstract boolean isReady();

    public abstract void setReady(boolean var1);

    public abstract double getLat();

    public abstract void setLat(double var1);

    public abstract double getLon();

    public abstract void setLon(double var1);

    public abstract long getId();

    public abstract void addLink(Link var1);
}

