/*
 * Decompiled with CFR 0.152.
 */
package ru.concel.routing.astar;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import ru.concel.routing.astar.Node;
import ru.concel.routing.astar.PathNodeIterator;
import ru.concel.routing.astar.transport.TransportType;

public class PathNode
implements Comparable<PathNode>,
Iterable<PathNode> {
    double distanceFromStart;
    double arrivalTime;
    double heuristicDistanceFromGoal;
    PathNode previousNode;
    double additionalFitness = 0.0;
    private String type;
    private String subtype;
    private Map<String, String> tags = new HashMap<String, String>();
    private Node node;
    private TransportType transportType;
    private double depart;

    public double getAdditionalFitness() {
        return this.additionalFitness;
    }

    public void setAdditionalFitness(double additionalFitness) {
        this.additionalFitness = additionalFitness;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public void setSubtype(String subtype) {
        this.subtype = subtype;
    }

    public void setTransportType(TransportType transportType) {
        this.transportType = transportType;
    }

    PathNode(Node node) {
        this.node = node;
    }

    public double getArrivalTime() {
        return this.arrivalTime;
    }

    public void setArrivalTime(double arrivalTime) {
        this.arrivalTime = arrivalTime;
    }

    public void addTag(String key, String val) {
        this.tags.put(key, val);
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public double getDistanceFromStart() {
        return this.distanceFromStart;
    }

    public void setDistanceFromStart(double f) {
        this.distanceFromStart = f;
    }

    public PathNode getPreviousNode() {
        return this.previousNode;
    }

    public void setPreviousNode(PathNode previousNode) {
        this.previousNode = previousNode;
    }

    public double getHeuristicDistanceFromGoal() {
        return this.heuristicDistanceFromGoal;
    }

    public void setHeuristicDistanceFromGoal(double heuristicDistanceFromGoal) {
        this.heuristicDistanceFromGoal = heuristicDistanceFromGoal;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.node.getId() == ((PathNode)obj).node.getId();
    }

    @Override
    public int compareTo(PathNode otherNode) {
        double thisTotalDistanceFromGoal = this.heuristicDistanceFromGoal + this.distanceFromStart;
        double otherTotalDistanceFromGoal = otherNode.getHeuristicDistanceFromGoal() + otherNode.getDistanceFromStart();
        if (thisTotalDistanceFromGoal < otherTotalDistanceFromGoal) {
            return -1;
        }
        if (thisTotalDistanceFromGoal > otherTotalDistanceFromGoal) {
            return 1;
        }
        if (this.additionalFitness < otherNode.additionalFitness) {
            return -1;
        }
        if (this.additionalFitness > otherNode.additionalFitness) {
            return 1;
        }
        return 0;
    }

    public Node getNode() {
        return this.node;
    }

    @Override
    public Iterator<PathNode> iterator() {
        return new PathNodeIterator(this);
    }

    public double getDepartureTime() {
        return this.depart;
    }

    public void setDepartureTime(double depart) {
        this.depart = depart;
    }

    public TransportType getTransportType() {
        return this.transportType;
    }
}

