/*
 * Decompiled with CFR 0.152.
 */
package ru.concel.routing.astar.fitness;

import java.util.Map;
import java.util.Set;
import ru.concel.routing.astar.Node;
import ru.concel.routing.astar.fitness.AStarDistancesCalculator;
import ru.concel.routing.astar.fitness.DistanceCalculaionResult;
import ru.concel.routing.astar.fitness.TravelTime;
import ru.concel.routing.astar.transport.Bus;
import ru.concel.routing.astar.transport.LinkParameters;
import ru.concel.routing.astar.transport.Pedestrian;
import ru.concel.routing.astar.transport.TransportType;

public class PathCalculator
implements AStarDistancesCalculator {
    private static final double R = 6371.0;
    private static TransportType bus = new Bus();
    private static TransportType ped = new Pedestrian();

    @Override
    public double getAStarEstimatedDistanceToGoal(Node start, Node goal, TransportType tt) {
        double slat = Math.toRadians(start.getLat());
        double slon = Math.toRadians(start.getLon());
        double glat = Math.toRadians(goal.getLat());
        double glon = Math.toRadians(goal.getLon());
        double x = (glon - slon) * Math.cos(0.5 * (glat + slat));
        double y = glat - slat;
        double dist = 6371.0 * Math.sqrt(x * x + y * y) / tt.getMaxSpeed();
        return dist;
    }

    @Override
    public DistanceCalculaionResult getDistanceBetweenNeighbours(Node current, LinkParameters parameters, String type, String subType, TransportType tt, double start) {
        DistanceCalculaionResult ret = new DistanceCalculaionResult();
        try {
            if (tt.getClass().equals(Bus.class) || tt.getClass().equals(Pedestrian.class)) {
                String hw = parameters.properties.get("infor_route_key");
                Set<Map.Entry<String, String>> es = current.getTags().entrySet();
                if (hw != null && es.stream().anyMatch(e -> ((String)e.getKey()).startsWith("shedule:" + hw))) {
                    tt = bus;
                    ret.subtype = hw;
                } else {
                    tt = ped;
                    ret.subtype = "";
                }
            } else {
                ret.subtype = subType;
            }
            ret.stype = tt.getTypeName();
            TravelTime trt = tt.getTravelTime(current, parameters, start);
            ret.depart = trt.depart;
            ret.arrival = trt.arrival;
            ret.additionalFitness = trt.additionalFitness;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            ret.arrival = Double.MAX_VALUE;
        }
        if (!("\u041f\u0435\u0448\u043a\u043e\u043c".equals(type) || "\u041f\u0435\u0448\u043a\u043e\u043c".equals(ret.stype) || type.equals(ret.stype) && subType.equals(ret.subtype))) {
            ret.depart += 0.016666666666666666;
        }
        if (!("\u041f\u0435\u0448\u043a\u043e\u043c".equals(type) || type.equals(ret.stype) && subType.equals(ret.subtype))) {
            ret.additionalFitness += 0.1;
        }
        ret.type = tt;
        return ret;
    }
}

