/*
 * Decompiled with CFR 0.152.
 */
package ru.concel.routing.astar.path;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.geotools.data.DataUtilities;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class Point {
    private Feature g;
    private Map<String, String> tg;
    private double ar;
    private double dp;
    private static GeometryFactory gf = new GeometryFactory();
    private static long p_count = 0L;

    public Map<String, String> getTg() {
        return this.tg;
    }

    public void setTg(Map<String, String> tags) {
        this.tg = new HashMap<String, String>();
        tags.entrySet().stream().filter(e -> !Arrays.stream(new String[]{"shedule:", "time:", "total%time:"}).anyMatch(s -> ((String)e.getKey()).startsWith((String)s))).forEach(e -> this.tg.put((String)e.getKey(), (String)e.getValue()));
    }

    public Feature getCr() {
        return this.g;
    }

    public void setCr(Feature geometry) {
        this.g = geometry;
    }

    public double getAr() {
        return this.ar;
    }

    public void setAr(double arrive) {
        this.ar = (double)Math.round(arrive * 10000.0) / 10000.0;
    }

    public double getDp() {
        return this.dp;
    }

    public void setDp(double departure) {
        this.dp = (double)Math.round(departure * 10000.0) / 10000.0;
    }

    public Point(Feature f, double arrive, double departure, Map<String, String> tags) {
        this.g = f;
        this.setAr(arrive);
        this.setDp(departure);
        this.setTg(tags);
    }

    public Point(double[] coordinates, double arrive, double departure, Map<String, String> tags) throws Exception {
        String type = "Point";
        SimpleFeatureType pathFType = DataUtilities.createType((String)"Point", (String)("geom:" + type + ":srid=4326"));
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(pathFType);
        builder.add((Object)gf.createPoint(new Coordinate(coordinates[0], coordinates[1])));
        this.g = builder.buildFeature("" + p_count++);
        this.setAr(arrive);
        this.setDp(departure);
        this.setTg(tags);
    }

    public Coordinate getCoordinate() {
        return ((com.vividsolutions.jts.geom.Point)((SimpleFeature)this.getCr()).getAttribute(0)).getCoordinate();
    }
}

